<?php
/*
template name: resources
*/
get_header();
$field = get_fields();
$themedata = get_fields('options');
?>

<div class="resource-page">
<?php if ($themedata['banner_bg_image']['url']) { ?>
    <div class="bg-img">
        <img src="<?php echo $themedata['banner_bg_image']['url'] ?>">
    </div>
    <?php } ?>
    <!-- banner starts -->
    <section class="banner banner-space margin-top-81">
        <div class="container">
            <div class="banner-content">
                <div class="row">
                    <div class="col-md-6">
                        <div class="blog-banner-img">
                            <?php if ($field['banner_image_link']['url']) { ?>
                                <?php if (!empty($field['banner_image_link']['url'])) { ?>
                                    <lottie-player src="<?php echo $field['banner_image_link']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                                <?php }
                            } else { ?>
                                <img src="<?php echo $field['banner_image']['url'] ?>" alt="banner-img" title="banner-img">
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="banner-heading">
                            <div class="banner-content">
                                <?php if (!empty($field['banner_heading'])) { ?>
                                    <h1><?php echo $field['banner_heading'] ?></h1>
                                <?php } ?>
                                <?php if (!empty($field['banner_heading'])) { ?>
                                    <p><?php echo $field['banner_desc'] ?></p>
                                <?php } ?>
                                <div class="custom-banner-buttons">
                                    <div class="banner-button">
                                        <?php if (!empty($field['banner_link']['url'])) { ?>
                                            <a data-bs-toggle="modal" data-bs-target="#exampleModal" href="<?php echo $field['banner_link']['url'] ?>" class="custom-buttn" target="<?php echo $field['banner_link']['target'] ?>"><?php echo $field['banner_link']['title'] ?></a>
                                        <?php } ?>
                                    </div>
                                    <div class="search-button">
                                        <form class="search-form" action="<?php echo get_site_url(); ?>" method="get">
                                            <div class="custom-search">
                                                <div class="form-group">
                                                    <input type="hidden" name="postType" value="<?php echo $postType; ?>">
                                                    <input aria-label="search" placeholder="Search here" class="form-control" type="text" value="<?php the_search_query(); ?>" name="s" id="search" required>
                                                    <button aria-label="search-button" class="search-submit-button" type="submit">
                                                        <img src="<?php echo $themedata['search_icon']['url']; ?>" alt="<?php echo $themedata['search_icon']['alt']; ?>">
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- scroll down starts -->
                <div class="scroll-down" id="<?php echo $field['scroll_down_id'] ?>">
                    <a href="#tabs" class="scrolly-centered">
                        <div class="scrollbtn scroll" id="scrollbtn">
                            <?php if (!empty($field['scroll_down_image']['url'])) { ?>
                                <img id="tabs" src="<?php echo $field['scroll_down_image']['url'] ?>" alt="<?php echo $field['scroll_down_image']['alt'] ?>" title="<?php echo $field['scroll_down_image']['title'] ?>">
                            <?php } ?>
                        </div>
                    </a>
                </div>
                <!-- scrolldown ends -->
            </div>
    </Section>
    <!-- banner ends -->
    <div class="modal fade" id="exampleModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-close">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <?php if (!empty($field['hubspot_form_image']['url'])) { ?>
                                <div class="pop-uo-img">
                                    <img src="<?php echo $field['hubspot_form_image']['url'] ?>" alt="<?php echo $field['hubspot_form_image']['alt'] ?>" title="<?php echo $field['hubspot_form_image']['title'] ?>">
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-md-6">
                            <div class="pop-up-form">
                                <?php if (!empty($field['hubspot_form_heading'])) { ?>
                                    <h5> <?php echo $field['hubspot_form_heading'] ?></h5>
                                <?php } ?>
                                <?php if (!empty($field['hubspot_form_subheading'])) { ?>

                                <?php } ?>
                                <script charset="utf-8" type="text/javascript" src="//js-eu1.hsforms.net/forms/v2.js"></script>
                                <script>
                                    hbspt.forms.create({
                                        region: "eu1",
                                        portalId: "25106816",
                                        formId: "367c970e-4456-4b78-b0cc-75a0e863dddf",
                                        version: "V2_PRERELEASE"
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- blogs starts -->
    <section class="blogs">
        <div class="container">
            <div class="blog-content">
                <div class="row">


                    <div class="col-lg-12 col-12">
                        <div class="blog-tab-content">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="blog-carousel">
                                        <?php
                                        $wpb_all_query = new WP_Query(array(
                                            'post_type' => 'post',
                                            'post_status' => 'publish',
                                            'posts_per_page' => 3,
                                            'orderby' => 'publish_time',
                                            'order' => 'desc',
                                        ));
                                        $count = true;
                                        $count2 = true;
                                        $i = 0;
                                        $myCount = $wpb_all_query->found_posts;
                                        ?>
                                        <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                                            <div class="carousel-indicators">
                                                <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
                                                    <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="<?php echo $i ?>" class="<?php if ($count2) { {
                                                                                                                                                                            echo "active";
                                                                                                                                                                        }
                                                                                                                                                                    } ?>" aria-label="Slide 1"></button>
                                                    <?php $count2 = false;
                                                    $i++; ?>

                                                <?php endwhile; ?>
                                            </div>

                                            <div class="carousel-inner">

                                                <?php
                                                foreach ($field['feature_posts'] as $cd) {
                                                ?>
                                                    <?php if ($wpb_all_query->have_posts()) : $wpb_all_query->the_post();
                                                        $featurepost = $cd['feature_post'];
                                                        $pid = $featurepost->ID;
                                                        $featuredTitle = get_the_title($pid);
                                                        $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($pid), 'full');
                                                        $thumbnail = get_the_post_thumbnail();
                                                        $image_id = get_post_thumbnail_id($pid);
                                                        $image_title = get_the_title($image_id);
                                                        $category = get_the_category($pid);
                                                        $permalinkk = get_the_permalink($pid);
                                                        $excerpt    = get_the_excerpt();
                                                        $excerpt = substr($excerpt, 0, 200);
                                                        $date = get_the_date();
                                                    ?>

                                                        <div class="carousel-item <?php if ($count) {
                                                                                        echo "active";
                                                                                    } ?>">
                                                            <?php $count = false; ?>
                                                            <div class="blog-heading-content">
                                                                <div class="blog-content-photo">
                                                                    <figure>
                                                                        <?php
                                                                        if (!empty($thumbnail)) :
                                                                            echo $thumbnail;
                                                                        else :
                                                                        ?>
                                                                            <img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png" alt="No Preview">
                                                                        <?php
                                                                        endif;
                                                                        ?>
                                                                    </figure>
                                                                </div>
                                                                <div class="blog-heading-text">
                                                                    <h6><?= the_title(); ?></h6>
                                                                    <p><?= esc_html($excerpt) ?>
                                                                    </p>
                                                                    <a class="title-button" href="<?php echo the_permalink(); ?>">View More</a>
                                                                </div>
                                                            </div>
                                                        </div>

                                                <?php
                                                    endif;
                                                }
                                                ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                $paged     = (get_query_var('paged')) ? get_query_var('paged') : 1;
                                $args      = array(
                                    'paged'          => $paged,
                                    'post_type'      => 'post',
                                    'post_status'    => 'publish',
                                    'posts_per_page' => 9,
                                    'orderby'        => 'modified',
                                    'order'          => 'desc',
                                );
                                $the_query = new WP_Query($args);
                                ?>
                                <?php
                                wp_reset_postdata();
                                if ($the_query->have_posts()) :
                                    while ($the_query->have_posts()) :
                                        $the_query->the_post();
                                        $postID     = get_the_id();
                                        $postTitle  = get_the_title($postID);
                                        $thumbnail  = get_the_post_thumbnail();
                                        $categories = get_the_category($postID);
                                        $excerpt    = get_the_excerpt($postID);
                                        $excerpt    = substr($excerpt, 0, 70);
                                        $date       = get_the_date('M j, Y', $postID);
                                        $author     = get_the_author($postID);
                                ?>
                                        <div class="col-lg-4 col-md-6 col-12">
                                            <div class="blog-post-subcontent">
                                                <div class="blog-post-content">
                                                    <figure>
                                                        <?php
                                                        if (!empty($thumbnail)) :
                                                            echo $thumbnail;
                                                        else :
                                                        ?>
                                                            <img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png" alt="No Preview">
                                                        <?php
                                                        endif;
                                                        ?>
                                                    </figure>
                                                    <div class="blog-post-white-text">
                                                        <div class="blog-post-white-text-left-text">
                                                            <h6><?php echo esc_html($categories[0]->name) ?></h6>
                                                        </div>
                                                        <div class="blog-post-white-text-right-text">
                                                            <i class="fa fa-calendar-o" aria-hidden="true"></i>
                                                            <h6><?php echo esc_html($date) ?></h6>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="blog-title-content">
                                                    <a href="<?php echo get_the_permalink() ?>">
                                                        <h4> <?php echo esc_html($postTitle) ?></h4>
                                                    </a>
                                                    <p><?php echo esc_html($excerpt) ?>...</p>
                                                    <a class="title-button" href="<?php echo get_the_permalink() ?>">View More</a>
                                                </div>
                                            </div>
                                        </div>

                                    <?php
                                    endwhile;
                                else :
                                    ?>
                                    <div class="alert alert-info text-center w-100 mb-0">
                                        <p>There Are No Posts Under This Category </p>
                                    </div>
                                <?php
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>

                    <!--pagination-->
                    <div class="pagination-outer">
                        <div class="pagination">
                            <?php if ($the_query->max_num_pages > 1) { ?>
                                <a class="prev page-numbers" href="<?php echo get_pagenum_link(); ?>"><i class="fa fa-angle-double-left" aria-hidden="true"></i></a>

                            <?php
                            }
                            $big = 999999999;

                            echo paginate_links(array(
                                'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                                'format'    => '?paged=%#%',
                                'current'   => max(1, get_query_var('paged')),
                                'total'     => $the_query->max_num_pages,
                                'prev_next'    => true,
                                'prev_text' => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                                'next_text' => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
                            ));
                            ?>
                            <?php if ($the_query->max_num_pages > 1) { ?>
                                <a class="prev page-numbers" href="<?php site_url(); ?>/marketing-insights/page/<?php echo  $the_query->max_num_pages; ?>"><i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                    <!--pagination ends-->
                </div>
    </section>
    <!-- blogs endss -->
    <!-- StillMaking starts-->

    <?php
    get_template_part('/includes/gradient', 'section', $field); ?>
    <!-- StillMaking ends-->



    <?php get_footer()  ?>