<?php
/*Template Name: sales force Template*/
/*Template Description: sales force Template*/
get_header();
$field = get_fields();
$themedata = get_fields('options');
?>
<style>
    .sales-slider{
        text-align:center;
    }
    .sales-slider h2 {
        color: #163567;
        font-weight: bold;
        font-size: 48px;
        margin-top: 50px;
        letter-spacing: 0.2px;
    }
    .sales-slider p {
        color: #1A1A1A;
        font-weight: bold;
        font-size: 20px;
        letter-spacing: 0.14px;
    }
    .salesforce-banner {
        padding: 281px 0 200px;
    }
    #sales-force .owl-item.active.center .sales-slider figure img {
        transform: scale(1.3);
    }
    #sales-force .owl-item {
        opacity: 1;
    }
    #sales-force .owl-item.active.center {
        opacity: 1 !important;
    }
    .space-top-bottom {
        padding: 120px 0 100px;
    }
    .hover-outer-box {
        text-align: center;
        padding: 10px;
    }
    .hover-outer-box h3 {
        font-size: 28px;
        font-weight: bold;
        padding: 26px 20px;
        min-height: 118px;
    }
    .hover-outer-box figure img {
        margin-top: 20px;
    }
    section.space-tb {
        padding: 100px 0 200px;
    }
    .hover-outer-box:hover {
        box-shadow: 5px 8px 99px #00000021;
        background: #fff;
        border-radius: 20px;
    }
    .hover-outer-box p {
        font-size: 20px;
        letter-spacing: .12px;
    }
    .sales-forces-slider .owl-carousel .owl-nav button.owl-next, 
    .sales-forces-slider .owl-carousel .owl-nav button.owl-prev{
        height: 100%;
        top: 0;
        position: absolute;
        width: 20%;
        opacity: 0;
        cursor: w-resize;
        font-size:0;
    }
    .sales-forces-slider .owl-carousel .owl-nav button.owl-next{
        right:0;
    }
    .sales-form{
        background: #FFFFFF 0% 0% no-repeat padding-box;
        border-radius: 40px;
        padding:60px;
    }
    .sales-form h3{
        font-size: 38px;
        line-height:62px;
        font-weight:900;
        letter-spacing: 0.16px;
        color: #163567;
        text-align:center;
        margin-bottom:50px;
    }
@media only screen and (min-width: 1701px){ 
    .page-template-sales-force .bg-img {
        top: -400px;
    }
}
@media only screen and (min-width: 1000px){
    #sales-force .owl-stage-outer{
        padding-top:100px;
    }
    #sales-force .owl-item.active.center figure {
    margin-top: -100px;
    margin-bottom: 150px;
}
}
@media only screen and (max-width: 1024px){
    .salesforce-banner {
        padding: 190px 0 200px;
    }
    .sales-form {
        padding: 30px;
    }
    .sales-form h3{
        font-size: 30px;
        line-height:45px;
    }
}

@media only screen and (max-width: 991px){ 
    .sale-banner-space{
        background:#0b1b34
    }
    .salesforce-banner {
        padding: 141px 0 60px;
    }
    .space-top-bottom{
        padding:80px 20px 0;
    }
    section.space-tb{
        padding:0 0 80px;
    }
    #sales-force .owl-item.active.center .sales-slider figure img {
    transform: scale(1);
}
}
@media only screen and (max-width: 767px){
    .hover-outer-box h3{
        min-height:auto;
    }
    .sales-form h3 {
    font-size: 28px;
    line-height: 40px;
}
}


</style>
<div class="bg-img">
        <img src="../wp-content/uploads/2022/11/Footer.svg">
    </div>
<section class="sale-banner-space">
    <div class="salesforce-banner ">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-12">
                    <div class="sales-content">
                        <div class="banner-heading">
                            <h1>Improve Your Salesforce Data Quality</h1>
                            <p>The quality of your marketing data in Salesforce impacts your marketing ROI. Ensure campaigns, marketing touchpoints, leads are accurately attributed to revenue
                            and ascertain the quality of your marketing data by getting a complimentary audit.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="sales-form">
                        <h3>Get a Complimentary Audit</h3>
                    <script charset="utf-8" type="text/javascript" src="//js-eu1.hsforms.net/forms/embed/v2.js"></script>
                    <script>
                    hbspt.forms.create({
                        region: "eu1",
                        portalId: "25106816",
                        formId: "9f71a2b1-5fa5-41ee-a8a3-c05b275db1d1"
                    });
                    </script>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="space-top-bottom sales-forces-slider">
<div class="owl-carousel owl-theme " id="sales-force">
    <div class="item">
        <div class="sales-slider">
            <figure>
                <img src="../wp-content/uploads/2023/01/deill-2.png">
            </figure>
            <h2>Drill-Don Into Lead Data</h2>
            <p>Get to Know quality of your lead data and how you can improve it</p>
        </div>
    </div>
    <div class="item">
        <div class="sales-slider">
            <figure>
                <img src="../wp-content/uploads/2023/01/salesforce-quality.png">
            </figure>
            <h2>Overall Salesforce Data Quality</h2>
            <p>Get a high-level overview of the quality of your marketing data in Salesforce so that you can improve your marketing ROI</p>
        </div>
    </div>
    <div class="item">
        <div class="sales-slider">
            <figure>
                <img src="../wp-content/uploads/2023/01/drill-down.png">
            </figure>
            <h2>Opportunity & Contact Data Quality</h2>
            <p>Know more about the state of your opportunity and contact data</p>
        </div>
    </div>
</div>
</section >
<section class="space-tb">
    <div class="container">
        <div class="row">
            <div class="col-xl-3 col-md-6 col-12">
                <div class="hover-outer-box">
                    <figure><img src="../wp-content/uploads/2023/01/lead.png"></figure>
                    <h3>Lead to Account Matching</h3>
                    <p>Ensure that the right leads are connected to the right accounts</p>
                </div>
            </div>
            <div class="col-xl-3 col-md-6 col-12">
                <div class="hover-outer-box">
                    <figure><img src="../wp-content/uploads/2023/01/identify.png"></figure>
                    <h3>Identify Customers in Leads</h3>
                    <p>Minimize the chance of sending sales emails to customers</p>
                </div>
                </div>
            <div class="col-xl-3 col-md-6 col-12">
                <div class="hover-outer-box">
                    <figure><img src="../wp-content/uploads/2023/01/data.png"></figure>
                    <h3>Ensure Data Completeness</h3>
                    <p>Make better marketing and sales decision by having access to accurate data</p>
                </div>
                </div>
            <div class="col-xl-3 col-md-6 col-12">
                <div class="hover-outer-box">
                    <figure><img src="../wp-content/uploads/2023/01/duplicates.png"></figure>
                    <h3>Identify Duplicates</h3>
                    <p>Save cost and focus on leads that matter by removing duplicates</p>
                </div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php
  get_template_part('/includes/gradient', 'section', $themedata); ?>
  <!-- StillMaking ends-->
</div>
<script>
  
</script>
<?php get_footer()  ?>
</div>