<?php
/*
template name:single blog
Template Post Type: post, page, product
*/
get_header();
the_post();
$themedata = get_fields('options');
$field = get_fields();
?>
<div class="blog-detail-page">
    <!-- blog-detail banner starts -->
    <section class="banner">
        <div class="container">
            <div class="banner-details">
                <div class="row">
                    <?php
                    if (have_posts()) {
                        while (have_posts()) {
                            the_post();
                            $postID     = get_the_id();
                            $postTitle  = get_the_title($postID);
                            $thumbnail  = get_the_post_thumbnail();
                            $categories = get_the_category($postID);
                            $date       = get_the_date('M j, Y', $postID);
                            $author     = get_the_author($postID);
                            $page_url = get_permalink($post->ID);
                            $title    = get_the_title(get_the_ID());
                        }
                    }

                    ?>
                    <div class="col-lg-6">
                        <div class="banner-img">
                              <?php if (!empty($field['blog_banner_image']['url'])) { ?>
                             <img class="single-blog-banner-img" src="<?php echo $field['blog_banner_image']['url'] ?>" alt="<?php echo $field['blog_banner_image']['alt'] ?>"> 
                             <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="banner-text">
                            <div class="banner-upper-text">
                                <h6><?php echo get_the_category($postID)[0]->cat_name ?></h6>
                                <h1><?php echo single_post_title($postID) ?></h1>
                                <p><?php echo the_content($postID) ?></p>
                            </div>
                            <div class="banner-lower-text">
                                <p>By <?php echo get_the_author($postID); ?></p> <p><?php echo get_the_date('M j, Y', $postID); ?></p>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </section>

    <!-- blog-detail banner starts -->
    <!-- blog-detail section starts -->
    <section class="blog-details">
        <div class="container">
            <div class="blog-detail-contents">
                <div class="row">

                    <div class="col-lg-3">
                        <div class="table-of-contents">
                                <h4><?php echo $themedata['single_page_blog_content_heading'] ?></h4>
                                <ul class="table-list">
                                <?php $i=0 ?>
                                    <?php foreach ($field['content_headings'] as $val) { ?>                         
                                        <li><a href="#scroll-<?php echo $i= $i+1 ?>"  class="nav-link "><i class="fa fa-check" aria-hidden="true" ></i>                                   
                                                <p><?php echo $val['content_heading'] ?></p>
                                            </a></li>
                                    <?php }   $i++; ?>
                                  
                                </ul>
                        </div>

                    </div>

                    <div class="col-lg-9">
                    <div class="col-md-12">
                        <div class="blog-detail-info">
                         <?php echo $field['blog_detail_content'] ?>
                        </div>
                    </div>
                        <div class="blog-detail-subcontent">
                        <?php if (!empty($field['blog_subheading_option'])) { ?>
                            <<?php echo $field['blog_subheading_option'] ?>>
                            <?php } ?>
                            <?php echo $field['blog_subheading_text'] ?>
                            <?php if (!empty($field['blog_subheading_option'])) { ?>
                            </<?php echo $field['blog_subheading_option'] ?>>
                            <?php } ?>
                            <?php echo $field['blog_content'] ?>
                        </div>
                       
                        <div class="head-link" >
                        <?php $i=0 ?>
                            <?php foreach ($field['scroll_content'] as $val) { ?>
                                <?php if (!empty($val['scroll_heading'])) { ?>
                                    <div class="scroll-margin"  id="scroll-<?php echo $i+1 ?>"></div>
                                    <?php if (!empty($val['scroll_heading_option'])) { ?>
                                    <<?php echo $val['scroll_heading_option']; ?>>
                                    <?php } ?>
                                    <?php echo $val['scroll_heading']; ?>
                                    <?php if (!empty($val['scroll_heading_option'])) { ?>
                                    </<?php echo $val['scroll_heading_option']; ?>>
                                    <?php } ?>
                                    <?php $i++; ?>
                                <?php } ?>
                                <?php foreach ($val['scroll_subheadings'] as $cval) { ?>

                                    <?php echo $cval['scroll_subheading']; ?>

                                    <?php if (!empty($cval['scroll_image']['url'])) { ?>
                                        <div class="link-detail-content">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="list-photo">
                                                        <img src=" <?php echo $cval['scroll_image']['url']; ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="list-text">
                                                        <?php echo $cval['image_content']; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                            <?php }
                            } ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    </div>
    <?php get_template_part('/includes/recent', 'post', $currentPage); ?>
       <!-- StillMaking starts-->

       <?php
 get_template_part('/includes/gradient', 'section' , $themedata); ?>
    <!-- StillMaking ends-->


<?php wp_reset_postdata() ?>
<?php get_footer()  ?>