<?php
/*
template name: solution
*/
get_header();
$field = get_fields();
$themedata = get_fields('options');
?>

<div class="solution-page">
<?php if ($themedata['banner_bg_image']['url']) { ?>
    <div class="bg-img">
        <img src="<?php echo $themedata['banner_bg_image']['url'] ?>">
    </div>
    <?php } ?>

     <!-- banner section starts -->
     <?php get_template_part('/includes/banner', 'section', $field); ?>
    <!-- banner section ends -->
    <!-- Diggrowth For CMOs starts -->
    
    <section class="digg-for-cmo">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['carousel_main_heading'])) { ?> <h2>
                    <?php echo $field['carousel_main_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['carousel__main_subeading'])) { ?>
                <p><?php echo $field['carousel__main_subeading'] ?></p>
                <?php } ?>
            </div>
            <div class="digg-for-cmo-content">
                <div class="screenshot_slider owl-carousel">
                    <?php foreach ($field['carousel_cards'] as $cval) { ?>
                    <div class="item">
                        <div class="cmo-subcontent">
                            <div class="cmo-photo">
                            <?php if (!empty($cval['carousel_image']['url'])) { ?>
                                <img src="<?php echo $cval['carousel_image']['url'] ?>"
                                    alt="<?php echo $cval['carousel_image']['alt'] ?>"
                                    title="<?php echo $cval['carousel_image']['alt'] ?>">
                                    <?php } ?>
                            </div>
                            <div class="cmo-text">
                                <?php if (!empty($cval['carousel_heading'])) { ?>
                                <h5><?php echo $cval['carousel_heading'] ?>
                                </h5>
                                <?php } ?>
                                <?php if (!empty($cval['carousel_subheading'])) { ?>
                                <p><?php echo $cval['carousel_subheading'] ?>
                                </p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php } ?>

                </div>
            </div>
        </div>

    </section>
    <!-- Diggrowth For CMOs ends -->
    <!-- How Will You Use Diggrowth? starts -->
    <section class="use-diggrowth">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['card_hover_main_heading'])) { ?> <h2>
                    <?php echo $field['card_hover_main_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['card_hover_main_subheading'])) { ?>
                <p><?php echo $field['card_hover_main_subheading'] ?></p>
                <?php } ?>
            </div>
            <div class="use-diggroth-content">
                <div class="row">
                    <?php foreach ($field['cards'] as $cval) { ?>

                    <div class="col-lg-4 col-md-6 col-12">
                    <?php if (!empty($cval['card_link']['url'])) { ?> 
                        <a href="<?php echo $cval['card_link']['url'] ?>"
                            target="<?php echo $cval['card_link']['target'] ?>">
                            <?php } ?>
                            <div class="main-box">
                                <div class="use-diggrowth-subcontent">
                                    <div class="use-diggrowth-subcontent-photo">
                                    <?php if (!empty($cval['card_image']['url'])) { ?> 
                                        <img src="<?php echo $cval['card_image']['url'] ?>"
                                            alt="<?php echo $cval['card_image']['alt'] ?>"
                                            title="<?php echo $cval['card_image']['alt'] ?>">
                                            <?php } ?>
                                    </div>
                                    <div class="use-diggrowth-subcontent-text">
                                        <?php if (!empty($cval['card_heading'])) { ?>
                                        <h5><?php echo $cval['card_heading'] ?>
                                        </h5>
                                        <?php } ?>
                                        <?php if (!empty($cval['card_subheading'])) { ?>
                                        <p><?php echo $cval['card_subheading'] ?>
                                        </p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>

                    <?php } ?>

                </div>
            </div>
        </div>
    </section>
    <!-- How Will You Use Diggrowth? ends -->

    <!-- More Resources To Offer starts -->
    <?php get_template_part('/includes/recent', 'post', $currentPage); ?>
    <!-- More Resources To Offer ebds -->
    <!-- StillMaking starts-->

    <?php
 get_template_part('/includes/gradient', 'section' , $field); ?>
    <!-- StillMaking ends-->



</div>
<?php get_footer()  ?>