<?php
//directory
$understrap_inc_dir = 'components';
// Array of files to include.
$understrap_includes = array(
'/contactform-hubspot-function.php', // contactform integration with hubspot
'/contactform-hubspot-integration.php', // contactform integration with hubspot
'/contactform-hubspot-resource-page-subscribe.php', // contactform integration with hubspot
'/contactform-hubspot-ebook-marketing-attribution.php', // contactform Ebook integration with hubspot
'/contactform-hubspot-diggrowth-vs-bizible-capabilities.php', // contactform Ebook integration with hubspot
'/contactform-hubspot-get-demo.php', // Get Demo with hubspot
'/contactform-hubspot-ebook-everything-you-need.php', // contactform Ebook integration with hubspot
'/contactform-hubspot-pricing-page.php', // contactform Ebook integration with hubspot
'/contactform-hubspot-ebook-tracking-the-customer-journey.php', // contactform Ebook integration with hubspot
'/contactform-hubspot-the-state-of-marketing-analytics.php', // contactform Ebook integration with hubspot
);
foreach ($understrap_includes as $file) {
	require_once get_theme_file_path($understrap_inc_dir . $file);
}
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

function add_theme_scripts() {
  wp_enqueue_style( 'font-awesome-css', get_stylesheet_directory_uri() . '/css/font-awesome.min.css', array(), '1.1', 'all' );
  wp_enqueue_style( 'bootstrap-css', get_stylesheet_directory_uri() . '/css/bootstrap.min.css', array(), '1.1', 'all' );
  wp_enqueue_style( 'animation-style', get_stylesheet_directory_uri() . '/css/animation.css' );
  wp_enqueue_style( 'custom-style', get_stylesheet_directory_uri() . '/css/custom-style.css' );

  wp_enqueue_script( 'bootstrap-js', get_stylesheet_directory_uri() . '/js/bootstrap.min.js', array( 'jquery' ), 1.1, true );
	wp_enqueue_script('animation-weather-js',get_stylesheet_directory_uri() . '/js/animation-script.js', array('jquery'), false, true );
  wp_enqueue_script('custom-script', get_stylesheet_directory_uri() . '/js/custom-script.js', array('jquery'), false, true );
  wp_enqueue_script('datalayer-script', get_stylesheet_directory_uri() . '/js/datalayer.js', array('jquery'), false, true );
  if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
    wp_enqueue_script( 'comment-reply' );
  }
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );
function enqueue_styles_new() {
	if ( ( is_page_template( 'templates/template-homepage.php' )  || ( is_page_template( 'templates/template-homepage.php' ) ) )) {
	  wp_enqueue_style( 'perry-weather', get_stylesheet_directory_uri() . '/css/perry-weather.css' );
	wp_enqueue_script('perry-weather-js',get_stylesheet_directory_uri() . '/js/perry-weather.js', array('jquery'), false, true );
    }
    if ( ( is_page_template( 'templates/template-homepage.php' )  || ( is_page_template( 'templates/template-resource.php' ) ) || ( is_page_template( 'templates/template-infographics.php' ) ) || ( is_page_template( 'templates/template-blog.php' ) ) )) {
      wp_enqueue_style('slick-default-style', get_stylesheet_directory_uri() . '/css/slick.css');
      wp_enqueue_script('slick-script', get_stylesheet_directory_uri() . '/js/slick.js', array('jquery'), false, true );
    }
    if ( ( is_page_template( 'templates/template-resource.php' )  ||  ( is_page_template( 'templates/template-blog.php' ) ) )) {
        wp_enqueue_script('simplePagination-script', get_stylesheet_directory_uri() . '/js/jquery.simplePagination.js', array('jquery'), false, true );
    }
}
add_action( 'wp_enqueue_scripts', 'enqueue_styles_new' );

if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'twenty-twenty-one-style','twenty-twenty-one-style','twenty-twenty-one-print-style' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION

add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype($filename, $mimes);
    return [
      'ext'             => $filetype['ext'],
      'type'            => $filetype['type'],
      'proper_filename' => $data['proper_filename']
    ];
  }, 10, 4);
function cc_mime_types($mimes)
{
$mimes['svg'] = 'image/svg+xml';
return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');
function fix_svg()
{
echo '<style type="text/css">
        .attachment-266x266, .thumbnail img {
                width: 100% !important;
                height: auto !important;
        }
        </style>';
}
add_action('admin_head', 'fix_svg');
  //  end allow SVG


//----------------- Custom Field Theme option setting -----------------------

  if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title'    => 'Theme General Settings',
        'menu_title'    => 'Theme Settings',
        'menu_slug'     => 'theme-general-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));

    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Header Settings',
        'menu_title'    => 'Header',
        'parent_slug'   => 'theme-general-settings',
    ));

    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Footer Settings',
        'menu_title'    => 'Footer',
        'parent_slug'   => 'theme-general-settings',
    ));

}
//----------------- Custom Field Theme option setting -----------------------
/*------------------ Custom Post Types------------------------*/
function my_post_type_ebook() {
  register_post_type( 'ebook',
                 array(
  'label' => __('Ebook'),
  'singular_label' => __('ebook', 'we'),
  '_builtin' => false,
  'public' => true,
  'show_ui' => true,
  'show_in_nav_menus' => true,
  'hierarchical' => true,
  'capability_type' => 'page',
  'rewrite' => array(
  'slug' => 'ebook',
  'with_front' => FALSE,
  ),
  'supports' => array(
  'title',
  'editor',
  'thumbnail',
  'custom-fields'
  )
  )
  );

  register_taxonomy('ebook_categories', 'ebook', array('hierarchical' => true, 'label' => 'Ebook Categories', 'singular_name' => 'ebook-category', 'rewrite' => array( 'slug' => 'ebook' ), "query_var" => true));
  }
add_action('init', 'my_post_type_ebook');

function my_post_type_infographics() {
    register_post_type( 'infographics',
                   array(
    'label' => __('Infographics'),
    'singular_label' => __('infographics', 'we'),
    '_builtin' => false,
    'public' => true,
    'show_ui' => true,
    'show_in_nav_menus' => true,
    'hierarchical' => true,
    'capability_type' => 'page',
    'rewrite' => array(
    'slug' => 'infographics',
    'with_front' => FALSE,
    ),
    'supports' => array(
    'title',
    'editor',
    'thumbnail',
    'custom-fields'
    )
    )
    );
register_taxonomy('infographics_categories', 'infographics', array('hierarchical' => true, 'label' => 'Infographics Categories', 'singular_name' => 'infographics-category', 'rewrite' => array( 'slug' => 'infographics' ), "query_var" => true));
}
add_action('init', 'my_post_type_infographics');

function my_post_type_press_release() {
    register_post_type( 'press-release', array(
      'label' => __('Press Release'),
      'singular_label' => __('press-release', 'we'),
      '_builtin' => false,
      'public' => true,
      'show_ui' => true,
      'show_in_nav_menus' => true,
      'hierarchical' => true,
      'capability_type' => 'page',
      'rewrite' => array(
      'slug' => 'press-release',
      'with_front' => FALSE,
      ),
      'supports' => array(
      'title',
      'editor',
      'thumbnail',
      'custom-fields'
      )
      )
      );

    register_taxonomy('press_release_categories', 'press-release', array('hierarchical' => true, 'label' => 'Press Release Categories', 'singular_name' => 'press-release-category', 'rewrite' => array( 'slug' => 'press-release' ), "query_var" => true));
}

add_action('init', 'my_post_type_podcast');

function my_post_type_podcast() {
    register_post_type( 'podcast', array(
        'label' => __('Podcast'),
        'singular_label' => __('podcast', 'we'),
        '_builtin' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => true,
        'capability_type' => 'page',
        'rewrite' => array(
        'slug' => 'podcast',
        'with_front' => FALSE,
        ),
        'supports' => array(
        'title',
        'editor',
        'thumbnail',
        'custom-fields'
        )
        )
        );

    register_taxonomy('press_release_categories', 'podcast', array('hierarchical' => true, 'label' => 'Podcast Categories', 'singular_name' => 'podcast-category', 'rewrite' => array( 'slug' => 'podcast' ), "query_var" => true));
}

add_action('init', 'my_post_type_press_release');

function my_post_type_product() {
    register_post_type( 'product',
                   array(
    'label' => __('Product'),
    'singular_label' => __('product', 'we'),
    '_builtin' => false,
    'public' => true,
    'show_ui' => true,
    'show_in_nav_menus' => true,
    'hierarchical' => true,
    'capability_type' => 'page',
    'rewrite' => array(
    'slug' => 'product',
    'with_front' => FALSE,
    ),
    'supports' => array(
    'title',
    'editor',
    'thumbnail',
    'custom-fields'
    )
    )
    );
register_taxonomy('product_categories', 'product', array('hierarchical' => true, 'label' => 'Product Categories', 'singular_name' => 'product-category', 'rewrite' => array( 'slug' => 'product' ), "query_var" => true));
}
add_action('init', 'my_post_type_product');



function my_post_type_kpi() {
    register_post_type( 'kpi', array(
      'label' => __('KPI Post'),
      'singular_label' => __('kpi', 'we'),
      '_builtin' => false,
      'public' => true,
      'show_ui' => true,
      'show_in_nav_menus' => true,
      'hierarchical' => true,
      'capability_type' => 'page',
      'rewrite' => array(
      'slug' => 'kpi',
      'with_front' => FALSE,
      ),
      'supports' => array(
      'title',
      'editor',
      'thumbnail',
      'custom-fields'
      )
      )
      );

    register_taxonomy('kpi_categories', 'kpi', array('hierarchical' => true, 'label' => 'KPI Categories', 'singular_name' => 'kpi-category', 'rewrite' => array( 'slug' => 'kpi' ), "query_var" => true));
}

add_action('init', 'my_post_type_kpi');
/*------------------ Custom Post Types end------------------------*/

add_shortcode( 'newsroom-slider', 'slidermy' );
function slidermy( $atts ) {
    ob_start();
    $query = new WP_Query( array(
        'post_type' => 'post',
        'posts_per_page' => 5,
         'orderby' => 'publish_date',
        'order' => 'DESC',
    ) );
    if ( $query->have_posts() ) { ?>
<div class="newsroom-post slider">
    <?php
        while ( $query->have_posts() ) : $query->the_post();
        $get_page_ID = get_the_ID();
        $resource_carousel_image = get_field( "resource_carousel_image", $get_page_ID );
    ?>
    <div class="item">
        <div class="post-data">
            <?php if ( has_post_thumbnail() ) { ?>
            <div class="post-img"><a href="<?php the_permalink(); ?>" title="<?php// the_title_attribute(); ?>">
                    <?php if( !empty( $resource_carousel_image ) ): ?>
                        <img src="<?php echo esc_url($resource_carousel_image['url']); ?>" width="512" height="285" alt="<?php echo esc_attr($resource_carousel_image['alt']); ?>" />
                    <?php endif; ?>
                </a></div>
            <?php } ?>
            <div class="post-data-info">
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo wp_trim_words( get_the_content(), 8, '...' ); ?></p>
                <a class="custom-link" href="<?php the_permalink(); ?>">Read full post <span class="arrow"></span></a>
            </div>
        </div>
    </div>
    <?php endwhile;
            wp_reset_postdata(); ?>
</div>

<?php
    $myvariable = ob_get_clean();
    return $myvariable;
    }

}

add_action('wp_ajax_myfilter', 'mysite_filter_function');
  add_action('wp_ajax_nopriv_myfilter', 'mysite_filter_function');
  function mysite_filter_function(){
    get_template_part('/includes/blogs/post-ajax-listing');
    exit;
    }

/* ########################################## */
/* ########################################## */
/* ###### Ajax function for pagination ###### */
/* ########################################## */
/* ########################################## */
add_action( 'wp_ajax_demo-pagination-load-posts', 'dcs_demo_pagination_load_posts' );
add_action( 'wp_ajax_nopriv_demo-pagination-load-posts', 'dcs_demo_pagination_load_posts' );
function dcs_demo_pagination_load_posts() {
    global $wpdb;
    // Set default variables
    $msg = '';
    if(isset($_POST['page'])){
        // Sanitize the received page
        $page = sanitize_text_field($_POST['page']);
        $cur_page = $page;
        $page -= 1;
        $per_page = 8;	//set the per page limit
        $previous_btn = true;
        $next_btn = true;
        $first_btn = true;
        $last_btn = true;
        $start = $page * $per_page;
        $all_blog_posts = new WP_Query(
            array(
                'post_type'         => 'post',
                'post_status '      => 'publish',
                'orderby'           => 'post_date',
                'order'             => 'DESC',
                'posts_per_page'    => $per_page,
                'offset'            => $start
            )
        );

        $count = new WP_Query(
            array(
                'post_type'         => 'post',
                'post_status '      => 'publish',
                'posts_per_page'    => -1
            )
        );
        $count = $count->post_count; ?>
<div class="blog-flex pagination-content">
    <div class="row">
        <?php if ( $all_blog_posts->have_posts() ) {
			while ( $all_blog_posts->have_posts() ) {
				$all_blog_posts->the_post(); ?>
        <div class="col-md-6 single-item">
            <div class="row single-item">
                <div class="col-md-6 single-item">
                    <h6>Marketing Insights</h6>
                    <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                    <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?></p>
                    <a href="">Read full post</a>
                    <span class="arrow"></span>
                </div>
                <div class="col-md-6 single-item">
                    <?php if (has_post_thumbnail( $post->ID ) ){ ?>
                    <?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                    <img src='<?php echo $image_url[0]; ?>'>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php
			}
		} ?>
    </div>
</div>
</div>
<?php
// This is where the magic happens
$no_of_paginations = ceil($count / $per_page);
if ($cur_page >= 7) {
    $start_loop = $cur_page - 3;
    if ($no_of_paginations > $cur_page + 3)
        $end_loop = $cur_page + 3;
    else if ($cur_page <= $no_of_paginations && $cur_page > $no_of_paginations - 6) {
        $start_loop = $no_of_paginations - 6;
        $end_loop = $no_of_paginations;
    } else {
        $end_loop = $no_of_paginations;
    }
} else {
    $start_loop = 1;
    if ($no_of_paginations > 7)
        $end_loop = 7;
    else
        $end_loop = $no_of_paginations;
}
// Pagination Buttons logic
?>
<div class='dcs-universal-pagination'>
    <ul>
        <?php
		        if ($first_btn && $cur_page > 1) { ?>
        <li p='1' class='active'>
            <<</li> <?php
		        } else if ($first_btn) { ?> <li p='1' class='inactive'>
                <<</li> <?php
		    	}
		        if ($previous_btn && $cur_page > 1) {
		            $pre = $cur_page - 1; ?> <li p='<?php echo $pre; ?>' class='active'>
                    <</li> <?php
		        } else if ($previous_btn) { ?> <li class='inactive'>
                        <</li> <?php
		    	}
		        for ($i = $start_loop; $i <= $end_loop; $i++) {
		            if ($cur_page == $i){ ?> <li p='<?php echo $i; ?>' class='selected'><?php echo $i; ?>
        </li>
        <?php
		        	}else{ ?>
        <li p='<?php echo $i; ?>' class='active'><?php echo $i; ?></li>
        <?php
		            }
		        }
		        if ($next_btn && $cur_page < $no_of_paginations) {
		            $nex = $cur_page + 1; ?>
        <li p='<?php echo $nex; ?>' class='active'>></li>
        <?php
		    	} else if ($next_btn) { ?>
        <li class='inactive'>></li>
        <?php
		    	}

		        if ($last_btn && $cur_page < $no_of_paginations) { ?>
        <li p='<?php echo $no_of_paginations; ?>' class='active'>>></li>
        <?php
		    	} else if ($last_btn) { ?>
        <li p='<?php echo $no_of_paginations; ?>' class='inactive'>>></li>
        <?php
		    	} ?>
    </ul>
</div>
<?php
    }
    exit();
}
/* ########################################## */
/* ########################################## */
/* ###### Shortcode  for pagination ######### */
/* ########################################## */
/* ########################################## */
function newsletters_posts_shortcode() {
  ob_start();
  ?>
<div class="inner-box content no-right-margin darkviolet">
    <div class="dcs_pag_loading">
        <div class="dcs_universal_container">
            <div class="dcs-universal-content"></div>
        </div>
    </div>
</div>
<?php
  return ob_get_clean();
  }
  add_shortcode( 'newsletters_posts', 'newsletters_posts_shortcode' );

function reading_time()
{
  global $post;
  $content = get_post_field('post_content', $post->ID);
  $word_count = str_word_count(strip_tags($content));
  $readingtime = ceil($word_count / 150);
  if ($readingtime == 1) {
    $timer = " min read";
  } else {
    $timer = " min read";
  }
  $totalreadingtime = $readingtime . $timer;
  return $totalreadingtime;
}
// if ( is_singular( 'ebook' ) ) {
//     echo "your code here";
// } else{
//     echo "nooo noo";
// }


function ebook_pdf_download() {
global $post;
    if ( is_singular( 'ebook' )) {
        $get_page_ID = get_the_ID();
        $cformId = get_field( "ebook_banner_form_id", $get_page_ID );
        $ebook = get_field('ebook_pdf', $get_page_ID);
            $pdfurl = $ebook['url']; 
        ?>
        <script type="text/javascript">
            document.addEventListener('wpcf7mailsent', function (event) {
                var cformid = '<?php echo $cformId;?>'
                var pdfurl = '<?php echo $pdfurl;?>'
                if (cformid == event.detail.contactFormId) {
                    window.open(pdfurl, '_blank');
                }
            }, false);
        </script>
<?php }
    }
add_action( 'wp_footer', 'ebook_pdf_download' );


// Remove feed URLs from the header
function disable_feed_links() {
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'feed_links_extra', 3);
}
add_action('init', 'disable_feed_links');
// Redirect feed requests to the original page
function redirect_feed_requests_to_original_page($query) {
if ($query->is_feed) {
global $wp;
$current_url = home_url(add_query_arg(array(), $wp->request));
$original_url = preg_replace('/\/feed(\/.*|$)/', '', $current_url);
wp_redirect($original_url, 301);
exit;
}
}
add_action('parse_query', 'redirect_feed_requests_to_original_page');


/*
 ==================
 Ajax Search
======================	 
*/
// add the ajax fetch js
add_action( 'wp_footer', 'ajax_fetch' );
function ajax_fetch() {
?>
<script type="text/javascript">
function mukto_search_fetch(){

    jQuery.ajax({
        url: '<?php echo admin_url('admin-ajax.php'); ?>',
        type: 'post',
        data: { action: 'data_fetch', keyword: jQuery('#keyword').val() },
        success: function(data) {
            jQuery('#datafetch').html( data );
        }
    });

}
</script>

<?php
}

// the ajax function
add_action('wp_ajax_data_fetch' , 'data_fetch');
add_action('wp_ajax_nopriv_data_fetch','data_fetch');
function data_fetch(){

    $the_query = new WP_Query( array( 'posts_per_page' => -1, 's' => esc_attr( $_POST['keyword'] ), 'post_type' => array('kpi' )) );
    if( $the_query->have_posts() ) :
        echo '<ul>';
        while( $the_query->have_posts() ): $the_query->the_post(); ?>

            <li><a href="<?php echo esc_url( post_permalink() ); ?>"><?php the_title();?></a></li>

        <?php endwhile;
       echo '</ul>';
        wp_reset_postdata();  
    endif;

    die();
}

function latest_post() {
    $args = array(
        'posts_per_page' => 5, /* how many post you need to display */
        'offset' => 0,
        'orderby' => 'post_date',
        'order' => 'DESC',
        'post_type' => 'kpi', /* your post type name */
        'post_status' => 'publish'
    );
    $get_page_ID = get_the_ID();
    $title_short_info = get_field( "title_short_info", $get_page_ID );
    $query = new WP_Query($args);
    if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post();
            ?>
           <li><a href="<?php the_permalink(); ?>"><?php the_field('title_short_info'); ?></a></li>
            <?php
        endwhile;
    endif;
    }
    add_shortcode('recent-posts', 'latest_post');

// Fully Disable Gutenberg editor.
add_filter('use_block_editor_for_post_type', '__return_false', 10);
// Don't load Gutenberg-related stylesheets.
add_action( 'wp_enqueue_scripts', 'remove_block_css', 100 );
function remove_block_css() {
wp_dequeue_style( 'wp-block-library' ); // Wordpress core
wp_dequeue_style( 'wp-block-library-theme' ); // Wordpress core
wp_dequeue_style( 'wc-block-style' ); // WooCommerce
wp_dequeue_style( 'storefront-gutenberg-blocks' ); // Storefront theme
}
   
function preload_for_css ( $html, $handle, $href, $media ) {
    if ( is_admin () )
    {
        return $html;
    }
    echo '<link rel="stylesheet preload" as="style" href="' . $href . '" media="all">';
}

add_filter ( 'style_loader_tag', 'preload_for_css', 10, 4 );


    function defer_parsing_of_js( $url ) {
        if ( is_user_logged_in() ) return $url; //don't break WP Admin
        if ( FALSE === strpos( $url, '.js' ) ) return $url;
        if ( strpos( $url, get_site_url() . '/wp-includes/js/jquery/jquery/jquery.min.js?ver=3.6.3' ) ) return $url;
        return str_replace( ' src', ' defer src', $url );
    }
    add_filter( 'script_loader_tag', 'defer_parsing_of_js', 10 );

    
   