<!DOCTYPE html>
<html dir="ltr" lang="en" prefix="og: https://ogp.me/ns#">

<head>
  <!-- meta tags -->
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Google Tag Manager -->
  <script>
  (function (w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBefore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-W4JJ39D');
  </script>
  <!-- End Google Tag Manager -->

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <?php wp_head(); ?>
</head>
<?php
$get_page_ID = get_the_ID();
$themeData = get_fields('option');
$current_page = get_queried_object();
$select_background_image=get_field('select_background_image', 'option'); 

// $fullName = explode(" ", 'chirag');
// echo $fullName[1];
?>
<body <?php if ((! is_404()) && (!is_search()) ) {  body_class($current_page->post_name); } ?>
  style="background-image:url('<?php echo $select_background_image['url'];?>')" data-attr="<?php echo $get_page_ID ?>">
  <!-- Google Tag Manager (noscript) -->
  <noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W4JJ39D" height="0" width="0"
      style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->
  <?php
    function yourprefix_get_menu_items($menu_name)
    {
      if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
        $menu = wp_get_nav_menu_object($locations[$menu_name]);

        return wp_get_nav_menu_items($menu->term_id);
      }
    }
    $menu_array = yourprefix_get_menu_items('primary');
    ?>
  <header class="header_digg">
    <nav class="navbar navbar-expand-lg  custom-nav-bar">
      <div class="container">
        <?php $custom_logo_id = get_theme_mod( 'custom_logo' );
          $image = wp_get_attachment_image_src( $custom_logo_id , 'full' ); ?>
        <div class="digg-logo">
          <a href="<?php echo get_site_url(); ?>"> <img src="<?php echo $image[0]; ?>" width="264" height="42" alt="logo"></a>
        </div>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
          aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"> <i class="fa fa-bars" id="toggle_tst" aria-hidden="true"
              style="color: #fff"></i></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
          <ul class="navbar-nav">
            <?php foreach ($menu_array as $num => $menu_item) {
                $custom_menu = get_fields($menu_item->ID); 
                if (have_rows('mega_menu_flexible', $menu_item->ID)) {
                  while (have_rows('mega_menu_flexible', $menu_item->ID)) : the_row(); 
                    if (get_row_layout() == 'mega_menu_tab') {
                      $mega_menu_content = get_sub_field('mega_menu_content');
                      $tab_rep = get_sub_field('tab_item_repeater'); ?>
            <li class="nav-item">
              <a class="nav-link menu-parent-link" aria-current="page"
                href="<?php echo !empty($menu_item->url) ? $menu_item->url : 'javascript:void(0)'; ?>">
                <?php echo $menu_item->title; ?></a>

              <div class="dropdown-menu dropdown-large megamenu">
                <div class="menu-new">
                  <div class="row">
                    <div class="menu-item-drop-down">
                      <ul class="left-sub-menu">
                        <?php foreach ($tab_rep as $key => $value) {
                                    $link_text = $value['item_link']['title'];
                                    $link = $value['item_link']['url']; ?>
                        <li class="drop-down-menu"><a href="<?php echo $link ?>"><?php echo $link_text ?></a></li>
                        <?php } ?>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </li>
            <?php }
                  endwhile;
                } 
              } ?>
          </ul>
          <div class="get-demo">
            <?php if (!empty($themeData['get_demo_button']['title'])) { ?>
            <a href="<?php echo isset($themeData['get_demo_button']['url']) ? $themeData['get_demo_button']['url'] : ''; ?>"
              target="_self"><?php echo $themeData['get_demo_button']['title'] ?></a>
            <?php } ?>
          </div>
          <div class="login-btn">
            <?php if (!empty($themeData['login_button']['title'])) { ?>
            <a href="<?php echo isset($themeData['login_button']['url']) ? $themeData['login_button']['url'] : ''; ?>"
              target="_blank">
              <?php  $login_button_icon = get_field('login_button_icon', 'option');
              $login_button_icon_hover = get_field('login_button_icon_hover', 'option');
									if( !empty( $login_button_icon ) ) { ?>
              <img src="<?php echo esc_url($login_button_icon['url']); ?>"
                class="<?php echo esc_attr($login_button_icon['alt']); ?>"
                width="20" height="20" alt="<?php echo esc_attr($login_button_icon['alt']); ?>">
              <img src="<?php echo esc_url($login_button_icon_hover['url']); ?>"
                class="<?php echo esc_attr($login_button_icon_hover['alt']); ?>"
                width="20" height="20" alt="<?php echo esc_attr($login_button_icon_hover['alt']); ?>">
              <?php } ?>
              <?php echo $themeData['login_button']['title'] ?></a>
            <?php } ?>
          </div>
        </div>
      </div>
    </nav>
  </header>
  <!-- header ends -->