//On load for all pages
var title = window.location.pathname;
var pageName;
var url = window.location.href;
var contentType = document.querySelectorAll('.page-template-template-resource, .page-template-template-blog, .page-template-template-infographics, .single-post,.single-ebook, .single-infographics');
var pageLocation = window.location;
var isContent = document.querySelectorAll('.page-template-template-resource,.page-template-template-blog,.page-template-template-infographics,.single-ebook');
var pageId = document.querySelector("body").getAttribute("data-attr");
var pageReffer = document.referrer;
var pageTitle = document.title;

/**DataParameter used for all events */
var dataParameters;
/*convert into json format*/
JSON.stringify(dataParameters);

/***country api fetch ***/
var countryName = '';

function countryCode() {
    /***location code ******/
    $apiKey = 'wbznaqr5cfuddn8y';
    try {
        fetch('https://api.ipregistry.co/?key=' + $apiKey, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json;charset=utf-8'
            }
        }).then((response) => {
            if (response) {
                return response.json();
            }
            throw new Error('Something went wrong');
        })
            .then(result => {
                if (result) {
                    if (result?.location) {
                        countryName = result?.location?.country?.name;
                        setcookie(countryName);
                    }
                    dataParameters = commonParameters()
                    pageViewed();

                }
            }).catch((error) => {
                throw new Error(error.message);
            });
    } catch (error) {
        throw new Error(error.message);
    }
}

function setcookie(countryName) {
    document.cookie = "country=" + countryName + ";";
}

function getcookie() {
    return document.cookie;
}

function pushDataLayer(data) {
    window.dataLayer.push(data);
}

/***About:-commonParameters
 * Description:- functiom 'commonParameters' is used globbaly.
 */

function commonParameters() {
    const countryName = ('; ' + getcookie()).split(`; country=`).pop().split(';')[0];

    /**common query 
     * for all function */
    window.dataLayer = window.dataLayer || [];
    /**take empty json */

    var dataParameters = {};
    dataParameters['page_type'] = document.title;
    dataParameters['country'] = countryName;
    /*push array into json*/
    return dataParameters;
}
/***About:-pageviewed
 * Description:- Event 'pageviewed' will fire on page load for all pages.
 */

function pageViewed() {
    //dataParameters["event"] = "pageviewed";
   // dataParameters["login_status"] = "Null";
    pushDataLayer(dataParameters);
}
/***About:-Function call for all events
 * Description:- This will fire for all events.
 */

window.addEventListener("load", function () {

    /**cookie store in a country variable**/
    const country = ('; ' + getcookie()).split(`; country=`).pop().split(';')[0];
    if (country) {
        countryName = country;
        dataParameters = commonParameters();
        pageViewed();
    } else {
        /*it will load first time after that it will save in a cookie*/
        countryCode();
    }
});

if (isContent.length > 0) {
    var contentData = true;
}
else {
    var contentData = false;
}

//content type
//content type
var url = window.location.href;
if (contentType.length > 0) {
    // var contentTypes = document.title;
    var contentTypes = url.toString().split("/")[3];

}
else {
    var contentTypes = 'Null';
}

// Page type
var routeName = window.location.pathname;
if (routeName == '/') {
    var  pageName = "home";
}else{
    var page =  location.href;
    var pageName =  page.split('/').filter(Boolean).pop();
}


window.addEventListener("load", function () {
    // For pageview
    window.dataLayer = window.dataLayer || [];
    window.dataLayer.push({
        'event': 'pageview',
        'page_location': pageLocation,
        'login_status': 'Null',
        'country': countryName,
        'is_content': contentData,
        'content_type':contentTypes,
        'page_id': pageId,
        'page_title': pageTitle,
        'page_referrer': pageReffer,
    });
});


// For Menu-click
function menuClick()
{
    var navBarClass = jQuery('.navbar-nav, .get-demo');
    jQuery(navBarClass).on('click','a',function()
    {
        var menuLinkUrl = jQuery(this).attr('href');
        var menuLinkName = jQuery(this).text();
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'menu_click',
            'menu_link_name' : menuLinkName,
            'menu_link_url' : menuLinkUrl,
            'page_location': pageLocation,
            'login_status': 'Null',
            'content_type':contentTypes,
            'page_id': pageId,
            'page_title': pageTitle,
            'page_referrer': pageReffer,
            'is_content': contentData,
            'country': countryName,
        });
    });
}
menuClick();

// For search
function getVal() {
    var searchInput = document.getElementById("search");
    // Execute a function when the user presses a key on the keyboard
    if (searchInput){
        searchInput.addEventListener("keypress", function (event) {
            // If the user presses the "Enter" key on the keyboard
            if (event.key === "Enter") {
                SearchDataLayer();
            }
        });
    }
}
getVal();

function SearchDataLayer() {
    var searchterm = document.getElementById("search").value;
    window.dataLayer = window.dataLayer || [];
    window.dataLayer.push({
        'event': 'search',
        'search_term': searchterm,
        'page_id': pageId,
        'page_type': pageName,
        'login_status': 'Null',
        'is_content': contentData,
        'content_type':contentTypes,
        'page_referrer': pageReffer,
        'page_location': pageLocation,
        'page_url':url,
        'country': countryName, 
    });
}

// For social click
function socialClick()
{
    var socialClass = jQuery('.social')
    jQuery(socialClass).on('click','a',function()
    {
        var platform = jQuery(this).find('img').attr('data-attr');
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'social_click',
            'login_status': 'Null',
            'content_type':contentTypes,
            'page_id': pageId,
            'is_content': contentData,
            'page_location': pageLocation,
            'page_referrer': pageReffer,
            'page_type': pageName,           
            'country': countryName,
            'platform_name': platform,
            'page_url':url,
        });
    });
}
socialClick();

// For select resources
function selectResource()
{
    jQuery('body').on('click', '.resource-tab .single-item a, .camera_caption a, .newsroom-section .post-data-info a', function () {
        var resourceTitle = jQuery(this).text();
        var posttype = jQuery(this).closest('.single-item, .post-data-info').find('.post-type').text();
        
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'select_resource', 
            'country': countryName,
            'is_content': contentData,
            'page_id': pageId,
            'page_title': pageTitle,
            'page_referrer': pageReffer,
            'resource_title': resourceTitle,   
            'login_status': 'Null',
            'content_type':contentTypes,
            'page_type': pageName,
            'page_url':url,
            'resoure_type': posttype, 
            'resource_url': url,
            'resource_category': 'Null',
            'resource_publish_date':  'Null',
            'resource_author':  'Null',
        });
    });
}
setTimeout(selectResource, 1000)

// For view resource
function getViewResource()
{
    var blogContent = document.querySelectorAll('.single-post, .single-press-release,.single-podcast,.single-product, .single-infographics, .single-ebook');
    var posttype =  jQuery('.resource-detail-info,.listening-content').find('.post-type').text();
        
    // var posttype = jQuery(this).find('.post-type').text();
    if (blogContent.length > 0) {
        window.addEventListener("load", function () {
            var resourceTitle = jQuery('.detail-info-blk h1, .podcast-banner-info h1').text();
            var getName = jQuery('.author_name').text();
            if(!getName){
                var getName = 'Null';
            }
            var getDate = jQuery('.publish_date').text();
            if(!getDate){
                var getDate = 'Null';
            }
            var getResourceCategory = jQuery('.resource_category').text();
            if(!getResourceCategory){
                var getResourceCategory = 'Null';
            }
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'view_resource',
                'country': countryName,
                'login_status': 'Null',
                'is_content': true,
                'content_type':contentTypes,
                'page_id': pageId,
                'page_title': resourceTitle,
                'page_referrer': pageReffer,
                'page_type': pageName,
                'page_url':url,
                'resoure_type':  posttype, 
                'resource_title': resourceTitle,
                'resource_url':  url,
                'resource_category': getResourceCategory,
                'resource_publish_date':  getDate,
                'resource_author':  getName,
            });
        }); 
    }
}
getViewResource();

// For terms and condition click
function termsCondition()
{
    var termsConstion = jQuery('.company-menu-5')
    jQuery(termsConstion).on('click','a',function()
    {
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'terms_conditions',
            'content_type':contentTypes,
            'page_id': pageId,
            'is_content': contentData,
            'page_location': pageLocation,
            'page_referrer': pageReffer,
            'page_type': pageName,           
            'country': countryName,
            'page_url':url,
        });
    });
}
termsCondition();

// For privacy policy click
function privacyPolicy()
{
    var privacyPolicy = jQuery('.company-menu-4');
    jQuery(privacyPolicy).on('click','a',function()
    {
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'privacy_policy',
            'content_type':contentTypes,
            'page_id': pageId,
            'is_content': contentData,
            'page_location': pageLocation,
            'page_referrer': pageReffer,
            'page_type': pageName,           
            'country': countryName,
            'page_url':url,
        });
    });
}
privacyPolicy();

// For Get in touch click
function getinTouch()
{
    var getinTouch = jQuery('.email-connect');
    jQuery(getinTouch).on('click','a',function()
    {
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'get_in_touch',
            'content_type':contentTypes,
            'login_status': 'Null',
            'page_id': pageId,
            'is_content': contentData,
            'page_location': pageLocation,
            'page_referrer': pageReffer,
            'page_type': pageName,           
            'country': countryName,
            'page_url':url,
            'platform_name': 'email',
        });
    });
}
getinTouch();

