<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();?>

<div class="mtop-100">
	<section class="search-page spacing">
		<div class="container">
			<a class="prev-button" href="javascript:history.go(-1)">
				< Back</a> <?php
					// $uri = $_SERVER['REQUEST_URI'];
					// echo $uri;
					// $end = end(explode('/','https://digg.demandtech.org/'));
					// echo $end;
					$url = "https://";
					$url .= $_SERVER['HTTP_HOST'];
					$url .= $_SERVER['REQUEST_URI'];

					//$postType   = $_GET['postType'];
					$s          = get_search_query();
					$paged      = (get_query_var('paged')) ? get_query_var('paged') : 1;
					$argsSearch = array(
						's'              => $s,
						'paged'          => $paged,
						'post_type'      => 'any',
					);
					$the_query  = new WP_Query($argsSearch);
					$total      = $the_query->found_posts;
					_e("<h3 class='search-heading'>" . $total . " Search Results Found For : ' " . esc_attr(get_query_var('s')) . " '</h3>");
					?> 		
				<div class="blog-flex pagination-content">
					<div class="row <?php echo $total ? '' : 'justify-content-center' ?>">

						<?php if ($the_query->have_posts()) :
							while ($the_query->have_posts()) : $the_query->the_post();
								$id        = get_the_id();
								$thumbnail = get_the_post_thumbnail();
								$image_id    = get_post_thumbnail_id($id);
								$image_title = get_the_title($image_id);
								$categories    = get_the_category($id);
								$excerpt     = get_the_excerpt($id);
								$date        = get_the_date();
									?>
								<div class="col-md-6 list-items">
									<div class="row single-item">
										<div class="col-md-6">
											<!-- <h6>Marketing Insights</h6> -->
											<h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
											</h2>
											<p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
											</p>
											<?php  
											if( get_post_type() == 'podcast' ) { ?>
											<a href="<?php the_permalink(); ?>" class="custom-link" target="_self"
												aria-label="Read full post dd">Listen Now<span class="arrow"></span></a>
											<?php } else { ?>
											<a href="<?php the_permalink(); ?>" class="custom-link" target="_self"
												aria-label="Read full post dd">Read full post<span class="arrow"></span></a>
											<?php } ?>
										</div>
										<div class="col-md-6">
											<?php if (has_post_thumbnail( $post->ID ) ){ ?>
											<?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
											<img src='<?php echo $image_url[0]; ?>'>
											<?php } ?>
										</div>
									</div>
								</div>
						<?php endwhile; ?>
					</div>
				</div>
				<?php else : ?>
				<div>
					<div class="alert alert-info">
						<p>Sorry, but nothing matched your search criteria. Please try again with some different
							keywords.</p>
					</div>
				</div>
				<?php
					endif;
					?>
			<!--pagination-->
				<div class="pagination-outer light-theme simple-pagination">  </div>
			<!--pagination ends-->
		</div>		
	</section>
</div>
<?php 
get_footer();