<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header('ebook'); 
$get_page_ID = get_the_ID(); 
?>
<div class="mtops-100">
<?php
	if (have_posts()) : while(have_posts()) : the_post(); ?>
	<section class="ebook_banner">
		<div class="container">
			<div class="row">
				<div class="col-md-6 webinar-registration">
					<?php if (!empty(get_field('ebook_banner_title',$get_page_ID))) { ?>
						<h1><?php echo get_field('ebook_banner_title',$get_page_ID);?></h1>
					<?php } ?>
					<?php if (!empty(get_field('ebook_banner_description',$get_page_ID))) { ?>
						<p><?php echo get_field('ebook_banner_description',$get_page_ID);?></p>
					<?php } ?>
				</div>
				<div class="col-md-6">
					<div class="web-form">
				<?php 
					$ebook_banner_form_id = get_field('ebook_banner_form_id',$get_page_ID); 
					$shortcode = '[contact-form-7 id="'.$ebook_banner_form_id.'" title="Contact form 1"]';
					echo do_shortcode($shortcode); 
					?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="listening">
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<div class="listening-content">
							<div class="listening-time"><span><i class="fa fa-clock-o"></i><?php echo reading_time(); ?></span><label></label></div>
							<div class="ebook-info">
							<?php the_content(); ?>
							<span class="post-type"><?php echo get_post_type(); ?></span>
							</div>
						</div>
					</div>
				<div class="col-md-4">
					<div class="ebook-feature-image">
					<?php  $ebook_banner_detail_page_image = get_field('ebook_banner_detail_page_image',$get_page_ID);
					if( !empty( $ebook_banner_detail_page_image ) ): ?>
					<img src="<?php echo esc_url($ebook_banner_detail_page_image['url']); ?>"
						alt="<?php echo esc_attr($ebook_banner_detail_page_image['alt']); ?>">
					<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php endwhile; else : ?>
	<div id="post-<?php the_ID(); ?>" <?php post_class('no-posts'); ?>>
		<h3>No Posts found</h3>
	</div>
	<?php endif; ?>
</div>
<script>
        var wpcf7Elm = document.querySelector( '.wpcf7' );
        wpcf7Elm.addEventListener( 'wpcf7mailsent', function(event) {
            window.dataLayer.push({
                'event': 'ebook_download', 
                'page_location': pageLocation,
                'country': countryName,
                'is_content': contentData,
				'content_type': contentTypes,
                'page_id': pageId,
				'ebook_title':pageTitle,
                'page_referrer': pageReffer,
				'page_type': pageName,
				'page_url':url,
            }); 
        }, false );
</script>

<?php get_footer('ebook');