<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header(); 
$get_page_ID = get_the_ID(); ?>

<div class="mtop-100">
	<!-- <div id="progress-bar" class="progress-bar">
		<div class="fill" id="fill"></div>
	</div> -->
	<?php
if (have_posts()) : while(have_posts()) : the_post(); ?>
	<div class="container">
		<section class="resource-detail-info">
			<div class="row">
				<div class="col-md-5"><?php if (has_post_thumbnail( $post->ID ) ){ ?>
					<?php $image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
					<img src='<?php echo $image_url[0]; ?>'>
					<?php } ?>
				</div>
				<div class="col-md-7">
					<div class="detail-info-blk">
						<h3> <?php global $post; $postcat = get_the_category( $post->ID );
						if ( ! empty( $postcat ) ) {
							echo esc_html( $postcat[0]->name );   
						} ?> </h3>
						<h1 class="blog-entry-title"><?php the_title(); ?></h1>
						<?php if (!empty(get_field('infographics_post_info',$get_page_ID))) { ?>
						<?php echo get_field('infographics_post_info',$get_page_ID);?>
						<?php } ?>
						<span class="post-type"><?php echo get_post_type(); ?></span>
					</div>
				</div>
			</div> 
		</section>	
	</div>	
	<?php endwhile; else : ?>
			<div id="post-<?php the_ID(); ?>" <?php post_class('no-posts'); ?>>
				<h3>No Posts found</h3>
			</div>

	<?php endif; ?>
	<div class="container">
		<div class="row">
			<!-- The sections -->
			<div class="col-md-12">
				<div class="infographics-post-info">
					<div class="listening-time"><span><i
								class="fa fa-clock-o"></i><?php echo reading_time(); ?></span><label></label></div>
					<?php the_content(); ?>
				</div>
			</div>
		</div>
	</div>
	<section class="resources-section">
		<?php get_template_part('components/resources', 'section');?>
	</section>
</div>
<?php get_footer();