<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header(); 
$get_page_ID = get_the_ID(); 
?>
<div class="mtops-100">
	<?php
	if (have_posts()) : while(have_posts()) : the_post(); ?>
	<section class="podcast_banner">
		<div class="container">
			<div class="guest-speaker middle-align">
				<div class="guest-speaker-block ">
					<div class="row ">
						<div class="col-md-12">
							<div class="podcast-banner-info">
								<span>DiGGrowth</span>
								<?php if (!empty(get_field('podcast_banner_subheading',$get_page_ID))) { ?>
								<h1><?php echo get_field('podcast_banner_subheading',$get_page_ID);?></h1>
								<?php } ?>
								<?php if (!empty(get_field('podcast_audio_code',$get_page_ID))) { ?>
								<div class="iframe-podcast"><?php echo get_field('podcast_audio_code',$get_page_ID);?>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>

					<div class="row">
						<?php if( have_rows('podcast_guest_info') ): ?>
						<?php while( have_rows('podcast_guest_info') ): the_row(); 
						$podcast_guest_author = get_sub_field('podcast_guest_author');
						$podcast_guest_title = get_sub_field('podcast_guest_title');
						$podcast_guest_subtitle = get_sub_field('podcast_guest_subtitle');
						?>
						<div class="col-md-6">
							<div class="row featured-speaker guest">
								<div class="col-md-4">
									<?php  $podcast_guest_image = get_sub_field('podcast_guest_image');
										if( !empty( $podcast_guest_image ) ): ?>
									<div class="speaker-image"> <img
											src="<?php echo esc_url($podcast_guest_image['url']); ?>"
											alt="<?php echo esc_attr($podcast_guest_image['alt']); ?>" /></div>
									<?php endif; ?>
								</div>
								<div class="col-md-8">
									<?php if( !empty( $podcast_guest_author ) ) { ?>
									<span><?php echo $podcast_guest_author; ?></span>
									<?php } ?>
									<?php if( !empty( $podcast_guest_title ) ) { ?>
									<h5><?php echo $podcast_guest_title; ?></h5>
									<?php } ?>
									<?php if( !empty( $podcast_guest_subtitle ) ) { ?>
									<p><?php echo $podcast_guest_subtitle; ?></p>
									<?php } ?>
									<span class="post-type"><?php echo get_post_type(); ?></span>
								</div>
							</div>
						</div>
						<?php endwhile; ?>
						<?php endif; ?>
					</div>
				</div>

			</div>
		</div>
	</section>
	<section class="listening">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="listening-content">
						<div class="listening-time"><span><i
									class="fa fa-clock-o"></i><?php echo reading_time(); ?></span><label></label></div>

						<div class="ebook-info">
							<div class="podcast-page-desc">
								<?php if (!empty(get_field('podcast_page_description',$get_page_ID))) { ?>
								<?php echo get_field('podcast_page_description',$get_page_ID);?>
								<?php } ?>
							</div>
							<?php if( have_rows('feature_speaker_podcast') ){ ?>
							<div class="feature-heading-blk">
								<?php if (!empty(get_field('feature_speaker_heading',$get_page_ID))) { ?>
								<h2><?php echo get_field('feature_speaker_heading',$get_page_ID);?></h2>
								<?php } ?>
								<div class="feature-speaker">
									<?php while( have_rows('feature_speaker_podcast') ): the_row();  ?>
									<div class="feature-info">
										<?php $podcast_speakers_title = get_sub_field('podcast_speakers_title');
													$podcast_speakers_sub_title = get_sub_field('podcast_speakers_sub_title');
													$podcast_speakers_description = get_sub_field('podcast_speakers_description');
													$podcast_speakers_image = get_sub_field('podcast_speakers_image');
											if( !empty( $podcast_speakers_image ) ){ ?>
										<div class="imgblk-speaker">
											<img src="<?php echo esc_url($podcast_speakers_image['url']); ?>"
												alt="<?php echo esc_attr($podcast_speakers_image['alt']); ?>" />
										</div>
										<?php } ?>
										<div class="feature-speaker-info">
											<?php if( !empty( $podcast_speakers_title ) ) { ?>
											<h3><?php echo $podcast_speakers_title; ?></h3>
											<?php } ?>
											<?php if( !empty( $podcast_speakers_sub_title ) ) { ?>
											<span><?php echo $podcast_speakers_sub_title; ?></span>
											<?php } ?>
											<?php if( !empty( $podcast_speakers_description ) ) { ?>
											<p><?php echo $podcast_speakers_description; ?></p>
											<?php } ?>
										</div>
									</div>
									<?php endwhile; ?>
								</div>
							</div>
							<?php } ?>
							<?php the_content(); ?>
							<span class="post-type"><?php echo get_post_type(); ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
</div>
</section>
<?php get_template_part('components/revenue-focused', 'section');?>
    <section class="resources-section">
        <?php get_template_part('components/resources', 'section');?>
    </section>
<?php endwhile; else : ?>
<div id="post-<?php the_ID(); ?>" <?php post_class('no-posts'); ?>>
	<h3>No Posts found</h3>
</div>
<?php endif; ?>
</div>
<?php get_footer('');