<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header(); 
$get_page_ID = get_the_ID(); 

?>

<div class="mtop-100">
	<div id="progress-bar" class="progress-bar">
		<div class="fill" id="fill"></div>
	</div>
	<?php
	if (have_posts()) : while(have_posts()) : the_post(); ?>
	<div class="container">
		<section class="resource-detail-info">
			<div class="row">
				<div class="col-md-5"><?php 
					 $single_detail_page_image = get_field('single_detail_page_image',$get_page_ID);
					if( !empty( $single_detail_page_image ) ): ?>
					<img src="<?php echo esc_url($single_detail_page_image['url']); ?>"
						alt="<?php echo esc_attr($single_detail_page_image['alt']); ?>">
					<?php endif; ?>

				</div>
				<div class="col-md-7">
					<div class="resource-detail-div">
						<div class="detail-info-blk">
							<span class="resource_category"><?php global $post; $postcat = get_the_category( $post->ID );
							if ( ! empty( $postcat ) ) {
								echo esc_html( $postcat[0]->name );   
							} ?></span>
							<h1 class="blog-entry-title"><?php the_title(); ?></h1>
							<?php if (!empty(get_field('single_detail_short_description',$get_page_ID))) { ?>
							<p><?php echo get_field('single_detail_short_description',$get_page_ID);?></p>
							<?php } ?>

						</div>
						<span class="post-type"><?php echo get_post_type(); ?></span>
						<div class="date-format">
							<p class="author_name">By <?php echo get_field('author_detail_title',$get_page_ID); ?></p>
							<p class="publish_date"><?php echo get_the_date('jS F Y', get_the_ID()) ?></p>
						</div>
					</div>
				</div>
			</div>
			<div class="row">

				<!-- The navbar -->
				<div class="col-md-3 position-relative">
					<div id="sticky-sidebar">
						<div class="navigation-list" id="active-section">
							<?php if (!empty(get_field('sidebar_heading','option'))) { ?>
							<h4><?php echo get_field('sidebar_heading','option');?></h4>
							<?php } ?>

						</div>
					</div>
				</div>
				<!-- The sections -->
				<div class="col-md-9">
					<div id="single-pageinfo-blog" class="single-pageinfo-blog">
						<div class="height200"></div>
						<div class="read-time"><span><i class="fa fa-clock-o"></i>
								<?php echo reading_time(); ?></span><label></label></div>
						<?php if (!empty(get_field('single_detail_page_description',$get_page_ID))) { ?>
						<?php echo get_field('single_detail_page_description',$get_page_ID);?>
						<?php } ?>
						<div class="page-section-connector" id="connector-link<?php echo $row_countt;?>">
							<div class="blog-info-blk">
								<div class="blog-box">
									<?php the_content(); ?>
								</div>
							</div>
						</div>
						<?php if (!empty(get_field('author_detail_title',$get_page_ID))) { ?>
						<div class="author-info">
							<h3>Author</h3>
							<div class="details-area">
								<?php $author_detail_image = get_field('author_detail_image');
								if( !empty( $author_detail_image ) ): ?>
								<div class="imgblk"> <img src="<?php echo esc_url($author_detail_image['url']); ?>"
										alt="<?php echo esc_attr($author_detail_image['alt']); ?>"></div>
								<?php endif; ?>
								<div class="work_step_content">

									<h5><?php echo get_field('author_detail_title',$get_page_ID);
									$author_social_icon_linkdin = get_field('author_social_icon_linkdin',$get_page_ID);
									$author_detail_linkdin = get_field('author_detail_linkdin',$get_page_ID);
								 if( $author_detail_linkdin ){
										$social_link_url = $author_detail_linkdin['url'];
										$social_link_title = $author_detail_linkdin['title'];
										$social_link_target = $author_detail_linkdin['target'] ? $author_detail_linkdin['target'] : '_self';
										?>
										<a href="<?php echo esc_url( $social_link_url ); ?>"
											target="<?php echo esc_attr( $social_link_target ); ?>"><img class=""
												src="<?php echo esc_url($author_social_icon_linkdin['url']); ?>"
												alt="<?php echo esc_attr($social_icon_linkdin['alt']); ?>"></a>

										<?php } ?>
									</h5>

									<?php if (!empty(get_field('author_detail_description',$get_page_ID))) { ?>
									<?php echo get_field('author_detail_description',$get_page_ID);?>
									<?php } ?>
								</div>
							</div>
							<?php } ?>
						</div>
					</div>
				</div>
		</section>
	</div>
	<?php endwhile; else : ?>
	<div id="post-<?php the_ID(); ?>" <?php post_class('no-posts'); ?>>
		<h3>No Posts found</h3>
	</div>
	<?php endif; ?>

	<?php get_template_part('components/revenue-focused', 'blog');?>

	<section class="resources-section">
		<?php get_template_part('components/resources', 'section');?>
	</section>
	<?php if( have_rows('blog_faq_repeater') ): ?>
	<section class="section-faq">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<?php if (!empty(get_field('faq_heading_blog',$get_page_ID))) { ?>
					<h2><?php echo get_field('faq_heading_blog',$get_page_ID);?></h2>
					<?php } ?>
					<div class="faq-info">
						<div class="accordion" id="myAccordion">
							<?php
								$row_countt = 1;
								while( have_rows('blog_faq_repeater') ): the_row();  
								$blog_faq_heading = get_sub_field('blog_faq_heading',$get_page_ID);
								$blog_faq_description = get_sub_field('blog_faq_description',$get_page_ID);	?>
							<div class="accordion-item">
								<?php if( !empty( $blog_faq_heading ) ) { ?>
								<h4 class="accordion-header" id="heading<?php echo $row_countt;?>">
									<button type="button" class="accordion-button collapsed" data-bs-toggle="collapse"
										data-bs-target="#collapse<?php echo $row_countt;?>"><?php echo $blog_faq_heading; ?></button>
								</h4>
								<?php } ?>
								<?php if( !empty( $blog_faq_description ) ) { ?>
								<div id="collapse<?php echo $row_countt;?>" class="accordion-collapse collapse"
									data-bs-parent="#myAccordion">
									<div class="card-body">
										<p><?php echo $blog_faq_description; ?></p>
									</div>
								</div>
								<?php } ?>
							</div>
							<?php $row_countt++; endwhile; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php endif; ?>
</div>
<?php get_footer();