<?php
/* Template Name: Blog Page 
*/
get_header();
$get_page_ID = get_the_ID();
$resource_banner_bg_image = get_field('resource_banner_bg_image', $get_page_ID); 
$resource_banner_search_icon = get_field('resource_banner_search_icon');
?>
<div class="mtop-100">
    <section class="connector-banner resource-page-banner"
        style="background-image:url('<?php echo $resource_banner_bg_image['url']; ?>')">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="connector-banner-info">
                        <?php if (!empty(get_field('resource_sub_heading', $get_page_ID))) { ?>
                        <span><?php echo get_field('resource_sub_heading', $get_page_ID); ?></span>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_heading', $get_page_ID))) { ?>
                        <h1><?php echo get_field('resource_banner_heading', $get_page_ID); ?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_description', $get_page_ID))) { ?>
                        <p><?php echo get_field('resource_banner_description', $get_page_ID); ?></p>
                        <?php }   ?>
                        <div class="resource-banner-button">
                            <!-- Button trigger modal -->
                            <?php $resource_banner_button = get_field('resource_banner_button', $get_page_ID);
                                if ($resource_banner_button) {
                                    $resource_banner_button_url    = $resource_banner_button['url'];
                                    $resource_banner_button_title  = $resource_banner_button['title'];
                                    $resource_banner_button_target = $resource_banner_button['target'] ? $resource_banner_button['target'] : '_self';
                                ?>
                            <button type="button" class="custom-button " data-bs-toggle="modal"
                                data-bs-target="#staticBackdrop"><?php echo esc_html($resource_banner_button_title); ?>
                                <span class="arrow"></span> </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="resource-tab" id="resource-tab">
        <div class="container">
            <div class="blog-content">
                <div class="row">
                    <div class="col-lg-12 col-12">
                        <div class="blog-tab-content">
                            <div class="filter-outer">
                                <div class="drop-down-filter">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                            <a class="nav-link" id="pills-tabs-all" data-bs-toggle="pill" data-bs-target="#pills-all" type="button" role="tab" aria-controls="pills-all>" aria-selected="false"><div class="tabs-icon"><img src="/wp-content/uploads/2023/04/All.png" alt="All"><p>All</p></div>
                                            </a></li>
                                        <?php $_terms = get_terms(array('category'));
                                                foreach ($_terms as $term) { ?>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link" id="pills-tabs-<?php echo $term->slug ?>"
                                                data-description="asd" data-bs-toggle="pill"
                                                data-tableid="<?php echo $term->slug ?>"
                                                data-bs-target="#pills-<?php echo $term->slug ?>" type="button"
                                                role="tab" aria-controls="pills-<?php echo $term->slug ?>"
                                                aria-selected="false">
                                                <?php  
                                                    //echo $term->id; 
                                                // echo $term_id[0]->cat_ID;
                                                $term_ids = $term->term_id;
                                                //   echo  $term_ids;
                                                // $term_id = 6;
                                                    $category_image = get_field('category_image', 'category_'. $term_ids); //'category_image' is our field name ?>
                                                <div class="tabs-icon">
                                                    <?php echo '<img src="'.$category_image['url'].'" alt="'.$category_image['alt'].'" />'; ?>
                                                    <p><?php echo $term->name; ?></p>
                                                </div>
                                            </a>
                                        </li>
                                        <?php  }  ?>
                                    </ul>
                                </div>
                                <div class="left-filter">
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade" id="pills-all" role="tabpanel" aria-labelledby="all-tab" tabindex="0">
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php                              
                                                        $wp_query = new WP_Query();
                                                        $wp_query->query(array("post_type"=>"post","posts_per_page" =>-1,'orderby' => 'date','order' => 'DESC'));
                                                        ?>
                                                        <?php while(have_posts()) : the_post() ;?>
                                                        <!--slider first start-->
                                                        <div class="col-md-6 list-items">
                                                            <div class="row single-item">
                                                                <div class="col-md-6">
                                                                    <h6><?php foreach((get_the_category()) as $category) { 
                                                                        echo $category->cat_name . ' '; 
                                                                        } ?></h6>
                                                                    <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                                                                    <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                    </p>
                                                                    <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                        target="_self" aria-label="Read full post">Read full
                                                                        post<span class="arrow"></span>
                                                                        <span class="post-type"><?php echo get_post_type(); ?></span>
                                                                    </a>
                                                                        
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <?php $image_id = get_post_thumbnail_id(get_the_ID()); $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                    <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                        alt="<?php echo $alt_text ;?>" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <?php 
                                                            endwhile;
                                                            wp_reset_query(); ?>
                                                </div>
                                                <div id="pagination-all"></div>
                                            </div>
                                        </div>
                                    <?php 
                                        foreach ($_terms as $term) {
                                            $term_slug = $term->slug; 
                                            // QUERY
                                            $_posts = new WP_Query( array(
                                            'post_type'         => 'post',
                                            'posts_per_page'    => -1, 
                                            'tax_query' => array(
                                                array(
                                                'taxonomy' => 'category',
                                                'field'    => 'slug',
                                                'terms'    => $term_slug,
                                                ),
                                            ),
                                        )); ?>


                                        <div class="tab-pane fade" id="pills-<?php echo $term->slug ?>" role="tabpanel" aria-labelledby="all-tab" tabindex="0">
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php if ( $_posts->have_posts() ) :
                                                    while ( $_posts->have_posts() ) :
                                                        $_posts->the_post(); ?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <h6><?php foreach((get_the_category()) as $category) { 
                                                                    echo $category->cat_name . ' '; 
                                                                    } ?></h6>
                                                                <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Read full
                                                                    post<span class="arrow"></span></a>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID()); $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php 
                                                        endwhile;
                                                        wp_reset_postdata();
                                                    endif; ?>
                                                </div>
                                                <div id="pagination-<?php echo $term->slug ?>"></div>
                                            </div>
                                        </div>

                                        <?php 
                                                }
                                                ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <div class="team-section resource-subscribe">
        <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="popup-info">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body">
                            <?php echo do_shortcode( '[contact-form-7 id="5" title="Resource Page Subscribe Form"]' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function ($) {
    if ($('.blog-tab-content').find('.drop-down-filter').length) {
    var current_id = "<?php echo $term->slug ?>";
    //alert(current_id);
    var itemsanalytics = jQuery("#pills-all .list-items");
    var numItemsanalytics = itemsanalytics.length;
    var perPageanalytics = 8;
    if(numItemsanalytics > perPageanalytics)
            {  
    itemsanalytics.slice(perPageanalytics).hide()
        jQuery('#pagination-all').pagination({
            items: numItemsanalytics,
            itemsOnPage: perPageanalytics,
            prevText: "&laquo;",
            nextText: "&raquo;",
            onPageClick: function (pageNumber) {
                var showFrom = perPageanalytics * (pageNumber - 1);
                var showTo = showFrom +  perPageanalytics;
                itemsanalytics.hide().slice(showFrom, showTo).show();
            }
        }); 
    }
    }

    jQuery(document).on('click','.nav-link',function() {
        var current_tab=jQuery(this).attr('data-tableid');
        if (jQuery(this).parents('.blog-tab-content .drop-down-filter').length) {
           
            var itemsanalyticsnew = jQuery("#pills-"+current_tab+" .list-items");
            var numitemsanalyticsnew = itemsanalyticsnew.length;
            var perPageanalytics = 8;
            if(numitemsanalyticsnew > perPageanalytics)
            {              
            itemsanalyticsnew.slice(perPageanalytics).hide()
                jQuery('#pagination-'+current_tab).pagination({
                    items: numitemsanalyticsnew,
                    itemsOnPage: perPageanalytics,
                    prevText: "&laquo;",
                    nextText: "&raquo;",
                    onPageClick: function (pageNumber) {
                        var showFrom = perPageanalytics * (pageNumber - 1);
                        var showTo = showFrom +  perPageanalytics;
                        itemsanalyticsnew.hide().slice(showFrom, showTo).show();
                    }
                }); 
            }
            }

    });
});
</script>
<script>
    var wpcf7Elm = document.querySelector( '.wpcf7' );
    wpcf7Elm.addEventListener( 'wpcf7mailsent', function(event) {
        window.dataLayer.push({
            'event': 'subscribe_now', 
            'login_status': 'Null',
            'page_location': pageLocation,
            'resoure_type':   'Null', 
            'resource_title': 'Null',
            'country': countryName,
            'is_content': contentData, 
            'page_id': pageId,
            'page_title': pageTitle,
            'page_referrer': pageReffer,
        });
    }, false );
</script>
<?php get_footer(); ?>