<?php
/* Template Name: Infographics Page 
*/
get_header();
$get_page_ID = get_the_ID();
$resource_banner_bg_image = get_field('resource_banner_bg_image', $get_page_ID); 
$resource_banner_search_icon = get_field('resource_banner_search_icon');
?>
<div class="mtop-100">
    <section class="connector-banner resource-page-banner"
        style="background-image:url('<?php echo $resource_banner_bg_image['url']; ?>')">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="connector-banner-info">
                        <?php if (!empty(get_field('resource_sub_heading', $get_page_ID))) { ?>
                        <span><?php echo get_field('resource_sub_heading', $get_page_ID); ?></span>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_heading', $get_page_ID))) { ?>
                        <h1><?php echo get_field('resource_banner_heading', $get_page_ID); ?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_description', $get_page_ID))) { ?>
                        <p><?php echo get_field('resource_banner_description', $get_page_ID); ?></p>
                        <?php }   ?>
                        <div class="resource-banner-button">
                            <!-- Button trigger modal -->
                            <?php $resource_banner_button = get_field('resource_banner_button', $get_page_ID);
                            if ($resource_banner_button) {
                                $resource_banner_button_url    = $resource_banner_button['url'];
                                $resource_banner_button_title  = $resource_banner_button['title'];
                                $resource_banner_button_target = $resource_banner_button['target'] ? $resource_banner_button['target'] : '_self';
                            ?>
                            <button type="button" class="custom-button " data-bs-toggle="modal"
                                data-bs-target="#staticBackdrop"><?php echo esc_html($resource_banner_button_title); ?>
                                <span class="arrow"></span> </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="resource-tab" id="resource-tab">
        <div class="container">
            <div class="blog-content">
                <div class="row">
                    <div class="col-lg-12 col-12">
                        <div class="blog-tab-content">
                            <div class="filter-outer">
                                <div class="drop-down-filter">
                                  <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <?php $_terms = get_terms(array('category'));
                                            foreach ($_terms as $term) { ?> 
                                        <?php  }  ?>
                                    </ul>
                                </div>
                                <div class="left-filter">
                                    <div class="tab-content" id="myTabContent">
                                        <?php 
                                    $featured_post_type = get_field('featured_post_type',$get_page_ID); 
                                    $field = get_field_object('features_post_type_order',$get_page_ID);
                                   // echo "<pre>";print_r($field);
                                    $value = $field['value']; 
                                    foreach ($_terms as $term) {
                                    $term_slug = $term->slug; 
                                    // QUERY
                                    $_posts = new WP_Query( array(
                                    'post_type'         => $featured_post_type,
                                    'posts_per_page'    => -1, 
                                    'order' =>  esc_attr($value)
                                    )); 
                                    ?>

                                        <div class="tab-pane fade" id="pills-<?php echo $term->slug ?>" role="tabpanel"
                                            aria-labelledby="pills-tabs<?php echo $term->slug ?>" tabindex="0">
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php if( $_posts->have_posts() ) :  while ( $_posts->have_posts() ) : $_posts->the_post();  ?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <h2><a href="<?php echo get_permalink(); ?>"> <?php the_title(); ?> </a> </h2>
                                                                <p> <?php the_excerpt(); ?> </p>
                                                                <a href="<?php echo get_permalink(); ?>" class="custom-link" target="_self"
                                                                    aria-label="Read full post"><?php echo get_field('featured_post_button_name', $get_page_ID); ?> <span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6">
                                                            <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                            <img  src="<?php echo the_post_thumbnail_url() ?>" alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php  endwhile; endif; wp_reset_postdata(); ?>
                                                </div>
                                            </div>
                                            <div id="pagination-container"></div>
                                        </div>
                                        <?php 
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section'); ?>
    <div class="team-section resource-subscribe">
    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="popup-info">
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button> 
                    <div class="modal-body">
                    <?php echo do_shortcode( '[contact-form-7 id="5" title="Resource Page Subscribe Form"]' ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var wpcf7Elm = document.querySelector( '.wpcf7' );
    wpcf7Elm.addEventListener( 'wpcf7mailsent', function(event) {
        window.dataLayer.push({
            'event': 'subscribe_now', 
            'login_status': 'Null',
            'page_location': pageLocation,
            'resoure_type':   'Null', 
            'resource_title': 'Null',
            'country': countryName,
            'is_content': contentData, 
            'page_id': pageId,
            'page_title': pageTitle,
            'page_referrer': pageReffer,
        });
    }, false );
</script>
    <?php get_footer(); ?>