<?php
/* Template Name: KPI Page 
*/
get_header('ebook');
$get_page_ID = get_the_ID();
?>
<div class="mtop-100">
<section class="section-search">
        <div class="container">
            <div class="search_bar custom-search">
                <?php if (!empty(get_field('kpi_page_heading',$get_page_ID))) { ?>
                    <h1><?php echo get_field('kpi_page_heading',$get_page_ID);?></h1>
                <?php } ?>
                <div class="form-group">
                    <form action="/" method="get" autocomplete="off">
                        <input type="text" name="s" placeholder="Search Code..." id="keyword"
                            class="input_search form-control" onkeyup="mukto_search_fetch()">
                        <button aria-label="search-button" class="search-submit-button" type="submit">
                            <img src="https://diggrowth.com/wp-content/uploads/2023/04/Icon_search.png" alt="Icon_search">
                        </button>
                    </form>
                </div>
                <div class="search_result" id="datafetch">
                    <ul>
                        <li>Please wait..</li>
                    </ul>
                </div>
                <div class="trending-category">
                    <ul><?php if (!empty(get_field('trending_heading',$get_page_ID))) { ?>
                            <li><?php echo get_field('trending_heading',$get_page_ID);?></li>
                        <?php } ?>
                        <?php if( have_rows('trending_category') ): ?> 
                        <?php while( have_rows('trending_category') ): the_row();  
                            $trending_category_trending_list = get_sub_field('trending_category_trending_list');
                            if( $trending_category_trending_list ): 
                                $trending_category_url = $trending_category_trending_list['url'];
                                $trending_category_title = $trending_category_trending_list['title'];
                                $trending_category_target = $trending_category_trending_list['target'] ? $trending_category_trending_list['target'] : '_self';
                                ?>
                                <li><a  href="<?php echo esc_url( $trending_category_url ); ?>" target="<?php echo esc_attr( $trending_category_target ); ?>"><?php echo esc_html( $trending_category_title ); ?></a></li>
                            <?php endif; ?>
                            <?php endwhile; ?> 
                        <?php endif; ?>
                    </ul>
          
                </div>
            </div>
        </div>
    </section>
    <section class="popular-metrics">
        <div class="container">
            <div class="row">
                <div class="col-md-12 ">
                    <div class="popular-metrics-content">
                        <?php if (!empty(get_field('section_first_heading',$get_page_ID))) { ?>
                            <h2><?php echo get_field('section_first_heading',$get_page_ID);?></h2>
                        <?php } ?>
                        <ul><?php echo do_shortcode( '[recent-posts]' ); ?>
                            <li class="view-button"><a class="custom-button" href="#" target="_self">View all<span class="arrow"></span>
                                </a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="popular-categories">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="popular-category">
                        <?php if (!empty(get_field('section_second_heading',$get_page_ID))) { ?>
                            <h2><?php echo get_field('section_second_heading',$get_page_ID);?></h2>
                        <?php } ?>
                        <div class="category-list">
                            <?php $taxonomy = 'kpi_categories';
                        $terms = get_terms($taxonomy);
                        if ( $terms && !is_wp_error( $terms ) ) : ?>
                            <ul>
                                <?php foreach ( $terms as $term ) { 
                                   $image = get_field('category_image', $term->taxonomy . '_' . $term->term_id );
                                   $image_url = $image['sizes']['medium'];                                   
                                ?>
                              
                                <li><a href="<?php echo get_term_link($term->slug, $taxonomy); ?>"><img src="<?php echo $image_url; ?>"><span><?php echo $term->name; ?></span><span><?php echo $term->count;?> Metrics</span></a></li>
                                <?php } ?>
                            </ul>
                            <?php endif; ?>
                        </div>
                        <div class="view-button"><a class="custom-button" href="#" target="_self">View all<span class="arrow"></span></a></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer('ebook'); ?>