<?php
/* Template Name: DiGGrowth vs Bizible Capabilities Landing Page 
*/
get_header('ebook');
$get_page_ID = get_the_ID();
$page_class_name = get_field('page_class_name',$get_page_ID);
?>
<div class="mtop-100s <?php echo $page_class_name; ?>">

    <section class="ebook_banner">
        <div class="container">
            <div class="row">
                <div class="col-md-6 webinar-registration">
                    <?php if (!empty(get_field('solution_banner_title',$get_page_ID))) { ?>
                    <h1><?php echo get_field('solution_banner_title',$get_page_ID);?></h1>
                    <?php } ?>
                    <?php if (!empty(get_field('solution_banner_description',$get_page_ID))) { ?>
                    <p><?php echo get_field('solution_banner_description',$get_page_ID);?></p>
                    <?php } ?>
                </div>
                <div class="col-md-6">
                    <div class="web-form">
                        <?php 
					$contact_form_id = get_field('contact_form_id',$get_page_ID); 
					$shortcode = '[contact-form-7 id="'.$contact_form_id.'" title="Contact form 1"]';
					echo do_shortcode($shortcode); 
					?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="digg-advantages">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="adv-info">
                        <?php if (!empty(get_field('diggrowth_advantages_heading',$get_page_ID))) { ?>
                        <h2><?php echo get_field('diggrowth_advantages_heading',$get_page_ID);?></h2>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="home-campaign-productivity js-section " data-color-mode="dark" data-light-theme="light"
                data-dark-theme="dark">
                <div class="d-flex flex-column flex-md-row gutter js-build-in-trigger build-in-animate">
                    <?php if( have_rows('diggrowth_advantages') ): 
                    while( have_rows('diggrowth_advantages') ): the_row(); 
                    $diggrowth_advantages_icon = get_sub_field('diggrowth_advantages_icon');
                    $diggrowth_advantages_title = get_sub_field('diggrowth_advantages_title');
                    $diggrowth_advantages_description = get_sub_field('diggrowth_advantages_description');
                    ?>
                    <div class="col-md-4">
                        <div class="overflow-hidden rounded-3 home-skew js-home-skew"
                            style="transform: perspective(700px) rotateX(0deg) rotateY(-0.03deg);">
                            <div
                                class="feature-card-mktg js-feature-card-mktg d-md-flex rounded-3 color-bg-subtle border position-relative  flex-column">
                                <?php if( !empty( $diggrowth_advantages_title ) ) { ?>
                                <div class="diggrowth_advantages_info">
                                    <?php if( !empty( $diggrowth_advantages_icon ) ): ?>
                                    <div class="imgblk position-relative"> <img
                                            src="<?php echo esc_url($diggrowth_advantages_icon['url']); ?>"
                                            alt="<?php echo esc_attr($diggrowth_advantages_icon['alt']); ?>">
                                        <span
                                            class="position-absolute left-0 top-0 height-full width-full home-campaign-glowing-icon-glow z-n1"
                                            style="background-color: rgb(212 18 255 / 25%);filter: blur(25px);"></span>
                                    </div>
                                    <?php endif; ?>
                                    <h3 class="normal-arrow"><?php echo $diggrowth_advantages_title; ?></h3>
                                    <?php if( !empty( $diggrowth_advantages_description ) ) { ?>
                                    <p><?php echo $diggrowth_advantages_description; ?></p>
                                    <?php } ?>
                                </div>
                                <?php } ?>
                                <div class="position-absolute bottom-0 right-0 events-none home-feature-card-shine js-feature-card-shine-mktg z-n1"
                                    style="transform: translate(198.07px, -26.16px);"></div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; endif; ?>
                </div>
            </div>
        </div>
    </section>
    <section class="digg-vs-bizible">
        <div class="container">

            <?php if (!empty(get_field('diggrowth_vs_bizible_heading',$get_page_ID))) { ?>
            <div class="digg-vs-bizible-heading">
                <h2><?php echo get_field('diggrowth_vs_bizible_heading',$get_page_ID);?></h2>
            </div>
            <?php } ?>
            <div class="digg-vs-bizible-comparison table-responsive">
            <?php if (!empty(get_field('diggrowth_vs_bizible_description',$get_page_ID))) { ?>
                  <?php echo get_field('diggrowth_vs_bizible_description',$get_page_ID);?>
                <?php } ?>
            </div>
            <?php 
            $diggrowth_vs_bizible_link = get_field('diggrowth_vs_bizible_link');
            if( $diggrowth_vs_bizible_link ): 
                $link_url = $diggrowth_vs_bizible_link['url'];
                $link_title = $diggrowth_vs_bizible_link['title'];
                $link_target = $diggrowth_vs_bizible_link['target'] ? $diggrowth_vs_bizible_link['target'] : '_self';
                ?>
                <a class="custom-button" href="<?php echo esc_url( $link_url ); ?>"  data-bs-toggle="modal" data-bs-target="#myModal" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?><span
                    class="arrow"></span></a>
            <?php endif; ?>
        </div>
    </section>

    <section class="section-optimize-channel">
        <div class="container">
            <?php if (!empty(get_field('optimize_channel_heading',$get_page_ID))) { ?>
            <div class="channel_description">
                <div class="row middle-align">
                    <div class="col-md-12">
                        <div class="optimize-channel">

                            <h2><?php echo get_field('optimize_channel_heading',$get_page_ID);?></h2>

                            <?php if (!empty(get_field('optimize_channel_subheading',$get_page_ID))) { ?>
                            <p><?php echo get_field('optimize_channel_subheading',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php $optimize_channel_image = get_field('optimize_channel_image');
                    if( !empty( $optimize_channel_image ) ) { ?>
                        <div class="imgblk">
                            <img src="<?php echo esc_url($optimize_channel_image['url']); ?>"
                                alt="<?php echo esc_attr($optimize_channel_image['alt']); ?>">
                        </div>
                        <?php } ?>
                    </div>
                    <div class="col-md-6">
                        <?php if (!empty(get_field('optimize_channel_description',$get_page_ID))) { ?>
                        <div class="channel_description_info">
                            <p><?php echo get_field('optimize_channel_description',$get_page_ID);?></p>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </section>
    <section class="timeline ">
        <div class="container">
            <?php if (!empty(get_field('channel_manager_heading',$get_page_ID))) { ?>
                <div class="channel-manager">
                    <h2><?php echo get_field('channel_manager_heading',$get_page_ID);?></h2>
                    <?php if (!empty(get_field('channel_manager_description',$get_page_ID))) { ?>
                    <?php $channel_manager_image = get_field('channel_manager_image');
                        if( !empty( $channel_manager_image ) ): ?>
                            <div class="imgblk"> <img src="<?php echo esc_url($channel_manager_image['url']); ?>" alt="<?php echo esc_attr($channel_manager_image['alt']); ?>" /></div>
                        <?php endif; ?>
                    <?php } ?>
                    <p><?php echo get_field('channel_manager_description',$get_page_ID);?></p>
                </div>
                <div class="position-relative">
                    <div class="position-absolute top-0 bottom-0 color-bg-line"></div>
                        <div class="desktop">
                                <?php
                                $count = 1;
                                if( have_rows('channel_manager_repeater') ): 
                                    while( have_rows('channel_manager_repeater') ): the_row(); 
                                        $channel_manager_image = get_sub_field('channel_manager_image',$get_page_ID); 
                                        $channel_manager_image_second = get_sub_field('channel_manager_image_second',$get_page_ID); 
                                        $channel_manager_title = get_sub_field('channel_manager_title',$get_page_ID);
                                        $channel_manager_info = get_sub_field('channel_manager_info',$get_page_ID);
                                        $channel_manager_button = get_sub_field( 'channel_manager_button_link',$get_page_ID);
                                        ?>
                                <div class="container mx-auto p-responsive pb-8 pb-md-9 count-<?php echo $count; if($count % 2 == 0){ ?> even <?php } else{?> odd <?php } ?>">
                                    <div class="js-build-in-trigger d-md-flex flex-row flex-justify-center flex-items-center my-7 build-in-animate">
                                        <div class="d-flex flex-justify-start flex-1 team-collaboration--text-right js-build-in-item build-in-scale-right build-in-animate">
                                            <div class="color-bg-default box-shadow-card-border-mktg rounded-3 text-center text-md-left col-10 mx-auto mx-md-0 p-5 team-collaboration-box team-collaboration-box--right">
                                                <?php if( !empty( $channel_manager_title ) ) { ?>
                                                <h3><?php echo $channel_manager_title; ?></h3>
                                                <?php } ?>
                                                <?php if( !empty( $channel_manager_info ) ) { ?>
                                                <p><?php echo $channel_manager_info; ?></p>
                                                <?php } 
                                                if ( $channel_manager_button ) {
                                                        $channel_manager_url    = $channel_manager_button['url'];
                                                        $channel_manager_title  = $channel_manager_button['title'];
                                                        $channel_manager_target = $channel_manager_button['target'] ? $channel_manager_button['target'] : '_self';
                                                        ?>
                                                <a class="custom-button" href="<?php echo esc_url( $channel_manager_url ); ?>" data-bs-toggle="modal" data-bs-target="#myModal"
                                                    target="<?php echo esc_attr( $channel_manager_target ); ?>"><?php echo esc_html( $channel_manager_title ); ?><span
                                                        class="arrow"></span></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="d-flex flex-justify-center flex-items-center team-collaboration--dot js-build-in-item build-in-animate">
                                            <div class="circle flex-shrink-0 color-bg-emphasis mx-4 mt-3 mt-md-6 mb-6"></div>
                                        </div>
                                        <div
                                            class="d-flex flex-1 flex-justify-end js-build-in-item build-in-scale-left build-in-animate">
                                            <div class="position-relative">
                                                <?php if( !empty( $channel_manager_image ) ){ ?>
                                                <img class="rounded-3 width-full height-auto box-shadow-default-border-mktg "
                                                    src="<?php echo esc_url($channel_manager_image['url']); ?>"
                                                    alt="<?php echo esc_attr($channel_manager_image['alt']); ?>">
                                                <?php } ?>
                                                <?php if( !empty( $channel_manager_image_second ) ){ ?>
                                                <img class="position-absolute timelineimg-animate left-md-n3 col-11 height-auto rounded-3 box-shadow-default-border-mktg js-build-in-item build-in-slideX-right build-in-animate"
                                                    src="<?php echo esc_url($channel_manager_image_second['url']); ?>"
                                                    alt="<?php echo esc_attr($channel_manager_image_second['alt']); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php  $count++; endwhile;  endif; ?>
                    </div>
                    <div class="mobile">
                                <?php
                                $count = 1;
                                if( have_rows('channel_manager_repeater') ): 
                                    while( have_rows('channel_manager_repeater') ): the_row(); 
                                        $channel_manager_image = get_sub_field('channel_manager_image',$get_page_ID); 
                                        $channel_manager_image_second = get_sub_field('channel_manager_image_second',$get_page_ID); 
                                        $channel_manager_title = get_sub_field('channel_manager_title',$get_page_ID);
                                        $channel_manager_info = get_sub_field('channel_manager_info',$get_page_ID);
                                        $channel_manager_button = get_sub_field( 'channel_manager_button_link',$get_page_ID);
                                        ?>
                                <div class="container mx-auto p-responsive pb-8 pb-md-9 count-<?php if($count % 2 == 0){ ?> even <?php } else{?> odd <?php } ?>">
                                    <div class="js-build-in-trigger d-md-flex flex-row flex-justify-center flex-items-center my-7 build-in-animate">
                                        <div class="d-flex flex-justify-start flex-1 team-collaboration--text-right js-build-in-item build-in-scale-right build-in-animate">
                                            <div class="color-bg-default box-shadow-card-border-mktg rounded-3 text-center text-md-left col-10 mx-auto mx-md-0 p-5 team-collaboration-box team-collaboration-box--right">
                                                <?php if( !empty( $channel_manager_title ) ) { ?>
                                                <h3><?php echo $channel_manager_title; ?></h3>
                                                <?php } ?>
                                                <?php if( !empty( $channel_manager_info ) ) { ?>
                                                <p><?php echo $channel_manager_info; ?></p>
                                                <?php } 
                                                if ( $channel_manager_button ) {
                                                        $channel_manager_url    = $channel_manager_button['url'];
                                                        $channel_manager_title  = $channel_manager_button['title'];
                                                        $channel_manager_target = $channel_manager_button['target'] ? $channel_manager_button['target'] : '_self';
                                                        ?>
                                                <a class="custom-button" href="<?php echo esc_url( $channel_manager_url ); ?>" data-bs-toggle="modal" data-bs-target="#myModal"
                                                    target="<?php echo esc_attr( $channel_manager_target ); ?>"><?php echo esc_html( $channel_manager_title ); ?><span
                                                        class="arrow"></span></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="d-flex flex-justify-center flex-items-center team-collaboration--dot js-build-in-item build-in-animate">
                                            <div class="circle flex-shrink-0 color-bg-emphasis mx-4 mt-3 mt-md-6 mb-6"></div>
                                        </div>
                                        <div
                                            class="d-flex flex-1 flex-justify-end js-build-in-item build-in-scale-left build-in-animate">
                                            <div class="position-relative">
                                                <?php if( !empty( $channel_manager_image ) ){ ?>
                                                <img class="rounded-3 width-full height-auto box-shadow-default-border-mktg "
                                                    src="<?php echo esc_url($channel_manager_image['url']); ?>"
                                                    alt="<?php echo esc_attr($channel_manager_image['alt']); ?>">
                                                <?php } ?>
                                                <?php if( !empty( $channel_manager_image_second ) ){ ?>
                                                <img class="position-absolute timelineimg-animate left-md-n3 col-11 height-auto rounded-3 box-shadow-default-border-mktg js-build-in-item build-in-slideX-right build-in-animate"
                                                    src="<?php echo esc_url($channel_manager_image_second['url']); ?>"
                                                    alt="<?php echo esc_attr($channel_manager_image_second['alt']); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php  $count++; endwhile;  endif; ?>
                    </div>
                </div>
             <?php } ?>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <!-- The Modal -->
<div class="modal" id="myModal">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content ebook_banner">
      <!-- Modal body -->
      <div class="modal-body web-form">
      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      <?php 
					$contact_form_id = get_field('contact_form_id',$get_page_ID); 
					$shortcode = '[contact-form-7 id="'.$contact_form_id.'" title="Contact form 1"]';
					echo do_shortcode($shortcode); 
					?>
      </div>

    </div>
  </div>
</div>
</div>
<?php get_footer(); ?>