<?php
/* Template Name: Pricing Page 
*/
get_header();
$get_page_ID = get_the_ID();
$resource_banner_bg_image = get_field('resource_banner_bg_image', $get_page_ID); 
$resource_banner_search_icon = get_field('resource_banner_search_icon');
?>
<div class="mtop-100">
    <section class="connector-banner resource-page-banner"
        style="background-image:url('<?php echo $resource_banner_bg_image['url']; ?>')">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="connector-banner-info">
                        <?php if (!empty(get_field('resource_sub_heading', $get_page_ID))) { ?>
                        <span><?php echo get_field('resource_sub_heading', $get_page_ID); ?></span>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_heading', $get_page_ID))) { ?>
                        <h1><?php echo get_field('resource_banner_heading', $get_page_ID); ?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_description', $get_page_ID))) { ?>
                        <p><?php echo get_field('resource_banner_description', $get_page_ID); ?></p>
                        <?php }   ?>
                        <div class="resource-banner-button">
                            <!-- Button trigger modal -->
                            <?php $resource_banner_button = get_field('resource_banner_button', $get_page_ID);
                            if ($resource_banner_button) {
                                $resource_banner_button_url    = $resource_banner_button['url'];
                                $resource_banner_button_title  = $resource_banner_button['title'];
                                $resource_banner_button_target = $resource_banner_button['target'] ? $resource_banner_button['target'] : '_self';
                            ?>
                            <button type="button" class="custom-button " data-bs-toggle="modal"
                                data-bs-target="#staticBackdrop"><?php echo esc_html($resource_banner_button_title); ?>
                                <span class="arrow"></span> </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="pricing-table">
        <div class="container">
            <div class="row">
                <?php if( have_rows('pricing_table_repeater') ): 
                $popup = 1;    
                ?>
                <?php while( have_rows('pricing_table_repeater') ): the_row();
                 $pricing_table_heading = get_sub_field('pricing_table_heading',$get_page_ID);
                 $pricing_table_description = get_sub_field('pricing_table_description',$get_page_ID);
                 $pricing_table_button = get_sub_field('pricing_table_button',$get_page_ID);
                 $pricing_table_list_heading = get_sub_field('pricing_table_list_heading',$get_page_ID);
                 $pricing_table_list = get_sub_field('pricing_table_list',$get_page_ID);
                ?>
                <div class="col-md-4">
                    <div class="pricing-info">
                        <?php if( !empty( $pricing_table_heading ) ) { ?>
                        <h3><?php echo $pricing_table_heading; ?></h3>
                        <?php } ?>
                        <?php if( !empty( $pricing_table_description ) ) { ?>
                        <p><?php echo $pricing_table_description; ?></p>
                        <?php } ?>
           
                        <?php $support_team =  get_sub_field('support_team',$get_page_ID);
                         $pricing_table_button =  get_sub_field('pricing_table_button',$get_page_ID);
                                if ($pricing_table_button) {
                                    $pricing_table_button_url    = $pricing_table_button['url'];
                                    $pricing_table_button_title  = $pricing_table_button['title'];
                                    $pricing_table_button_target = $pricing_table_button['target'] ? $pricing_table_button['target'] : '_self';
                                ?>
                                <button type="button" class="button-transparent popup-btn-<?php echo $popup;?>" data-bs-toggle="modal"
                                    data-bs-target="#staticBackdrop"><?php echo esc_html($pricing_table_button_title); ?></button>
                                <?php } ?>



                        <div class="pricing_table_list_heading">
                            <?php if( !empty( $pricing_table_list_heading ) ) { ?>
                            <h6><?php echo $pricing_table_list_heading; ?></h6>
                            <?php } ?>
                            <ul>
                                <?php if( !empty( $pricing_table_list ) ) { ?>
                                <?php echo $pricing_table_list; ?>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                    <?php if( !empty( $support_team ) ) { ?>
                    <div class="support-team">
                       <?php echo $support_team; ?>
                    </div>
                    <?php } ?>
                </div>
                <?php $popup++; endwhile; ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <?php if( have_rows('blog_faq_repeater') ): ?>
    <section class="section-faq">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php if (!empty(get_field('faq_heading_blog',$get_page_ID))) { ?>
                    <h2><?php echo get_field('faq_heading_blog',$get_page_ID);?></h2>
                    <?php } ?>
                    <div class="faq-info">
                        <div class="accordion" id="myAccordion">
                            <?php
								$row_countt = 1;
								while( have_rows('blog_faq_repeater') ): the_row();  
								$blog_faq_heading = get_sub_field('blog_faq_heading',$get_page_ID);
								$blog_faq_description = get_sub_field('blog_faq_description',$get_page_ID);	?>
                            <div class="accordion-item">
                                <?php if( !empty( $blog_faq_heading ) ) { ?>
                                <h4 class="accordion-header" id="heading<?php echo $row_countt;?>"><button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $row_countt;?>"><?php echo $blog_faq_heading; ?></button> </h4>
                                <?php } ?>
                                <?php if( !empty( $blog_faq_description ) ) { ?>
                                <div id="collapse<?php echo $row_countt;?>" class="accordion-collapse collapse"
                                    data-bs-parent="#myAccordion">
                                    <div class="card-body">
                                        <p><?php echo $blog_faq_description; ?></p>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                            <?php $row_countt++; endwhile; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
</div>
<div class="team-section resource-subscribe">
            <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
                aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="popup-info">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            <div class="modal-body">
                            <?php
                                $pricing_table_contact_form_id = get_field('pricing_table_contact_form_id',$get_page_ID);
                                $shortcode = '[contact-form-7 id="'.$pricing_table_contact_form_id.'" title="Contact form 1"]';
                                echo do_shortcode($shortcode);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php get_footer(); ?>