<?php
/* Template Name: Product Page 
*/
get_header();
$get_page_ID = get_the_ID();
$product_banner_bg_image=get_field('product_banner_bg_image',$get_page_ID);
$page_class_name = get_field('page_class_name',$get_page_ID);
?>

<div class="mtop-100 <?php echo $page_class_name; ?>">
    <section class="solution-menu">
        <div class="container">
            <div class="solution-menu-info">
                <?php if( have_rows('product_menu_inner','option') ): 
                    $product_heading = get_field('product_heading','option');
                ?>
                <ul class="solution-menu-list">
                    <?php if( !empty( $product_heading ) ) { ?>
                    <li><?php echo $product_heading; ?></li>
                    <?php } ?>
                    <?php while( have_rows('product_menu_inner','option') ): the_row();  
                    $product_menu_link = get_sub_field('product_menu_link'); ?>
                    <li>
                        <?php  if( $product_menu_link ):
                        $product_menu_url = $product_menu_link['url'];
                        $product_menu_title = $product_menu_link['title'];
                        $product_menu_target = $product_menu_link['target'] ? $product_menu_link['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url( $product_menu_url ); ?>" class="site_default_btn"
                            target="<?php echo esc_attr( $product_menu_target ); ?>"
                            aria-label="<?php echo esc_attr($product_menu_title) ; ?>"><?php echo esc_html( $product_menu_title ); ?></a>
                        <?php endif; ?>
                    </li>
                    <?php endwhile; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </section>


    <section class="product-banner" style="background-image:url('<?php // echo $product_banner_bg_image['url'];?>')">
        <img src="<?php echo esc_url($product_banner_bg_image['url']); ?>"
            alt="<?php echo esc_attr($product_banner_bg_image['alt']); ?>">
        <div class="product-info">
            <div class="container">
                <div class="js-build-in-trigger d-flex flex-column flex-md-items-center position-relative flex-md-row build-in-animate"
                    data-build-in-stagger="100">
                    <div class=" js-build-in-item  col-md-7 text-left build-in-animate" style="transition-delay: 0ms;">
                        <?php if (!empty(get_field('product_banner_title',$get_page_ID))) { ?>
                        <h1><?php echo get_field('product_banner_title',$get_page_ID);?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('product_banner_description',$get_page_ID))) { ?>
                        <p><?php echo get_field('product_banner_description',$get_page_ID);?></p>
                        <?php } 
						$product_banner_button = get_field('product_banner_button');
						if( $product_banner_button ):
							$product_banner_url = $product_banner_button['url'];
							$product_banner_title = $product_banner_button['title'];
							$product_banner_target = $product_banner_button['target'] ? $product_banner_button['target'] : '_self';
							?>
                        <a class="custom-button" href="<?php echo esc_url( $product_banner_url ); ?>"
                            target="<?php echo esc_attr( $product_banner_target ); ?>"><?php echo esc_html( $product_banner_title ); ?><span
                                class="arrow"></span></a>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-5">
                        <div class="position-relative">
                            <?php 
                    $product_banner_image_first = get_field('product_banner_image_first',$get_page_ID);
                    $product_banner_image_second = get_field('product_banner_image_second',$get_page_ID);
                    $product_banner_image_three = get_field('product_banner_image_three',$get_page_ID);
                        if( !empty( $product_banner_image_first ) ) { ?>
                            <img class="col-12 height-auto rounded box-shadow-mktg-xl img-one"
                                src="<?php echo esc_url($product_banner_image_first['url']); ?>"
                                alt="<?php echo esc_attr($product_banner_image_first['alt']); ?>">
                            <?php } 
                        if( !empty( $product_banner_image_second ) ) { ?>
                            <img class="position-absolute js-build-in-item build-in-scale-up rounded  left-0 right-0 mx-auto build-in-animate img-sec"
                                src="<?php echo esc_url($product_banner_image_second['url']); ?>"
                                alt="<?php echo esc_attr($product_banner_image_second['alt']); ?>">
                            <?php } 
                        if( !empty( $product_banner_image_three ) ) { ?>
                            <img class="position-absolute js-build-in-item build-in-scale-up rounded  left-0 right-0 mx-auto build-in-animate img-three"
                                src="<?php echo esc_url($product_banner_image_three['url']); ?>"
                                alt="<?php echo esc_attr($product_banner_image_three['alt']); ?>">
                            <?php } ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="product-list-detail">
        <div class="product_info_first">
            <div class="container">
                <div class="js-build-in-trigger d-flex flex-column flex-md-items-center position-relative flex-md-row-reverse build-in-animate row"
                    data-build-in-stagger="100">
                    <div class="js-build-in-item col-md-6 text-left build-in-slideX-left build-in-animate "
                        style="transition-delay: 0ms;">
                        <div class="product-detail-box">
                            <?php if (!empty(get_field('product_info_first_title',$get_page_ID))) { ?>
                            <h2><?php echo get_field('product_info_first_title',$get_page_ID);?></h2>
                            <?php } ?>
                            <?php if (!empty(get_field('product_info_first_description',$get_page_ID))) { ?>
                            <p><?php echo get_field('product_info_first_description',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="position-relative">
                            <?php  
                            $product_info_first_image = get_field('product_info_first_image',$get_page_ID);
                            $product_info_first_image_up = get_field('product_info_first_image_up',$get_page_ID);
                            if( !empty( $product_info_first_image ) ) { ?>
                            <img class="height-auto position-relative js-build-in-item build-in-slideX-right build-in-animate"
                                src="<?php echo esc_url($product_info_first_image['url']); ?>"
                                alt="<?php echo esc_attr($product_info_first_image['alt']); ?>">
                            <?php } 
                            if( !empty( $product_info_first_image_up ) ) { ?>
                            <span></span>
                            <img class="position-absolute rounded col-9 height-auto top-3 right-0 box-shadow-mktg-xl js-build-in-item build-in-slideX-left build-in-animate product_info_first_image_up"
                                src="<?php echo esc_url($product_info_first_image_up['url']); ?>"
                                alt="<?php echo esc_attr($product_info_first_image_up['alt']); ?>">
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="product_info_second">
            <div class="container">
                <div class="js-build-in-trigger d-flex flex-column flex-md-items-center position-relative flex-md-row build-in-animate row"
                    data-build-in-stagger="100">
                    <div class="js-build-in-item col-md-6 text-left build-in-slideX-left build-in-animate row"
                        style="transition-delay: 0ms;">
                        <div class="product-detail-box">
                            <?php if (!empty(get_field('product_info_second_title',$get_page_ID))) { ?>
                            <h2><?php echo get_field('product_info_second_title',$get_page_ID);?></h2>
                            <?php } ?>
                            <?php if (!empty(get_field('product_info_second_description',$get_page_ID))) { ?>
                            <p><?php echo get_field('product_info_second_description',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="position-relative">
                            <?php  
                            $product_info_second_image = get_field('product_info_second_image',$get_page_ID);
                            $product_info_second_image_up = get_field('product_info_second_image_up',$get_page_ID);
                        
                            if( !empty( $product_info_second_image ) ) { ?>
                            <img class="height-auto position-relative js-build-in-item build-in-slideX-right build-in-animate"
                                src="<?php echo esc_url($product_info_second_image['url']); ?>"
                                alt="<?php echo esc_attr($product_info_second_image['alt']); ?>">
                            <?php } 
                            if( !empty( $product_info_second_image_up ) ) { ?>
                            <span></span>
                            <img class="position-absolute rounded col-9 height-auto top-3 right-0 box-shadow-mktg-xl js-build-in-item build-in-slideX-right build-in-animate product_info_second_image "
                                src="<?php echo esc_url($product_info_second_image_up['url']); ?>"
                                alt="<?php echo esc_attr($product_info_second_image_up['alt']); ?>">
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="product_info_third">
            <div class="container">
                <div class="js-build-in-trigger d-flex flex-column flex-md-items-center position-relative flex-md-row-reverse build-in-animate row"
                    data-build-in-stagger="100">
                    <div class="js-build-in-item col-md-6 text-left build-in-slideX-left build-in-animate "
                        style="transition-delay: 0ms;">
                        <div class="product-detail-box">
                            <?php if (!empty(get_field('product_info_third_title',$get_page_ID))) { ?>
                            <h2><?php echo get_field('product_info_third_title',$get_page_ID);?></h2>
                            <?php } ?>
                            <?php if (!empty(get_field('product_info_third_description',$get_page_ID))) { ?>
                            <p><?php echo get_field('product_info_third_description',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="position-relative">
                            <?php  
                            $product_info_third_image = get_field('product_info_third_image',$get_page_ID);
                            $product_info_third_image_up = get_field('product_info_third_image_up',$get_page_ID);
                        
                            if( !empty( $product_info_third_image ) ) { ?>
                            <img class="height-auto position-relative js-build-in-item build-in-scale-down build-in-animate"
                                src="<?php echo esc_url($product_info_third_image['url']); ?>"
                                alt="<?php echo esc_attr($product_info_third_image['alt']); ?>">
                            <?php } 
                            if( !empty( $product_info_third_image_up ) ) { ?>
                            <span></span>
                            <img class="position-absolute rounded col-9 height-auto top-3 left-0 box-shadow-mktg-xl js-build-in-item build-in-scale-up build-in-animate product_info_third_image_up"
                                src="<?php echo esc_url($product_info_third_image_up['url']); ?>"
                                alt="<?php echo esc_attr($product_info_third_image_up['alt']); ?>">
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if (!empty(get_field('product_info_fourth_title',$get_page_ID))) { ?>
        <div class="product_info_second product_info_fourth">
            <div class="container">
                <div class="js-build-in-trigger d-flex flex-column flex-md-items-center position-relative flex-md-row build-in-animate row"
                    data-build-in-stagger="100">
                    <div class="js-build-in-item col-md-6 text-left build-in-slideX-left build-in-animate row"
                        style="transition-delay: 0ms;">
                        <div class="product-detail-box">
                          
                            <h2><?php echo get_field('product_info_fourth_title',$get_page_ID);?></h2>
                           
                            <?php if (!empty(get_field('product_info_fourth_description',$get_page_ID))) { ?>
                            <p><?php echo get_field('product_info_fourth_description',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="position-relative">
                            <?php  
                            $product_info_fourth_image = get_field('product_info_fourth_image',$get_page_ID);
                            $product_info_fourth_image_up = get_field('product_info_fourth_image_up',$get_page_ID);
                        
                            if( !empty( $product_info_fourth_image ) ) { ?>
                            <img class="height-auto position-relative js-build-in-item build-in-slideX-right build-in-animate"
                                src="<?php echo esc_url($product_info_fourth_image['url']); ?>"
                                alt="<?php echo esc_attr($product_info_fourth_image['alt']); ?>">
                            <?php } 
                            if( !empty( $product_info_fourth_image_up ) ) { ?>
                            <span></span>
                            <img class="position-absolute rounded col-9 height-auto top-3 right-0 box-shadow-mktg-xl js-build-in-item build-in-slideX-right build-in-animate product_info_fourth_image "
                                src="<?php echo esc_url($product_info_fourth_image_up['url']); ?>"
                                alt="<?php echo esc_attr($product_info_fourth_image_up['alt']); ?>">
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </section>


    <section class="scroll-section">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="analytics-platform-heading">
                        <?php if (!empty(get_field('analytics_platform_heading',$get_page_ID))) { ?>
                        <h2><?php echo get_field('analytics_platform_heading',$get_page_ID);?></h2>
                        <?php } ?>
                        <?php if (!empty(get_field('analytics_platform_desc',$get_page_ID))) { ?>
                        <p><?php echo get_field('analytics_platform_desc',$get_page_ID);?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="locker">
            <?php if( have_rows('analytics_platform') ): ?>
            <div class="locker__content custom-scroll">
                <?php 
                $row_count = 1;
                while( have_rows('analytics_platform') ): the_row();
                $analytics_platform_title = get_sub_field('analytics_platform_title',$get_page_ID);
                $analytics_platform_description = get_sub_field('analytics_platform_description',$get_page_ID);
                $analytics_platform_icon = get_sub_field('analytics_platform_icon',$get_page_ID);
                $analytics_platform_image = get_sub_field('analytics_platform_image',$get_page_ID);
                ?>
                <div class="locker__section locker__section--1 cb" data-swap="image--<?php echo $row_count; ?>">
                    <?php if( !empty( $analytics_platform_icon ) ): ?>
                    <div class="imgicon"> <img src="<?php echo esc_url($analytics_platform_icon['url']); ?>"
                            alt="<?php echo esc_attr($analytics_platform_icon['alt']); ?>"><span></span></div>
                    <?php endif; 
                    if( !empty( $analytics_platform_title ) ) { ?>
                    <h3><?php echo $analytics_platform_title; ?></h3>
                    <?php } ?>
                    <?php if( !empty( $analytics_platform_description ) ) { ?>
                    <?php echo $analytics_platform_description; ?>
                    <?php } ?>
                    <img class="image-mb image--<?php echo $row_count; ?>"
                        src="<?php echo esc_url($analytics_platform_image['url']); ?>"
                        alt="<?php echo esc_attr($analytics_platform_image['alt']); ?>">
                </div>
                <?php $row_count++; endwhile; ?>
            </div>
            <?php endif; ?>
            <div class="locker__image">
                <?php if( have_rows('analytics_platform') ): ?>
                <div class="locker__container">
                    <?php 
                        $row_countt = 1;
                        while( have_rows('analytics_platform') ): the_row();  
                        $analytics_platform_image = get_sub_field('analytics_platform_image',$get_page_ID);
                        ?>
                    <img class="image image--<?php echo $row_countt; ?>"
                        src="<?php echo esc_url($analytics_platform_image['url']); ?>"
                        alt="<?php echo esc_attr($analytics_platform_image['alt']); ?>">
                    <?php $row_countt++; endwhile; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <section class="analatics-data">
        <div class="container">
            <div class="home-campaign-productivity js-section " data-color-mode="dark" data-light-theme="light"
                data-dark-theme="dark">
                <div class="d-flex flex-column flex-md-row gutter js-build-in-trigger build-in-animate">
                    <?php if( have_rows('analytics_data_repeater') ): ?>
                    <?php while( have_rows('analytics_data_repeater') ): the_row();
                        $analytics_data_heading = get_sub_field('analytics_data_heading',$get_page_ID);
                        $analytics_data_description = get_sub_field('analytics_data_description',$get_page_ID);
                        $analytics_data_image = get_sub_field('analytics_data_image');
                        ?>
                    <div class="col-md-6">
                        <div class="overflow-hidden rounded-3 home-skew js-home-skew"
                            style="transform: perspective(700px) rotateX(0.03deg) rotateY(-0.03deg);">
                            <div
                                class="feature-card-mktg js-feature-card-mktg d-md-flex rounded-3 color-bg-subtle border position-relative height-full flex-column">
                                <div class="analatics-data-info">
                                    <?php if( !empty( $analytics_data_heading ) ) { ?>
                                    <h4 class="normal-arrow"><?php echo $analytics_data_heading; ?><span
                                            class="arrow"></span></h4>
                                    <?php } ?>
                                    <?php if( !empty( $analytics_data_description ) ) { ?>
                                    <p><?php echo $analytics_data_description; ?></p>
                                    <?php } ?>
                                </div>
                                <?php
                                if( !empty( $analytics_data_image ) ) { ?>
                                <div class="analytics_data_image">
                                    <img src="<?php echo esc_url($analytics_data_image['url']); ?>"
                                        alt="<?php echo esc_attr($analytics_data_image['alt']); ?>">
                                </div>
                                <?php } ?>
                                <div class="position-absolute bottom-0 right-0 events-none home-feature-card-shine js-feature-card-shine-mktg z-n1"
                                    style="transform: translate(183.41px, 137.63px);"></div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <section class="resources-section">
        <?php get_template_part('components/resources', 'section');?>
    </section>

    <section class="section-faq">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                   



                        <?php if( have_rows('faq_list') ): ?>
                            <?php if (!empty(get_field('faq_heading',$get_page_ID))) { ?>
                                <h2><?php echo get_field('faq_heading',$get_page_ID);?></h2>
                            <?php } ?>
                            <div class="faq-info">
                                <div class="accordion" id="myAccordion">
                                    <?php
                                    $row_countt = 1;
                                    while( have_rows('faq_list') ): the_row();  
                                    $faq_list_heading = get_sub_field('faq_list_heading',$get_page_ID);
                                    $faq_list_description = get_sub_field('faq_list_description',$get_page_ID);
                                    ?>
                                        <div class="accordion-item"> 
                                            <?php if( !empty( $faq_list_heading ) ) { ?>
                                                <h4 class="accordion-header" id="heading<?php echo $row_countt;?>">
                                                <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse<?php echo $row_countt;?>"><?php echo $faq_list_heading; ?></button></h4>
                                            <?php } ?>
                                            <?php if( !empty( $faq_list_description ) ) { ?>
                                                <div id="collapse<?php echo $row_countt;?>" class="accordion-collapse collapse" data-bs-parent="#myAccordion">
                                                    <div class="card-body"> 
                                                        <p><?php echo $faq_list_description; ?></p> 
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    <?php $row_countt++; endwhile; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                </div>
            </div>
        </div>
    </section>

</div>

<?php get_footer(); ?>