<?php
/* Template Name: Resource Page 
*/
get_header();
$get_page_ID = get_the_ID();
$resource_banner_bg_image = get_field('resource_banner_bg_image', $get_page_ID);
$themedata = get_fields('options');
$field = $args ?? [];
$themedata = $args ?? [];
$resource_banner_search_icon = get_field('resource_banner_search_icon');
?>
<div class="mtop-100">
    <section class="connector-banner resource-page-banner"
        style="background-image:url('<?php echo $resource_banner_bg_image['url']; ?>')">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="connector-banner-info">
                        <?php if (!empty(get_field('resource_sub_heading', $get_page_ID))) { ?>
                        <span><?php echo get_field('resource_sub_heading', $get_page_ID); ?></span>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_heading', $get_page_ID))) { ?>
                        <h1><?php echo get_field('resource_banner_heading', $get_page_ID); ?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('resource_banner_description', $get_page_ID))) { ?>
                        <p><?php echo get_field('resource_banner_description', $get_page_ID); ?></p>
                        <?php }   ?>
                        <div class="resource-banner-button">
                            <!-- Button trigger modal -->
                            <?php $resource_banner_button = get_field('resource_banner_button', $get_page_ID);
                            if ($resource_banner_button) {
                                $resource_banner_button_url    = $resource_banner_button['url'];
                                $resource_banner_button_title  = $resource_banner_button['title'];
                                $resource_banner_button_target = $resource_banner_button['target'] ? $resource_banner_button['target'] : '_self';
                            ?>
                            <button type="button" class="custom-button " data-bs-toggle="modal"
                                data-bs-target="#staticBackdrop"><?php echo esc_html($resource_banner_button_title); ?>
                                <span class="arrow"></span> </button>
                            <?php } ?>
                            <div class="search-button">
                                <form class="search-form" action="<?php echo get_site_url(); ?>" method="get">
                                    <div class="custom-search">
                                        <div class="form-group">
                                            <input type="hidden" name="postType" value="<?php echo $postType; ?>">
                                            <input aria-label="search" placeholder="Search here" class="form-control"
                                                type="text" value="<?php the_search_query(); ?>" name="s" id="search"
                                                required>
                                            <button aria-label="search-button" class="search-submit-button"
                                                type="submit">
                                                <img src="<?php echo esc_url($resource_banner_search_icon['url']); ?>"
                                                    alt="<?php echo esc_attr($resource_banner_search_icon['alt']); ?>">
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="featured-post">
        <div class="container">
            <div class="featured-post-bg">
                <div class="row">
                    <div class="col-md-12">
                        <div class="featured-heading">
                            <?php if (!empty(get_field('resource_sub_heading', $get_page_ID))) { ?>
                            <h2><?php echo get_field('featured_post_heading', $get_page_ID); ?></h2>
                            <?php } ?>
                            <a href="#resource-tab" class="custom-link"
                                target="<?php echo esc_attr($analytics_button_target); ?>"
                                aria-label="<?php echo esc_attr($analytics_button_title); ?>">See All Posts<span
                                    class="arrow"></span></a>
                        </div>
                    </div>
                </div>
                <div class="featured-post-carousel sliders">
                    <?php
                    $wp_query = new WP_Query();
                    $wp_query->query(array("post_type" => "post", "posts_per_page" => 5, 'orderby' => 'date', 'order' => 'DESC')); ?>
                    <?php while (have_posts()) : the_post(); ?>
                    <!--slider first start-->
                    <div>
                        <div class="featured-post-blk">
                            <div class="featured-post-col8">
                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                <img src="<?php echo the_post_thumbnail_url() ?>" alt="<?php echo $alt_text ;?>" />
                            </div>
                            <div class="featured-post-col4">
                                <div class="camera_caption fadeIn">
                                    <h2><?php echo wp_trim_words( get_the_title(), 8, ' ...' );?></h2>

                                    <?php
                                    $trim_length = 40;  //desired length of text to display
                                    $value_more = '...'; // what to add at the end of the trimmed text
                                    $custom_field = 'single_detail_short_description';
                                    $value = get_post_meta($post->ID, $custom_field, true);
                                    if ($value) {
                                        echo'<p>'. wp_trim_words( $value, $trim_length, $value_more).'</p>';
                                    }
                                    ?>
                                    <a href="<?php echo get_permalink(); ?>" class="custom-link" target="_self"
                                        aria-label="Campaign Tracking">Read full post<span class="arrow"></span></a><span class="post-type"><?php echo get_post_type(); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    endwhile;
                    wp_reset_query(); ?>
                </div>

            </div>
        </div>
    </section>

    <section class="resource-tab" id="resource-tab">
        <div class="container">
            <div class="blog-content">
                <div class="row">
                    <div class="col-lg-12 col-12">
                        <div class="blog-tab-content">
                            <div class="filter-outer">
                                <?php
                                        $staticResourceTaxanomy = [
                                            'category',
                                            'ebook_categories',
                                            'infographics_categories',
                                            'press_release_categories'

                                        ];
                                        $staticGlobalTaxanomy = [
                                            'post' => 'category',
                                            'ebook' => 'ebook_categories',
                                            'infographics' => 'infographics_categories',
                                            'press-release' => 'press_release_categories'
                                        ];
                                        $cond = basename(get_page_template()) === 'template-resource.php';
                                        if ($cond) {
                                            $groups = get_terms($staticResourceTaxanomy);
                                            $postType = implode(',', array_keys($staticGlobalTaxanomy));
                                        } else {
                                            $postType = get_post_type();
                                            $groups = get_terms([
                                                $staticGlobalTaxanomy[$postType]
                                            ]);
                                        }
                                        ?>
                                <?php if (isset($groups) && (!empty($groups))) {
                                        ?>
                                <div class="drop-down-filter">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <?php if( have_rows('resources_type') ): ?>
                                        <?php while( have_rows('resources_type') ): the_row();  
                                                    $resource_list_icon = get_sub_field('resource_list_icon',$get_page_ID);
                                                    $resources_list_title = get_sub_field('resources_list_title',$get_page_ID); ?>
                                        <?php if( !empty( $resources_list_title ) ) { ?>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link"
                                                id="pills-<?php echo strtolower($resources_list_title); ?>-tab"
                                                data-description="asd" data-bs-toggle="pill"
                                                data-tableid="<?php echo strtolower($resources_list_title); ?>"
                                                data-bs-target="#pills-<?php echo strtolower($resources_list_title); ?>"
                                                type="button" role="tab"
                                                aria-controls="pills-<?php echo strtolower($resources_list_title); ?>"
                                                aria-selected="false">
                                                <div class="tabs-icon">
                                                    <?php if( !empty( $resource_list_icon ) ): ?>
                                                    <img src="<?php echo esc_url($resource_list_icon['url']); ?>"
                                                        alt="<?php echo esc_attr($resource_list_icon['alt']); ?>">
                                                    <?php endif; ?>
                                                    <p><?php echo $resources_list_title; ?></p>
                                                </div>
                                            </a>
                                        </li>
                                        <?php } ?>
                                        <?php endwhile; ?>
                                        <?php endif; ?>
                                    </ul>
                                    <div class="category-outer-form " id="menuopties">
                                        <p class="select-cats">Select Category <span><i class="fa fa-angle-down" aria-hidden="true"></i></span></p>
                                        <form action="<?php echo site_url() ?>/wp-admin/admin-ajax.php" method="POST"
                                            class="filter" id="filter">
                                            <input type="hidden" name="postType" value='<?= $postType ?>'>
                                                <div class="drop-outer">
                                                    <?php $term_exist = array();
                                                        echo '<ul class="groups-list drop-list">';
                                                            foreach ($groups as $group) :
                                                                if (!in_array($group->slug, $term_exist)) {
                                                                    echo '<li><input id="group_' . $group->term_id . '" type="checkbox" name="catg_select[]" value="' . $group->slug . '" class="checkbox-input"  />
                                                                    <label for="group_' . $group->term_id . '">' . $group->name . '</label></li>';
                                                                    array_push($term_exist, $group->slug);
                                                                }
                                                        endforeach;
                                                    echo '</ul>';  ?>
                                                </div> 
                                            <input type="hidden" name="action" value="myfilter">
                                        </form>
                                    </div>

                                </div>
                                <?php  } ?>
                                <div class="left-filter">
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="pills-all" role="tabpanel"
                                            aria-labelledby="all-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                                $wp_query->query(array("post_type"=> array('post', 'infographics','press-release'),"posts_per_page" =>-1,'orderby' => 'date','order' => 'DESC'));
                                                ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <h6><?php foreach((get_the_category()) as $category) { 
                                                                    echo $category->cat_name . ' '; 
                                                                    } ?></h6>
                                                                <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?> </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Read full
                                                                    post<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                                </h3>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID()); $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                                <div id="pagination-container"></div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-pr" role="tabpanel"
                                            aria-labelledby="prs-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                                $wp_query->query(array("post_type"=>"press-release","posts_per_page" =>-1,'orderby' => 'date','order' => 'DESC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <!-- <h6>Marketing Insights</h6> -->
                                                                <h2><a
                                                                        href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Read full
                                                                    post<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                                <div id="pagination-container3"></div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-blogs" role="tabpanel"
                                            aria-labelledby="blogs-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                                $wp_query->query(array("post_type"=>"post","posts_per_page" =>-1,'orderby' => 'date','order' => 'DESC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <h6><?php foreach((get_the_category()) as $category) { 
                                                                    echo $category->cat_name . ' '; 
                                                                    } ?></h6>
                                                                <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Read full
                                                                    post<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                                <div id="pagination-container2"></div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-podcasts" role="tabpanel"
                                            aria-labelledby="podcasts-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                                $wp_query->query(array("post_type"=>"podcast","posts_per_page" =>-1,'orderby' => 'date','order' => 'ASC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 list-items">
                                                        <div class="row single-item">
                                                            <div class="col-md-6">
                                                                <!-- <h6>Marketing Insights</h6> -->
                                                                <h2><a
                                                                        href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Listen
                                                                    Now<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                                </h3>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                                <div id="pagination-container3"></div>
                                            </div>

                                        </div>
                                        <div class="tab-pane fade" id="pills-infographics" role="tabpanel"
                                            aria-labelledby="infographics-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                                $wp_query->query(array("post_type"=>"infographics","posts_per_page" =>8,'orderby' => 'date','order' => 'DESC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 single-item">
                                                        <div class="row single-item">
                                                            <div class="col-md-6 single-item">
                                                                <!-- <h6>Marketing Insights</h6> -->
                                                                <h2><a
                                                                        href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Read full
                                                                    post<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6 single-item">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="tab-pane fade" id="pills-ebooks" role="tabpanel"
                                            aria-labelledby="ebooks-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                            $wp_query->query(array("post_type"=>"ebook","posts_per_page" =>8,'orderby' => 'date','order' => 'DESC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 single-item">
                                                        <div class="row single-item">
                                                            <div class="col-md-6 single-item">
                                                                <!-- <h6>Marketing Insights</h6> -->
                                                                <h2><a
                                                                        href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Download
                                                                    Now<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6 single-item">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-products" role="tabpanel"
                                            aria-labelledby="videos-tab" tabindex="0">
                                            <?php $wp_query = new WP_Query();
                                            $wp_query->query(array("post_type"=>"product","posts_per_page" =>8,'orderby' => 'date','order' => 'DESC')); ?>
                                            <div class="blog-flex pagination-content">
                                                <div class="row">
                                                    <?php while(have_posts()) : the_post() ;?>
                                                    <div class="col-md-6 single-item">
                                                        <div class="row single-item">
                                                            <div class="col-md-6 single-item">
                                                                <!-- <h6>Marketing Insights</h6> -->
                                                                <h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                                </h2>
                                                                <p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
                                                                </p>
                                                                <a href="<?php the_permalink(); ?>" class="custom-link"
                                                                    target="_self" aria-label="Read full post">Download
                                                                    Now<span class="arrow"></span></a>
                                                                    <span class="post-type"><?php echo get_post_type(); ?></span>
                                                            </div>
                                                            <div class="col-md-6 single-item">
                                                                <?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                                <img src="<?php echo the_post_thumbnail_url() ?>"
                                                                    alt="<?php echo $alt_text ;?>" />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <?php 
                                                    endwhile;
                                                    wp_reset_query(); ?>
                                                </div>
                                            </div></div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="conatiner">
                        <div class="blog-flex pagination-content blog-flex-select">
                            <div class="row post-listing ">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <div class="team-section resource-subscribe">
        <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="popup-info">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body">
                            <?php echo do_shortcode( '[contact-form-7 id="5" title="Resource Page Subscribe Form"]' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<script>
    var wpcf7Elm = document.querySelector( '.wpcf7' );
    wpcf7Elm.addEventListener( 'wpcf7mailsent', function(event) {
        window.dataLayer.push({
            'event': 'subscribe_now', 
            'login_status': 'Null',
            'page_location': pageLocation,
            'resoure_type':   'Null', 
            'resource_title': 'Null',
            'country': countryName,
            'is_content': contentData, 
            'page_id': pageId,
            'page_title': pageTitle,
            'page_referrer': pageReffer,
        });
    }, false );
</script>
<?php get_footer(); ?>