<?php
/* Template Name: Solution Page 
*/
get_header();
$get_page_ID = get_the_ID();
$page_class_name = get_field('page_class_name',$get_page_ID);
?>
<div class="mtop-100 <?php echo $page_class_name; ?>">
    <section class="solution-menu">
        <div class="container">
            <div class="solution-menu-info">
                <?php if( have_rows('solution_menu_inner','option') ): 
            $solution_heading = get_field('solution_heading','option');
            ?>
                <ul class="solution-menu-list">
                    <?php if( !empty( $solution_heading ) ) { ?>
                    <li><?php echo $solution_heading; ?></li>
                    <?php } ?>
                    <?php while( have_rows('solution_menu_inner','option') ): the_row();  
                $solution_menu_link = get_sub_field('solution_menu_link'); ?>
                    <li>
                        <?php  if( $solution_menu_link ):
                        $solution_menu_url = $solution_menu_link['url'];
                        $solution_menu_title = $solution_menu_link['title'];
                        $solution_menu_target = $solution_menu_link['target'] ? $solution_menu_link['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url( $solution_menu_url ); ?>" class="site_default_btn"
                            target="<?php echo esc_attr( $solution_menu_target ); ?>"
                            aria-label="<?php echo esc_attr($solution_menu_title) ; ?>"><?php echo esc_html( $solution_menu_title ); ?></a>
                        <?php endif; ?>
                    </li>
                    <?php endwhile; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <section class="solution-banner">
        <?php $solution_banner_bg_image = get_field('solution_banner_bg_image');
                if( !empty( $solution_banner_bg_image ) ) { ?>
        <img src="<?php echo esc_url($solution_banner_bg_image['url']); ?>"
            alt="<?php echo esc_attr($solution_banner_bg_image['alt']); ?>">
        <?php } ?>
        <div class="solution-banner-info">
            <?php if (!empty(get_field('solution_banner_subtitle',$get_page_ID))) { ?>
            <span><?php echo get_field('solution_banner_subtitle',$get_page_ID);?></span>
            <?php } ?>
            <?php if (!empty(get_field('solution_banner_title',$get_page_ID))) { ?>
            <h1><?php echo get_field('solution_banner_title',$get_page_ID);?></h1>
            <?php } ?>
            <?php if (!empty(get_field('solution_banner_description',$get_page_ID))) { ?>
            <p><?php echo get_field('solution_banner_description',$get_page_ID);?></p>
            <?php } 
                $solution_banner_button = get_field('solution_banner_button'); 
                if( $solution_banner_button ):
                        $solution_banner_url = $solution_banner_button['url'];
                        $solution_banner_title = $solution_banner_button['title'];
                        $solution_banner_target = $solution_banner_button['target'] ? $solution_banner_button['target'] : '_self';
                        ?>
            <a href="<?php echo esc_url( $solution_banner_url ); ?>" class="custom-button"
                target="<?php echo esc_attr( $solution_banner_target ); ?>"
                aria-label="<?php echo esc_attr($solution_banner_title) ; ?>"><?php echo esc_html( $solution_banner_title ); ?>
                <span class="arrow"></span>
            </a>
            <?php endif; ?>
        </div>
    </section>
    <section class="section-optimize-channel">
        <div class="container">
            <?php if (!empty(get_field('optimize_channel_heading',$get_page_ID))) { ?>
            <div class="channel_description">
                <div class="row middle-align">
                    <div class="col-md-12">
                        <div class="optimize-channel">

                            <h2><?php echo get_field('optimize_channel_heading',$get_page_ID);?></h2>

                            <?php if (!empty(get_field('optimize_channel_subheading',$get_page_ID))) { ?>
                            <p><?php echo get_field('optimize_channel_subheading',$get_page_ID);?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php $optimize_channel_image = get_field('optimize_channel_image');
                    if( !empty( $optimize_channel_image ) ) { ?>
                        <div class="imgblk">
                            <img src="<?php echo esc_url($optimize_channel_image['url']); ?>"
                                alt="<?php echo esc_attr($optimize_channel_image['alt']); ?>">
                        </div>
                        <?php } ?>
                    </div>
                    <div class="col-md-6">
                        <?php if (!empty(get_field('optimize_channel_description',$get_page_ID))) { ?>
                        <div class="channel_description_info">
                            <p><?php echo get_field('optimize_channel_description',$get_page_ID);?></p>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </section>
    <section class="timeline ">
        <div class="container">
        <?php if (!empty(get_field('channel_manager_heading',$get_page_ID))) { ?>
            <div class="channel-manager"> 
                <h2><?php echo get_field('channel_manager_heading',$get_page_ID);?></h2>
   
                <?php if (!empty(get_field('channel_manager_description',$get_page_ID))) { ?>
                <p><?php echo get_field('channel_manager_description',$get_page_ID);?></p>
                <?php } ?>
            </div>
            <div class="position-relative">
                <div class="position-absolute top-0 bottom-0 color-bg-line"></div>
                <?php
                 $count = 1;
                if( have_rows('channel_manager_repeater') ): 
                    while( have_rows('channel_manager_repeater') ): the_row(); 
                        $channel_manager_image = get_sub_field('channel_manager_image',$get_page_ID); 
                        $channel_manager_image_second = get_sub_field('channel_manager_image_second',$get_page_ID); 
                        $channel_manager_title = get_sub_field('channel_manager_title',$get_page_ID);
						$channel_manager_info = get_sub_field('channel_manager_info',$get_page_ID);
                        ?>

                <?php if(($count == 2 ) || ($count == 4 )){ ?>
                <div class="container mx-auto p-responsive pb-8 pb-md-9 count-<?php echo $count; ?> even">
                    <div
                        class="js-build-in-trigger d-md-flex flex-row flex-justify-center flex-items-center my-7 build-in-animate">
                        <div
                            class="d-flex flex-justify-start flex-1 team-collaboration--text-right js-build-in-item build-in-scale-right build-in-animate">
                            <div
                                class="color-bg-default box-shadow-card-border-mktg rounded-3 text-center text-md-left col-10 mx-auto mx-md-0 p-5 team-collaboration-box team-collaboration-box--right">
                                <?php if( !empty( $channel_manager_title ) ) { ?>
                                <h3><?php echo $channel_manager_title; ?></h3>
                                <?php } ?>
                                <?php if( !empty( $channel_manager_info ) ) { ?>
                                <p><?php echo $channel_manager_info; ?></p>
                                <?php } ?>
                            </div>
                        </div>
                        <div
                            class="d-flex flex-justify-center flex-items-center team-collaboration--dot js-build-in-item build-in-animate">
                            <div class="circle flex-shrink-0 color-bg-emphasis mx-4 mt-3 mt-md-6 mb-6"></div>
                        </div>
                        <div
                            class="d-flex flex-1 flex-justify-end js-build-in-item build-in-scale-left build-in-animate">
                            <div class="position-relative">
                                <?php if( !empty( $channel_manager_image ) ){ ?>
                                <img class="rounded-3 width-full height-auto box-shadow-default-border-mktg "
                                    src="<?php echo esc_url($channel_manager_image['url']); ?>"
                                    alt="<?php echo esc_attr($channel_manager_image['alt']); ?>">
                                <?php } ?>
                                <?php if( !empty( $channel_manager_image_second ) ){ ?>
                                <img class="position-absolute timelineimg-animate left-md-n3 col-11 height-auto rounded-3 box-shadow-default-border-mktg js-build-in-item build-in-slideX-right build-in-animate"
                                    src="<?php echo esc_url($channel_manager_image_second['url']); ?>"
                                    alt="<?php echo esc_attr($channel_manager_image_second['alt']); ?>">
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else { ?>
                <div class="container mx-auto p-responsive pb-8 pb-md-9 count-<?php echo $count; ?> odd">
                    <div
                        class="js-build-in-trigger d-md-flex flex-row flex-justify-center flex-items-center my-7 build-in-animate">
                        <div
                            class="d-flex flex-1 flex-justify-end js-build-in-item build-in-scale-left build-in-animate">
                            <div class="position-relative">
                                <?php if( !empty( $channel_manager_image ) ){ ?>
                                <img class="rounded-3 width-full height-auto box-shadow-default-border-mktg "
                                    src="<?php echo esc_url($channel_manager_image['url']); ?>"
                                    alt="<?php echo esc_attr($channel_manager_image['alt']); ?>">
                                <?php } ?>
                                <?php if( !empty( $channel_manager_image_second ) ){ ?>
                                <img class="position-absolute timelineimg-animate left-md-n3 col-11 height-auto rounded-3 box-shadow-default-border-mktg js-build-in-item build-in-slideX-right build-in-animate"
                                    src="<?php echo esc_url($channel_manager_image_second['url']); ?>"
                                    alt="<?php echo esc_attr($channel_manager_image_second['alt']); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div
                            class="d-flex flex-justify-center flex-items-center team-collaboration--dot js-build-in-item build-in-animate">
                            <div class="circle flex-shrink-0 color-bg-emphasis mx-4 mt-3 mt-md-6 mb-6"></div>
                        </div>
                        <div
                            class="d-flex flex-justify-start flex-1 team-collaboration--text-right js-build-in-item build-in-scale-right build-in-animate">
                            <div
                                class="color-bg-default box-shadow-card-border-mktg rounded-3 text-center text-md-left col-10 mx-auto mx-md-0 p-5 team-collaboration-box team-collaboration-box--right">
                                <?php if( !empty( $channel_manager_title ) ) { ?>
                                <h3><?php echo $channel_manager_title; ?></h3>
                                <?php } ?>
                                <?php if( !empty( $channel_manager_info ) ) { ?>
                                <p><?php echo $channel_manager_info; ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php  } ?>
                <?php  $count++;
                endwhile; 
            endif; ?>
            </div>
            <?php } ?>
        </div>
    </section>
    <section class="digg-advantages">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="adv-info">
                        <?php if (!empty(get_field('diggrowth_advantages_heading',$get_page_ID))) { ?>
                        <h2><?php echo get_field('diggrowth_advantages_heading',$get_page_ID);?></h2>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="home-campaign-productivity js-section " data-color-mode="dark" data-light-theme="light"
                data-dark-theme="dark">
                <div class="d-flex flex-column flex-md-row gutter js-build-in-trigger build-in-animate">
                    <?php if( have_rows('diggrowth_advantages') ): 
                    while( have_rows('diggrowth_advantages') ): the_row(); 
                    $diggrowth_advantages_icon = get_sub_field('diggrowth_advantages_icon');
                    $diggrowth_advantages_title = get_sub_field('diggrowth_advantages_title');
                    $diggrowth_advantages_description = get_sub_field('diggrowth_advantages_description');
                    ?>
                    <div class="col-md-4">
                        <div class="overflow-hidden rounded-3 home-skew js-home-skew"
                            style="transform: perspective(700px) rotateX(0deg) rotateY(-0.03deg);">
                            <div
                                class="feature-card-mktg js-feature-card-mktg d-md-flex rounded-3 color-bg-subtle border position-relative  flex-column">
                                <?php if( !empty( $diggrowth_advantages_title ) ) { ?>
                                <div class="diggrowth_advantages_info">
                                    <?php if( !empty( $diggrowth_advantages_icon ) ): ?>
                                    <div class="imgblk position-relative"> <img
                                            src="<?php echo esc_url($diggrowth_advantages_icon['url']); ?>"
                                            alt="<?php echo esc_attr($diggrowth_advantages_icon['alt']); ?>">
                                        <span
                                            class="position-absolute left-0 top-0 height-full width-full home-campaign-glowing-icon-glow z-n1"
                                            style="background-color: rgb(212 18 255 / 25%);filter: blur(25px);"></span>
                                    </div>
                                    <?php endif; ?>
                                    <h3 class="normal-arrow"><?php echo $diggrowth_advantages_title; ?><span
                                            class="arrow"></span></h3>
                                    <?php if( !empty( $diggrowth_advantages_description ) ) { ?>
                                    <p><?php echo $diggrowth_advantages_description; ?></p>
                                    <?php } ?>
                                </div>
                                <?php } ?>
                                <div class="position-absolute bottom-0 right-0 events-none home-feature-card-shine js-feature-card-shine-mktg z-n1"
                                    style="transform: translate(198.07px, -26.16px);"></div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; endif; ?>
                </div>
            </div>
        </div>
    </section>

    <?php get_template_part('components/revenue-focused', 'section');?>
    <section class="resources-section">
        <?php get_template_part('components/resources', 'section');?>
    </section>
</div>
<?php get_footer(); ?>