<?php

require_once 'wp-load.php';

// Function to update meta title and description by permalink using Rank Math
function update_meta_by_permalink($permalink, $meta_title, $meta_description) {
    $post = get_page_by_path($permalink, OBJECT, 'post');

    if ($post instanceof WP_Post) {
        $post_id = $post->ID;

        update_post_meta($post_id, '_yoast_wpseo_title', $meta_title);
        update_post_meta($post_id, '_yoast_wpseo_metadesc', $meta_description);
    }
}

// Path to the CSV file
$csv_file = 'update.csv';

// Read the CSV file
if (($handle = fopen($csv_file, 'r')) !== false) {
    // Skip the header row
    fgetcsv($handle);

    // Process each row
    while (($data = fgetcsv($handle)) !== false) {
        $permalink = sanitize_text_field($data[0]);
        $meta_title = sanitize_text_field($data[1]);
        $meta_description = sanitize_text_field($data[2]);

        // Update the meta title and description by permalink
        update_meta_by_permalink($permalink, $meta_title, $meta_description);
    }

    fclose($handle);
}

?>
