<?php
/**
* The template for displaying 404 pages (not found)
*
* @link https://codex.wordpress.org/Creating_an_Error_404_Page
*
* @package WordPress
* @subpackage Twenty_Nineteen
* @since Twenty Nineteen 1.0
*/

get_header();
?>
<div class="mtop-100">
    <div class="error-404 not-found">
        <?php $banner_info_bg = get_field('404_banner_info_bg','option'); ?>
        <section class="connector-banner resource-page-banner"
            style="background-image:url('<?php echo $banner_info_bg['url'];?>')">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="connector-banner-info">
                            <?php if (!empty(get_field('404_banner_info','option'))) { ?>
                            <?php echo get_field('404_banner_info','option');?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
                <?php if( have_rows('404_repeater','option') ){ ?>
                <?php while( have_rows('404_repeater','option') ): the_row(); 
            $diggrowth_advantages_heading = get_sub_field('diggrowth_advantages_heading','option'); ?>
                <?php if( !empty( $diggrowth_advantages_heading ) ) { ?>
                    <section class="digg-advantages">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="adv-info">
                            <h2><?php echo $diggrowth_advantages_heading; ?></h2>
                        </div>
                    </div>
                </div>
                <?php } ?>
                <div class="home-campaign-productivity js-section " data-color-mode="dark" data-light-theme="light"
                    data-dark-theme="dark">
                    <div class="d-flex flex-column flex-md-row gutter js-build-in-trigger">
                        <?php if( have_rows('diggrowth_advantages','option') ){ ?>
                        <?php while( have_rows('diggrowth_advantages','option') ): the_row(); 
                    $diggrowth_advantages_icon = get_sub_field('diggrowth_advantages_icon','option');
                    $diggrowth_advantages_title = get_sub_field('diggrowth_advantages_title','option');
                    $diggrowth_advantages_description = get_sub_field('diggrowth_advantages_description','option');
                    ?>
                        <div class="col-md-4">
                            <?php 
                            $link = get_sub_field('diggrowth_advantages_link');
                            if( $link ){
                                $link_url = $link['url'];
                                $link_title = $link['title'];
                                $link_target = $link['target'] ? $link['target'] : '_self';
                                ?>
                                <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">

                                <div class="overflow-hidden rounded-3 home-skew js-home-skew"
                                    style="transform: perspective(700px) rotateX(0deg) rotateY(-0.03deg);">
                                    <div class="feature-card-mktg js-feature-card-mktg d-md-flex rounded-3 color-bg-subtle border position-relative  flex-column"
                                        style="height: 538.578px;">
                                        <div class="diggrowth_advantages_info">
                                            <?php if( !empty( $diggrowth_advantages_icon ) ): ?>
                                            <div class="imgblk position-relative">
                                                <img src="<?php echo esc_url($diggrowth_advantages_icon['url']); ?>"
                                                    alt="<?php echo esc_attr($diggrowth_advantages_icon['alt']); ?>" />
                                                <span
                                                    class="position-absolute left-0 top-0 height-full width-full home-campaign-glowing-icon-glow z-n1"
                                                    style="background-color: rgb(212 18 255 / 25%);filter: blur(25px);"></span>
                                            </div>
                                            <?php endif; ?> 
                                            <h3 class="normal-arrow"><?php echo esc_html( $link_title ); ?><span
                                                    class="arrow"></span></h3> 
                                            <?php if( !empty( $diggrowth_advantages_description ) ) { ?>
                                            <p><?php echo $diggrowth_advantages_description; ?></p>
                                            <?php } ?>
                                        </div>
                                        <div class="position-absolute bottom-0 right-0 events-none home-feature-card-shine js-feature-card-shine-mktg z-n1"
                                            style="transform: translate(198.07px, -26.16px);"></div>
                                    </div>
                                </div>
                                </a>
                            <?php }?>
                        </div>
                        <?php endwhile; ?>

                        <?php } ?>
                    </div>
                </div>
                </div>
        </section>
                <?php endwhile; ?>
                <?php } ?>
           
    </div><!-- .error-404 -->
</div>
<?php get_footer();