<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();
$get_page_ID = get_the_ID();
$archive_banner_bg_image = get_field('archive_banner_bg_image', 'option');
$description = get_the_archive_description();
?>
<div class="mtop-100">
	<section class="connector-banner resource-page-banner"
		style="background-image:url('<?php echo $archive_banner_bg_image['url']; ?>')">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="connector-banner-info">
						<span>Category Archives:</span>
						<h1><?php printf( __( '%s', 'twentyten' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h1> 
						<?php echo category_description(); ?>
						<div class="resource-banner-button">
							<!-- Button trigger modal -->
							<?php $archive_banner_button = get_field('archive_banner_button','option');
                            if ($archive_banner_button) {
                                $archive_banner_button_url    = $archive_banner_button['url'];
                                $archive_banner_button_title  = $archive_banner_button['title'];
                                $archive_banner_button_target = $archive_banner_button['target'] ? $archive_banner_button['target'] : '_self';
                            ?>
							<button type="button" class="custom-button " data-bs-toggle="modal"
								data-bs-target="#staticBackdrop"><?php echo esc_html($archive_banner_button_title); ?>
								<span class="arrow"></span> </button>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- PAGE CONTENTS -->
	<div class="container">
		<div class="blog-flex pagination-content">
			<div class="row">
				<?php while(have_posts()) : the_post() ;?>
				<div class="col-md-6 list-items">
					<div class="row single-item">
						<div class="col-md-6">
							<h6><?php foreach((get_the_category()) as $category) { 
                             echo $category->cat_name . ' '; 
                        } ?></h6>
							<h2><a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
							</h2>
							<p><?php echo wp_trim_words( get_the_content(), 10, '...' ); ?>
							</p>
							<a href="<?php the_permalink(); ?>" class="custom-link" target="_self"
								aria-label="Read full post">Read full post<span class="arrow"></span></a>
						</div>
						<div class="col-md-6">
						<?php $image_id = get_post_thumbnail_id(get_the_ID());
                                                            $alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);?>
                                                            <img  src="<?php echo the_post_thumbnail_url() ?>" alt="<?php echo $alt_text ;?>" />
						</div>
					</div>
				</div>
				<?php endwhile; wp_reset_query(); ?>
			</div>
			<div id="pagination-container"></div>
		</div>
	</div><!-- END OF SECTION -->
	<div class="team-section resource-subscribe">
		<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
			aria-labelledby="staticBackdropLabel" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="popup-info">
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
							<?php echo do_shortcode( '[contact-form-7 id="5" title="Resource Page Subscribe Form"]' ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
get_footer();