<?php
/* Template Name: Connector Page 
*/
get_header();
$get_page_ID = get_the_ID(); 
$connector_banner_bg_image=get_field('connector_banner_bg_image',$get_page_ID);
?>
<div class="mtop-100">
    <section class="connector-banner" style="background-image:url('<?php echo $connector_banner_bg_image['url'];?>')">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="connector-banner-info">
                        <?php if (!empty(get_field('connector_banner_sub_heading',$get_page_ID))) { ?>
                        <span><?php echo get_field('connector_banner_sub_heading',$get_page_ID);?></span>
                        <?php } ?>
                        <?php if (!empty(get_field('connector_banner_heading',$get_page_ID))) { ?>
                        <h1><?php echo get_field('connector_banner_heading',$get_page_ID);?></h1>
                        <?php } ?>
                        <?php if (!empty(get_field('connector_banner_description',$get_page_ID))) { ?>
                        <p><?php echo get_field('connector_banner_description',$get_page_ID);?></p>
                        <?php } 
                 $connector_banner_button = get_field('connector_banner_button'); ?>
                        <?php  if( $connector_banner_button ){
                     $connector_banner_url = $connector_banner_button['url'];
                     $connector_banner_title = $connector_banner_button['title'];
                     $connector_banner_target = $connector_banner_button['target'] ? $connector_banner_button['target'] : '_self';
                     ?>
                        <a href="<?php echo esc_url( $connector_banner_url ); ?>" class="custom-button"
                            target="<?php echo esc_attr( $connector_banner_target ); ?>"
                            aria-label="<?php echo esc_attr($connector_banner_title) ; ?>"><?php echo esc_html( $connector_banner_title ); ?><span
                                class="arrow"></span></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="container">
        <div class="row">

            <!-- The navbar -->
            <div class="col-md-3 position-relative">
                <div id="sticky-sidebar">
                    <?php if( have_rows('connector_sidebar_info') ){ ?>
                    <div class="navigation-list" id="active-section">
                        <?php
                        $row_count = 1;
                        while( have_rows('connector_sidebar_info') ): the_row(); 
						$connector_sidebar_list = get_sub_field('connector_sidebar_list',$get_page_ID);  ?>
                        <?php if( !empty( $connector_sidebar_list ) ) { ?>
                        <a class="navigation__link"
                            href="#connector-link<?php echo $row_count;?> "><?php echo $connector_sidebar_list; ?></a>
                        <?php } 
                         $row_count++; endwhile; ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <!-- The sections -->
            <div class="col-md-9">
                <!-- Section 1 -->

                <div class="height200"></div>
                <div class="page-section-connector" id="connector-link1">
                    <?php if( have_rows('connector_overview') ) { ?>
                    <div class="overview-info">
                        <?php while( have_rows('connector_overview') ): the_row();  
                        $connector_overview_title = get_sub_field('connector_overview_title',$get_page_ID);
						$connector_overview_description = get_sub_field('connector_overview_description',$get_page_ID);
                        $connector_overview_image = get_sub_field('connector_overview_image',$get_page_ID);
                            ?>
                        <div class="overview-info-blk">
                            <div class="overview-box">
                                <?php if( !empty( $connector_overview_image ) ): ?>
                                <div class="imgblk"> <img src="<?php echo esc_url($connector_overview_image['url']); ?>"
                                        alt="<?php echo esc_attr($connector_overview_image['alt']); ?>"></div>
                                <?php endif; ?>
                                <?php if( !empty( $connector_overview_title ) ) { ?>
                                <h4><?php echo $connector_overview_title; ?></h4>
                                <?php } ?>
                                <?php if( !empty( $connector_overview_description ) ) { ?>
                                <div class="overview-middle">
                                    <div class="text"><?php echo $connector_overview_description; ?></div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <?php } ?>
                </div>
                <div class="height200"></div>
                <div class="page-section-connector" id="connector-link2">
                    <div class="whydigg-connector">
                        <?php if (!empty(get_field('connector_why_digg_heading',$get_page_ID))) { ?>
                        <h2><?php echo get_field('connector_why_digg_heading',$get_page_ID);?></h2>
                        <?php } ?>
                    </div>
                    <div class="connector_why_digg_list">
                        <?php if( have_rows('connector_why_digg_list') ): ?>
                        <ul class="connector_digg_list">
                            <?php while( have_rows('connector_why_digg_list') ): the_row(); 
                             $why_digg_list_title = get_sub_field('why_digg_list_title',$get_page_ID); ?>
                            <?php if( !empty( $why_digg_list_title ) ) { ?>
                            <li><?php echo $why_digg_list_title; ?></li>
                            <?php } ?>
                            <?php endwhile; ?>
                        </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="height200"></div>
                <div class="page-section-connector" id="connector-link3">
                    <?php if( have_rows('connector_list') ): ?>
                    <div class="connector-logo-block">
                        <?php while( have_rows('connector_list') ): the_row(); 
                        $connector_list_description = get_sub_field('connector_list_description',$get_page_ID);
                        ?>
                        <div class="connector-info-blk">
                            <div class="connector-bg-blk border rounded-3">
                                <?php $connector_list_logo = get_sub_field('connector_list_logo');
                            if( !empty( $connector_list_logo ) ): ?>
                                <div class="imgblk-logo" id="<?php echo esc_attr($connector_list_logo['alt']); ?>"> <img src="<?php echo esc_url($connector_list_logo['url']); ?>"
                                        alt="<?php echo esc_attr($connector_list_logo['alt']); ?>"></div>
                                <?php endif; ?>
                                <?php if( !empty( $connector_list_description ) ) { ?>
                                <p><?php echo $connector_list_description; ?></p>
                                <?php } ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part('components/revenue-focused', 'section');?>
    <section class="resources-section">
        <?php get_template_part('components/resources', 'section');?>
    </section>
</div>

 
<?php get_footer(); ?>