<?php $footerOptions = get_fields( 'options' ); ?>
<?php $footerContactData = $footerOptions['contact_info'] ?? null; ?>
<footer>
    <div class="container">
        <div class="footer-logo">
        <?php if (function_exists('the_custom_logo')) {
          the_custom_logo();
        } ?>
        </div>
        <div class="nc-contact-info">
        <?php if (isset($footerContactData) && is_array($footerContactData)) : ?>
            <div class="nc-contact">
            <?php if ( !empty($footerContactData['email_white_icon']['url'])): ?>
                <img src="<?php echo $footerContactData['email_white_icon']['url']; ?>" alt="Email Icon">
            <?php endif; ?>
            <?php if (isset($footerContactData['contact_email']) && !empty($footerContactData['contact_email'])) : ?>
                <a href="mailto:<?php echo $footerContactData['contact_email']; ?>"><?php echo $footerContactData['contact_email']; ?></a>
            <?php endif; ?>
            </div>
            <div class="nc-contact">
            <?php if ( !empty($footerContactData['phone_white_icon']['url'])): ?>
                <img src="<?php echo $footerContactData['phone_white_icon']['url']; ?>" alt="Call Icon">
            <?php endif; ?>
            <?php if (isset($footerContactData['phone_number']) && !empty($footerContactData['phone_number'])) : ?>
                <a href="tel:<?php echo preg_replace('/^0|[^a-zA-Z0-9+]+/', '', $footerContactData['phone_number']); ?>"><?php echo $footerContactData['phone_number']; ?></a>
            <?php endif; ?>
            </div>
            
            <div class="nc-contact">
            <?php if ( !empty($footerContactData['address_white_icon']['url'])): ?>
                <img src="<?php echo $footerContactData['address_white_icon']['url']; ?>" alt="Address Icon">
            <?php endif; ?>
            <?php if (isset($footerContactData['address_info']) && !empty($footerContactData['address_info'])) : ?>
                <span><?php echo $footerContactData['address_info']; ?></span>
            <?php endif; ?>
            </div>
        <?php endif; ?> 
        </div>
    </div>
    <?php if (isset($footerOptions['footer_copyright']) && !empty($footerOptions['footer_copyright'])) : ?>
    <div class="footer-bottom">
        <p>© <?php echo date("Y").', '.$footerOptions['footer_copyright'];?></p>
    </div>
    <?php endif; ?> 
</footer>
<?php wp_footer(); ?>
</body>

</html>