 <!-- Latest News From Our Blog starts -->

 <?php
	$field = $args['field'] ?? [];
	$themeData = $args['theme_data'] ?? [];

	// Choose the data source
    $displayData = isset($field['blog_heading']) && !empty($field['blog_heading']) ? $field : $themeData;
?>

<section class="latest-blogs">
	<div class="container">
		<div class="page-second-heading">
			<h2><?php echo $displayData['blog_heading']; ?></h2>
		</div>
		<div class="latest-blog-content">
			<div class="row">
				<?php
				$wpb_all_query = new WP_Query(array(
					'post_type'      => 'post',
					'post_status'    => 'publish',
					'posts_per_page' => 3,
					'orderby'        => 'publish_time',
					'order'          => 'desc'
				));

				$myCount = $wpb_all_query->found_posts;
				?>
				<?php if ($wpb_all_query->have_posts()) : ?>
				<!-- loop -->
				<?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post();
					$id          = get_the_id();
					$thumbnail   = wp_get_attachment_image_src(get_post_thumbnail_id($id), 'full');
					$thumbnail   = get_the_post_thumbnail();
					$image_id    = get_post_thumbnail_id($id);
					$image_title = get_the_title($image_id);
					$category    = get_the_category($id);
					$excerpt     = get_the_excerpt($id);
					$date        = get_the_date();
					$excerpt = get_the_excerpt($id);

					$excerpt = substr($excerpt, 0, 180); // Only display first 260 characters of excerpt
					$excerptdata = substr($excerpt, 0, strrpos($excerpt, ' '));

					?>

					<div class="col-lg-4 col-md-6 col-12">
					<div class="blog-detail">
						<div class="blog-photo">
						<?php
							if (!empty($thumbnail)) :
							echo $thumbnail;
							?>
							<?php
							?>
						<?php
							else :
							?>

							<img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/01/no-preview.jpg" alt="No Preview">

						<?php
							endif;
							?>

						</div>
						<div class="blog-text">
						<h4><?= esc_html(get_the_title()) ?></h4>
						<p><?php echo ($excerptdata) ?>..</p>
						</div>
						<a href="<?php the_permalink(); ?>" class="orange-btn">
						<span  class="content-button">Learn More >></span>
						</a>
					</div>
					</div>

				<?php
					endwhile;
				endif;
				?>     
			</div>
		</div>
	</div>
</section>
 <!-- Latest News From Our Blog ends -->