<?php

/**
 * Template Name: Home page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
  
<!-- banner starts -->
	<?php get_template_part('/common/banner', 'section', $field); ?>
<!-- banner ends -->

<!-- A One-Stop Shop starts -->
<section class="one-shop">
	<div class="container">
		<div class="one-shop-content">
			<?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
				<h1><?php echo $field['services_heading'] ?></h1>
			<?php endif; ?>
			<?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
				<p><?php echo $field['services_subheading'] ?></p>
			<?php endif; ?>
		</div>
	</div>
	<!-- A One-Stop Shop ends -->
	<!-- fineops starts -->
	<div class="fineops">
		<div class="container">
		<div class="fineops-content">
			<div class="row">
			<?php foreach ($field['services'] as  $services_data) : ?>
			<div class="col-md-4">
				<div class="peopleops-content">
				<?php if (isset($services_data['services_card_heading']) && !empty($services_data['services_card_heading'])) : ?>
				<h3><?php echo $services_data['services_card_heading'] ?></h3>
				<?php endif; ?>
				<?php if (isset($services_data['services_card_desc']) && !empty($services_data['services_card_desc'])) : ?>
				<p><?php echo $services_data['services_card_desc'] ?></p>
				<?php endif; ?>
				</div>
				<?php if (isset($services_data['services_card_link']['url']) && !empty($services_data['services_card_link']['url'])) : ?>
				<a href="<?php echo $services_data['services_card_link']['url'] ?>" target="<?php echo $services_data['services_card_link']['target'] ?>" class="orange-btn">
				<span  class="content-button"  ><?php echo $services_data['services_card_link']['title'] ?> >></span>
				</a>
				<?php endif; ?>
			</div>
			<?php endforeach; ?>
		
			</div>
		</div>
		</div>
	</div>
</section>
  <!-- fineops ends -->

<!-- who we serve starts -->
<?php get_template_part('/common/who-we-serve', 'section', $themeData); ?>
<!-- who we serve ends -->

<!-- 5000 clients starts -->
<?php get_template_part('/common/client-logos', 'section', $themeData); ?>
<!-- 5000 clients ends -->

<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
  
<?php get_template_part('/common/why-us', 'section', [
'field' => $field,
'theme_data' => $themeData,
]); ?>
 
<?php get_template_part('/common/have-question', 'section', $themeData); ?>

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
'field' => $field,
'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->


<?php get_template_part('/common/form', 'section', [
'field' => $field,
'theme_data' => $themeData,
]); ?>

<?php get_footer(); ?>