<!DOCTYPE html>
<html>
<head>
<meta content="width=device-width, initial-scale=1" name="viewport" />
  <?php wp_head(); ?>
  
</head>

<body <?php body_class(); ?>>
  <?php
  $themeData = get_fields('options');
  ?>
  <header>
    <nav class="navbar navbar-expand-lg">
      <div class="container">
        <?php
        if (function_exists('the_custom_logo')) {
          the_custom_logo();
        }
        ?>
        <div class="mobile-button">
        <?php if (isset($themeData['schedule_a_call_button']['url']) && !empty($themeData['schedule_a_call_button']['url'])) : ?>
            <div class="d-flex">
              <a href="<?php echo $themeData['schedule_a_call_button']['url'] ?>" target="<?php echo $themeData['schedule_a_call_button']['target'] ?>" class="orange-btn">
                <span class="skew-button"><?php echo $themeData['schedule_a_call_button']['title'] ?></span>
              </a>

            </div>
          <?php endif ?>
        </div>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon">
            <i class="fa fa-bars" id="toggle_tst" aria-hidden="true" style="color: #FC8E26"></i>
          </span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <?php
          //display primary menu
          if (has_nav_menu('primary-menu')) {
            wp_nav_menu(array(
              'theme_location' => 'primary-menu',
              'menu_class' => 'navbar-nav',
              'container' => false,
            ));
          }

          ?>
          <?php if (isset($themeData['schedule_a_call_button']['url']) && !empty($themeData['schedule_a_call_button']['url'])) : ?>
            <div class="d-flex desktop-button">
              <a href="<?php echo $themeData['schedule_a_call_button']['url'] ?>" target="<?php echo $themeData['schedule_a_call_button']['target'] ?>" class="orange-btn">
                <span class="skew-button"><?php echo $themeData['schedule_a_call_button']['title'] ?></span>
              </a>

            </div>
          <?php endif ?>
        </div>
      </div>
    </nav>
  </header>