<?php

/**
 * Template Name: About Us
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                ...
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Understood</button>
            </div>
        </div>
    </div>
</div>

<!-- Banner section start -->
<?php if(isset($field['about_us_bg_image']) && (!empty($field['about_us_bg_image']))) :?>
    <section class="banner-finops" style="background-image: url(<?php echo $field['about_us_bg_image']['url']; ?>);">
        <div class="container">
            <div class="row">
                <div class="banner-heading">
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<!-- Banner section end -->

<!-- A One-Stop start -->
<section class="one-shop">
    <div class="container">
        <div class="one-shop-content cfo-step">
            <?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
                <h2><?php echo $field['services_heading'] ?></h2>
            <?php endif; ?>
            <?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
                <p><?php echo $field['services_subheading'] ?></p>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- A One-Stop ends -->

<!-- Why us section start -->
<section class="cfo-outer-text offwhite-color ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php foreach ($field['why_us_content'] as  $why_us) : ?>
                    <div class="cfo-border-box">
                        <?php if (isset($why_us['why_us_heading']) && !empty($why_us['why_us_heading'])) : ?>
                            <h2 class="cfo-box-heading"><?php echo $why_us['why_us_heading'] ?></h2>
                        <?php endif; ?>
                        <?php if (isset($why_us['why_us_subheading']) && !empty($why_us['why_us_subheading'])) : ?>
                            <p><?php echo $why_us['why_us_subheading'] ?></p>
                        <?php endif; ?>   
                    </div>
                <?php endforeach  ?>  
            </div>
        </div>
    </div>
</section>
<!-- Why us section end -->

<!-- Contact us today section start -->
<section class="contact-today">
    <div class="container">
        <div class="row">
            <?php if(isset($field['contact_us_today']) && (!empty($field['contact_us_today']))) : ?>
                <div class="contact-today-text">
                    <h2><?php echo $field['contact_us_today'];?></h2>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- Contact us section end -->

<!-- Family business section start -->
<section class="family-of-business offwhite-color">
    <div class="container">
        <div class="row">
            <?php if(isset( $field['family_business_heading']) && (!empty( $field['family_business_heading']))) :?>
                <div class="page-second-heading">
                    <h2><?php echo $field['family_business_heading']?></span></h2>
                </div>
            <?php endif; ?>

            <div class="family-member-outer">
                <?php foreach($field['family_member_details'] as $family_detail) : 
                    if(isset($family_detail) && (!empty($family_detail))):    
                ?>
                    <div class="family-member-items">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                            <div class="family-member-image">
                                <img src="<?php echo $family_detail['member_image']['url'];?>">
                            </div>
                            <h3><?php echo $family_detail['member_name'];?></h3>
                            <p><?php echo $family_detail['member_designation']?></p>
                        </a> 
                    </div>
                <?php endif; endforeach; ?>
            </div>
        </div>
    </div>
</section>
<!-- Family business section end -->

<!-- joining our team starts -->
<?php get_template_part('/common/joining-our-team', 'section', $themeData); ?>
<!-- joining our team ends -->

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->

<!-- contact form start -->
<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- contact form end -->

<?php get_footer() ?>