<?php

/**
 * Template Name: cfo services
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');

?>
<!-- banner starts -->
<?php get_template_part('/common/banner', 'section', $field); ?>
<!-- banner ends -->

<section class="cfo-outer-text">
    <div class="container">
        <div class="row">
            <div class="col-12">
            <?php foreach ($field['fundrising'] as  $fundrisingData) : ?>
                <div class="cfo-border-box">
                <?php if (isset($fundrisingData['fundrising_heading']) && !empty($fundrisingData['fundrising_heading'])) : ?>
                    <h2 class="cfo-box-heading"><?php echo $fundrisingData['fundrising_heading'] ?></h2>
                    <?php endif; ?>
                    <?php if (isset($fundrisingData['fundrising_subheading']) && !empty($fundrisingData['fundrising_subheading'])) : ?>
                    <p><?php echo $fundrisingData['fundrising_subheading'] ?></p>
                    <?php endif; ?>  
                    <?php if (isset($fundrisingData['fundrising_button']['url']) && !empty($fundrisingData['fundrising_button']['url'])) : ?>
                    <div class="learn-more">
                        <a href="<?php echo $fundrisingData['fundrising_button']['url'] ?>" target="<?php echo $fundrisingData['fundrising_button']['target'] ?>" class="orange-btn">
                            <span class="content-button"><?php echo $fundrisingData['fundrising_button']['title'] ?>  &gt;&gt;</span>
                        </a>
                    </div>
                    <?php endif; ?>  
                </div>
                <?php endforeach  ?>  
          
            </div>
        </div>
    </div>
</section>

<!-- client-logos section start -->
<?php get_template_part('/common/client-logos', 'section', $themeData); ?>
<!-- client-logos section end -->

<!-- Who we serve start -->
  <?php if (isset($field['who_we_serve_heading']) && !empty($field['who_we_serve_heading'])) : ?>
<section class="who-we-serve">
    <div class="container">
        <div class="page-second-heading">
          
                <h2><?php echo $field['who_we_serve_heading']; ?></h2>
      

            <?php echo $field['who_we_serve_desc']; ?>

            <?php if (!empty($field['who_we_serve_link']['url'])) : ?>
                <a href="<?php echo $field['who_we_serve_link']['url']; ?>" target="<?php echo $field['who_we_serve_link']['target']; ?>" class="orange-btn">
                    <span class="content-button"> <?php echo $field['who_we_serve_link']['title']; ?> >></span>
                </a>
            <?php endif; ?>
        </div>
    </div>
</section>
      <?php endif; ?>
<!-- Who we serve end -->

<?php if(isset($field['every_minute_schedule_call']) && (!empty($field['every_minute_schedule_call']))):?>
    <section class="schedule-call">
        <div class="container">
            <div class="page-second-heading">
                <p><?php echo $field['every_minute_schedule_call'];?></p>
            </div>
        </div>
    <section>
<?php endif; ?>

<!-- Testimonials section start-->
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<!-- Testimonials section end-->

<!-- why us section start -->
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- why us section end -->

<!-- Have question section start -->
<?php get_template_part('/common/have-question', 'section', $themeData); ?>
<!-- Have question section end -->

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->
<!-- Contact us section start -->
<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Contact us section end -->

<?php get_footer() ?>