<?php

/**
 * Template Name: Contact Us
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
		<div class="modal-header">
			<h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
			<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
		</div>
		<div class="modal-body">
			...
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
			<button type="button" class="btn btn-primary">Understood</button>
		</div>
		</div>
	</div>
</div>

<!-- Banner section start -->
<?php if(isset($field['contact_us_bg_image']) && (!empty($field['contact_us_bg_image']))) :?>
	<section class="banner-finops" style="background-image: url(<?php echo $field['contact_us_bg_image']['url']; ?>);">
		<div class="container">
			<div class="row">
		</div>
	</section>
<?php endif; ?>
<!-- Banner section end -->

<!-- A One-Stop start -->
	<section class="one-shop">
		<div class="container">
			<div class="one-shop-content cfo-step">
				<?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
					<h2><?php echo $field['services_heading'] ?></h2>
				<?php endif; ?>
				<?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
					<p><?php echo $field['services_subheading'] ?></p>
				<?php endif; ?>
			</div>
		</div>
	</section>
<!-- A One-Stop end -->

<!-- Have question start -->
<?php get_template_part('/common/have-question', 'section', $themeData); ?>
<!-- Have question end -->

<!-- Contact us section start -->
<section class="schedule-call bg-white contact-us">
    <div class="container">
      <div class="page-second-heading">
		<?php if(isset($field['contact_us_title']) && (!empty($field['contact_us_title']))):?>
        	<h2><?php echo $field['contact_us_title'];?></h2>
		<?php endif; ?>
		<?php if(isset($field['contact_us_sub_title']) && (!empty($field['contact_us_sub_title']))):?>
        	<p><?php echo $field['contact_us_sub_title'];?></p>
		<?php endif; ?>
      </div>
    </div>
</section>
<!-- Contact us section end -->

<section class="our-locations offwhite-color">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="location-heading-main">
                    <h2>Our Locations</h2>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- joining our team starts -->
<?php get_template_part('/common/joining-our-team', 'section', $themeData); ?>
<!-- joining our team ends -->

<!-- contact form start -->
<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- contact form end -->

<?php get_footer() ?>