<?php

/**
 * Template Name: Ecommerce
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<?php get_template_part('/common/banner', 'section', $field); ?>
<section class="ecommerce">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php foreach ($field['ecommerce'] as $ecommerce) : ?>
                    <?php if (isset($ecommerce['ecommerce_heading']) && !empty($ecommerce['ecommerce_heading'])) : ?>
                        <div class="ecommerce-top-heading">
                            <div class="section-heading">
                                <h2 class="cfo-box-heading"><?php echo $ecommerce['ecommerce_heading'] ?></h2>
                                <?php echo $ecommerce['ecommerce_subheading'] ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>
<section class="cfo-outer-text ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php foreach ($field['fundrising'] as  $fund) : ?>
                    <div class="cfo-border-box">
                        <?php if (isset($fund['fundrising_heading']) && !empty($fund['fundrising_heading'])) : ?>
                            <h2 class="cfo-box-heading"><?php echo $fund['fundrising_heading'] ?></h2>
                        <?php endif; ?>
                        <?php if (isset($fund['fundrising_subheading']) && !empty($fund['fundrising_subheading'])) : ?>
                            <p><?php echo $fund['fundrising_subheading'] ?></p>
                        <?php endif; ?>
                        <?php if (isset($fund['fundrising_button']['url']) && !empty($fund['fundrising_button']['url'])) : ?>
                            <div class="learn-more">
                                <a href="<?php echo $fund['fundrising_button']['url'] ?>" target="<?php echo $fund['fundrising_button']['target'] ?>" class="orange-btn">
                                    <span class="content-button"><?php echo $fund['fundrising_button']['title'] ?> &gt;&gt;</span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach  ?>

            </div>
        </div>
    </div>
</section>
<?php get_template_part('/common/client-logos', 'section', $themeData); ?>
<?php get_template_part('/common/who-we-serve', 'section', $themeData); ?>
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<?php if (isset($field['whether_content']) && !empty($field['whether_content'])) : ?>
<section class="offwhite-color">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="saparate-heading-section">
                    <h2><?php echo $field['whether_content'] ?></h2>
                </div>
            </div>
        </div>
    </div>

</section>
<?php endif; ?>

<?php if (isset($field['why_escalon']) && (!empty($field['why_escalon']))) :?>
    <section class="cfo-outer-text">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <?php foreach ($field['why_escalon'] as  $why_us) : ?>
                        <div class="cfo-border-box">
                            <?php if (isset($why_us['why_escalon_heading']) && !empty($why_us['why_escalon_heading'])) : ?>
                                <h2 class="cfo-box-heading"><?php echo $why_us['why_escalon_heading'] ?></h2>
                            <?php endif; ?>
                            <?php if (isset($why_us['why_escalon_description']) && !empty($why_us['why_escalon_description'])) : ?>
                                <p><?php echo $why_us['why_escalon_description'] ?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach  ?>
                </div>
            </div>
        </div>
    </section>
<?php endif;?>

<section class="ecommerce offwhite-color">
    <div class="container">
        <div class="row">
        <?php if (isset($field['circle_main_heading']) && !empty($field['circle_main_heading'])) : ?>
            <div class="section-head">
                <h2 class="section-heading"><?php echo $field['circle_main_heading'] ?></h2>
            </div>
            <?php endif; ?>
            <div class="circle-outer" style="background-image: url(<?php echo $field['circle_background_image']['url'] ?>);">
            <?php foreach ($field['circle_content'] as  $circle_content) : ?>
                <div class="our-people process-one">
                <?php if (isset($circle_content['circle_heading']) && !empty($circle_content['circle_heading'])) : ?>
                    <h5><?php echo $circle_content['circle_heading'] ?></h5>
                <?php endif; ?>
                    <?php echo $circle_content['circle_description'] ?>
                </div>
                <?php endforeach; ?>
            </div>
            <div class="lead-by-people">
            <?php if (isset($field['circle_below_heading']) && !empty($field['circle_below_heading'])) : ?>
                <h2><?php echo $field['circle_below_heading'] ?></h2>
                <?php endif; ?> 
                <?php echo $field['circle_below_subheading'] ?>
            </div>
        </div>
    </div>
</section>
<section class="padding-top-bottom-180 consider-your-office" style="background-image: url(<?php echo $field['background_image']['url'] ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="consider-heading">
                <?php if (isset($field['heading']) && !empty($field['heading'])) : ?>
                    <h2><?php echo $field['heading']?></h2>
                    <?php endif; ?>
                    <?php if (isset($field['description']) && !empty($field['description'])) : ?> 
                    <div class="consider-points">
                    <?php echo $field['description']?>
                    </div>
                    <?php endif; ?>
                    <?php if (isset($field['just_done_heading']) && !empty($field['just_done_heading'])) : ?> 
                    <h2> <?php echo $field['just_done_heading']?></h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php get_template_part('/common/have-question', 'section', $themeData); ?>

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
'field' => $field,
'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->

<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<?php get_footer(); ?>