<?php

/**
 * Template Name: Finops
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

  <!-- banner starts -->
  <?php get_template_part('/common/banner', 'section', $field); ?>
  <!-- banner ends -->

  <section class="cfo-outer-text">
    <div class="container">
        <div class="row">
            <div class="col-12">
            <?php foreach ($field['why_us_content'] as  $why_us) : ?>
                <div class="cfo-border-box">
                <?php if (isset($why_us['why_us_heading']) && !empty($why_us['why_us_heading'])) : ?>
                    <h2 class="cfo-box-heading"><?php echo $why_us['why_us_heading'] ?></h2>
                    <?php endif; ?>
                    <?php if (isset($why_us['why_us_subheading']) && !empty($why_us['why_us_subheading'])) : ?>
                    <p><?php echo $why_us['why_us_subheading'] ?></p>
                    <?php endif; ?>  
                    <?php if (isset($why_us['why_us_button']['url']) && !empty($why_us['why_us_button']['url'])) : ?>
                    <div class="learn-more">
                        <a href="<?php echo $why_us['why_us_button']['url'] ?>" target="<?php echo $why_us['why_us_button']['target'] ?>" class="orange-btn">
                            <span class="content-button"><?php echo $why_us['why_us_button']['title'] ?>  &gt;&gt;</span>
                        </a>
                    </div>
                    <?php endif; ?>  
                </div>
                <?php endforeach  ?>  
            </div>
        </div>
    </div>
</section>

<?php get_template_part('/common/client-logos', 'section', $themeData); ?>

<!-- Who we serve start -->
<?php get_template_part('/common/who-we-serve', 'section', $themeData); ?>
<!-- Who we serve end -->

<!-- Testimonials section start-->
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<!-- Testimonials section end-->
  
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
 
 <?php get_template_part('/common/have-question', 'section', $themeData); ?>
 <?php get_template_part('/common/latest-blog', 'section', $themeData); ?>

 <?php get_template_part('/common/form', 'section', $themeData); ?>
<?php get_footer(); ?>