
<?php

/**
 * Template Name: Resources
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ...
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Understood</button>
      </div>
    </div>
  </div>
</div>

<!-- Banner section start -->
<?php if(isset($field['resource_bg_image']) && (!empty($field['resource_bg_image']))) :?>
	<section class="banner-finops" style="background-image: url(<?php echo $field['resource_bg_image']['url']; ?>);">
     <div class="container">
        <div class="row">
        </div>
     </div>
	</section>
<?php endif; ?>
<!-- Banner section -->

<!-- Resource detail section start -->
<section class="one-shop">
    <div class="container">
        <div class="one-shop-content">
			<?php if(isset($field['resources_title']) && (!empty($field['resources_title']))):?>
            	<h1><?php echo $field['resources_title'];?></h1>
			<?php endif; ?>
			<?php if(isset($field['resources_description']) && (!empty($field['resources_description']))):?>
            	<p><?php echo $field['resources_description'];?></p>
			<?php endif; ?>
        </div>
    </div>
</section>
<!-- Resource detail section end -->

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
  'field' => $field,
  'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->

<!-- Case-studies section start -->
<?php get_template_part('/common/latest-case-studies', 'section', $themeData); ?>
<!-- Case-studies section end -->

<?php get_template_part('/common/have-question', 'section', $themeData); ?>
<?php get_template_part('/common/form', 'section', $themeData); ?>

<?php get_footer() ?>