<?php

/**
 * Template Name: Service Internal
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

<!-- banner starts -->
<?php get_template_part('/common/banner', 'section', $field); ?>
<!-- banner ends -->

<!-- Why us section start -->
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Why us section end -->

<!-- Testimonial section start -->
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<!-- Testimonial section end -->

<!-- Call schedule section start -->
<?php if(isset($field['every_minute_schedule_call']) && (!empty($field['every_minute_schedule_call']))):?>
    <section class="schedule-call">
        <div class="container">
            <div class="page-second-heading">
                <p><?php echo $field['every_minute_schedule_call'];?></p>
            </div>
        </div>
    <section>
<?php endif; ?>
<!-- Call schedule section end -->

<section class="one-shop">
    <div class="container">
        <div class="one-shop-content">
            <?php if (isset($field['services_heading']) && !empty($field['services_heading'])) : ?>
                <h2><?php echo $field['services_heading'] ?></h2>
            <?php endif; ?>
        </div>
    </div>

  <!-- fineops starts -->
    <div class="fineops">
        <div class="container">
            <div class="fineops-content">
                <div class="row">
                    <?php foreach ($field['services'] as  $services_data) : ?>
                        <div class="col-md-4">
                            <div class="peopleops-content">
                                <?php if (isset($services_data['services_card_heading']) && !empty($services_data['services_card_heading'])) : ?>
                                    <h3><?php echo $services_data['services_card_heading'] ?></h3>
                                <?php endif; ?>
                                <?php if (isset($services_data['services_card_desc']) && !empty($services_data['services_card_desc'])) : ?>
                                    <p><?php echo $services_data['services_card_desc'] ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if (isset($services_data['services_card_link']['url']) && !empty($services_data['services_card_link']['url'])) : ?>
                                <a href="<?php echo $services_data['services_card_link']['url'] ?>" target="<?php echo $services_data['services_card_link']['target'] ?>" class="orange-btn">
                                    <span  class="content-button"  ><?php echo $services_data['services_card_link']['title'] ?> >></span>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
  </div>
</section>

<?php get_template_part('/common/have-question', 'section', $themeData); ?>

<!-- Form section start -->
<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Form section end -->

<?php get_footer() ?>