<?php

/**
 * Template Name: who we serve
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>

<!-- banner starts -->
<?php get_template_part('/common/banner', 'section', $field); ?>
<!-- banner ends -->

<section class="cfo-outer-text">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="who-we-serve-outer">
                    <div class="who-we-serve-heading">
                    <?php if (isset($field['who_we_serve_heading']) && !empty($field['who_we_serve_heading'])) : ?>
                        <h1 class="main-heading-page"><?php echo $field['who_we_serve_heading'] ?></h1>
                        <?php endif; ?>
                        <?php echo $field['who_we_serve_description'] ?>
                        <?php if (isset($field['who_we_serve_button']['url']) && !empty($field['who_we_serve_button']['url'])) : ?>
                        <div class="learn-more">
                            <a href="<?php echo $field['who_we_serve_button']['url'] ?>" target="<?php echo $field['who_we_serve_button']['target'] ?>" class="orange-btn">
                                <span class="content-button"><?php echo $field['who_we_serve_button']['title'] ?>  &gt;&gt;</span>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="our-services-links">
                        <div class="custom-page-links">

                        <?php echo $field['who_we_serve_links'] ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- 5000 clients starts -->
<?php get_template_part('/common/client-logos', 'section', $themeData); ?>
<!-- 5000 clients ends -->

<!-- Who we serve start -->
<?php get_template_part('/common/who-we-serve', 'section', $themeData); ?>
<!-- Who we serve end -->

<!-- Testimonials section start-->
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<!-- Testimonials section end-->

<!-- Why us section start -->
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Why us section end -->

<!-- Have question section start -->
<?php get_template_part('/common/have-question', 'section', $themeData); ?>
<!-- Have question section start -->

<!-- Blog section start -->
<?php get_template_part('/common/latest-blog', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Blog section ends -->

<!-- Schedule a call section start -->
<?php get_template_part('/common/form', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>
<!-- Schedule a call section end -->

<?php get_footer() ?>