<?php

/**
 * Template Name: Work With Us
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ...
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Understood</button>
      </div>
    </div>
  </div>
</div>

<!-- Banner section start -->
<?php if(isset($field['banner_bg_image']) && (!empty($field['banner_bg_image']))) :?>
    <section class="banner-finops" style="background-image: url(<?php echo $field['banner_bg_image']['url']; ?>);">
        <div class="container">
            <div class="row">
                <div class="banner-heading">
                    <?php if(isset($field['banner_title']) && (!empty($field['banner_title']))) :?>
                        <h1 class="main-h1-heading"><?php echo $field['banner_title'];?></h1>
                    <?php endif; ?>
                    <?php if(isset($field['banner_description']) && (!empty($field['banner_description']))) :?>
                        <p class="sub-heading"><?php echo $field['banner_description'];?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<!-- Banner section end -->

<!-- Why us section start -->
    <section class="cfo-outer-text ">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <?php foreach ($field['why_us_content'] as  $why_us) : ?>
                        <div class="cfo-border-box">
                            <?php if (isset($why_us['why_us_heading']) && !empty($why_us['why_us_heading'])) : ?>
                                <h2 class="cfo-box-heading"><?php echo $why_us['why_us_heading'] ?></h2>
                            <?php endif; ?>
                            <?php if (isset($why_us['why_us_subheading']) && !empty($why_us['why_us_subheading'])) : ?>
                                <p><?php echo $why_us['why_us_subheading'] ?></p>
                            <?php endif; ?>   
                        </div>
                    <?php endforeach  ?>  
                </div>
            </div>
        </div>
    </section>
<!-- Why us section end -->

<!-- Testimonial start -->
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<!-- Testimonial end -->

<!-- joining our team starts -->
<?php get_template_part('/common/joining-our-team', 'section', $themeData); ?>
<!-- joining our team ends -->

<section class="our-locations offwhite-color">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="location-heading-main">
                    <h2>Our Locations</h2>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why us section start -->
<?php get_template_part('/common/why-us', 'section', $themeData); ?>
<!-- Why us section end -->

<section class="our-locations offwhite-color">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="location-heading-main">
                    <h2>Our Benefits</h2>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="location-heading">
                    <h3>Lorem Ipsum</h3>
                    <ul>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                        <li>Lorem Ipsum Lorem Ipsum</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer() ?>