$(document).ready(function () {
  $('.ever-graph-cheese-wrapper .graph-dot').css('visibility', 'hidden');
  const mediaQueryIpad = window.matchMedia("(max-width: 1200px)");
  if (mediaQueryIpad.matches) {
    $(".tooltip-wrapper").click(function () {
      $(".active").not(this).removeClass("active");
      $(this).toggleClass("active");
    });
  }

  $("#ever-fill-btn").attr("disabled", "disabled"); //Disable Calculate Button for Mass Balance Calc on load
  $("#cheese-submit-btn").attr("disabled", "disabled"); //Disable Calculate Button for Cheese Yield Calc on load
  $("#ever-fill-btn").click(function () {
    $("#ever-cal-result-wrapper").addClass("ever-cal-result-show");
  });
  $("#cheese-submit-btn").click(function () {
    $("#cheese-result-wrapper").addClass("ever-cal-result-show");
  });
});
// 	$('.ever-fill-btn').click(function(event){
// 		showModal();
// 		event.stopPropagation();
// 		$('body').addClass('overflow-hidden');
// 	});
// 	$('#modalClose').click(function(){
// 		hideModal();
// 		$('body').removeClass('overflow-hidden');
// 	});

// 	// Do nothing when clicking on the modal content
// 	$('.modal-content').click(function(event){
//        event.stopPropagation();
//     });

// function showModal(){
// 	$('.ever-roi-modal').fadeIn('slow');
// 		(function fun(){
// 			$('.modal-content').css({'transform':'translateY(-50px)'});
// 		})();
// }

// function hideModal(){
// 	$('.ever-roi-modal').fadeOut('fast');
// 		(function fun2(){
// 			$('.modal-content').css({ 'transform':'translateY(0px)' });
// 		})();
// }

// $(document).on("click", function () {
//   //click outside of ".nav__dropdown" class itself and menu will be hidden
//   hideModal();
// });
/** Code to disallow alphabet values in the textbox. */
$("input.comma-inputs").keypress(function (event) {
  return event.keyCode >= 48 && event.keyCode <= 57 || event.keyCode == 46;
});
// $("input.comma-inputs").keypress(function (evt) {
//   var self = $(this);
//   self.val(self.val().replace(/[^0-9.]/g, ""));
//   if (
//     (evt.which != 46 || self.val().indexOf(".") != -1) &&
//     (evt.which < 48 || evt.which > 57)
//   ) {
//     evt.preventDefault();
//   }
// });
/** Fx to disallow negative value in input field */
$(".disallow-negative").on("keypress", function (e) {
  if (e.keyCode == 45) {
    //it does't allow user to enter minus(-) symbol
    event.preventDefault();
  }
});
/** Fx to disallow decimal value in input field */
$(".disallow-decimal-negative").on("keypress", function (e) {
  if (e.keyCode == 45 || e.keyCode == 46) {
    //it does't allow user to enter minus(-) & decimal(.) symbol
    event.preventDefault();
  }
});
/** Code to add commas to input number with decimals while typing */
$("input.comma-inputs").keyup(function (event) {
  // skip for arrow keys
  if (event.which >= 37 && event.which <= 40 ) {
    event.preventDefault();
  }
  $(this).val(function (index, value) {
    value = value.replace(/,/g, "");
    return numberWithCommas(value);
  });
});
//  Fx to limit the ProductionDays input field max n min values
function CheckTextInputLimit(Element) {
  var val = Element.val();
  var max = parseInt(Element.attr("max"));
  var min = parseInt(Element.attr("min"));
  if (!isNaN(val)) {
    if (val < min) {
      Element.val(min);
      return false;
    }
    else if (val > max) {
      Element.val(max);
      return false;
    }
  }
}
jQuery(".prod-days").change(function () {
  var ItemInputFirst = jQuery(this);
  CheckTextInputLimit(ItemInputFirst);
});
/** Fx to disallow 0 to input & limit last value to 1 */
$('.disallow-zero').on('input', function (e) {
  // var self = $(this);
  // var val = self.val();
  // var min = parseInt(self.attr("data-min"));
  // if (!isNaN(val)) {
  //   if (val < min) {
  //     self.val(min);
  //     return false;
  //   }
  // }
  if (/^0/.test(this.value)) {
    this.value = this.value.replace(/^0/, "")
  }
});
/** Fx to limit input field to accept only 2 decimal value  */
$('.limit-two-deci').on('keyup', function (e) {
  var amt = $(this);
  if (amt.val().indexOf(".") > -1 && (amt.val().split('.')[1].length > 2)) {
    amt.val(amt.val().substring(0, amt.val().length - 1));
  }
});
/** Fx to validate that 'Average Cost for a Finished Good' is less than 'Average Sale Price for a Finished Goods' in Cheese Yield Calc */
$('#AvgCostFinishedGoods').on('input', function() {
  $('.error-message').remove();
    var $advance = $(this);
    var $fullPayment = $('#AvgFinishedGoodsPurchasePrice'); 
    if ($fullPayment.val() !== null && $fullPayment.val() !== '') {
    var advanceValue = parseFloat($advance.val().replace(/,/g, ""));
    var fullValue = parseFloat($fullPayment.val().replace(/,/g, ""));
      if (advanceValue >= fullValue) {
        $advance.val('');
        $('#AvgCostFinishedGoods').after('<p class="error-message" id="error-message">The input value has to be less than the &lsquo;Average Sale Price for a Finished Goods&rsquo; value.</p>');
        //alert('The input value has to be less than the original value of ' + fullValue);
        return false;
      }
    }
  });
  $('#AvgFinishedGoodsPurchasePrice').on('input', function() {
    $('.error-message').remove();
      var $finishedPrice = $(this);
      var $costPrice = $('#AvgCostFinishedGoods'); 
      if ($costPrice.val() !== null && $costPrice.val() !== '') {
        var finishedPrice = parseFloat($finishedPrice.val().replace(/,/g, ""));
        var costPriceValue = parseFloat($costPrice.val().replace(/,/g, ""));
        if (finishedPrice <= costPriceValue ) {
          //$finishedPrice.val('');
          $('#AvgFinishedGoodsPurchasePrice').after('<p class="error-message" id="error-message">The input value has to be more than the &lsquo;Average Cost for a Finished Good&rsquo; value.</p>');
          //alert('The input value has to be less than the original value of ' + costPriceValue);
          return false;
        }
      }
    });
/** Fx to Enable the Calucalte button only if all fields are filled for Mass Balance Calc  */
//$('.ever-roi-input').change( function(){
$(".roi-mass-input").on("input", function () {
  $("#ever-fill-btn").attr("disabled", "disabled");
  var ProductionDays = $('input[name="ProductionDays"]').val();
  var AvgLbsMilkIntoPlant = $('input[name="AvgLbsMilkIntoPlant"]').val();
  var AvgSalePriceOfFinishedGoods = $(
    'input[name="AvgSalePriceOfFinishedGoods"]'
  ).val();
  var AvgMonthlyWasteWaterBill = $(
    'input[name="AvgMonthlyWasteWaterBill"]'
  ).val();
  var CurrentShrink = $('input[name="CurrentShrink"]').val();
  //setTimeout( function() {
  if (ProductionDays != "" && AvgLbsMilkIntoPlant != "" && AvgSalePriceOfFinishedGoods != "" && AvgMonthlyWasteWaterBill != "" &&
    CurrentShrink != "" && $('#error-message').css('display') == 'none') {
    $("#ever-fill-btn").removeAttr("disabled");
  }
  //}, 400 ); // Waits 1/2 second.
});
// Fx to comma separate for the final ticket values for number input field
function numberWithCommas(x) {
  if (x != null) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
  }
}
/** Fx to convert finalEstimations Price Result to International Currency system */
function convertToInternationalCurrencySystem (labelValue) {

    // Nine Zeroes for Billions
    return Math.abs(Number(labelValue)) >= 1.0e+9

    ? (Math.abs(Number(labelValue)) / 1.0e+9).toFixed(2) + "B"
    // Six Zeroes for Millions 
    : Math.abs(Number(labelValue)) >= 1.0e+6

    ? (Math.abs(Number(labelValue)) / 1.0e+6).toFixed(2) + "M"
    // Three Zeroes for Thousands
    : Math.abs(Number(labelValue)) >= 1.0e+3

    ? (Math.abs(Number(labelValue)) / 1.0e+3).toFixed(2) + "K"

    : Math.abs(Number(labelValue));

}
/** Fx to roundup no. to nearest  */
function roundup(v) {
  return (v >= 0 || -1) * Math.pow(10, 1 + Math.floor(Math.log10(Math.abs(v))));
}
/** Fx to Calucalte the results for Mass Balance Calc */
$("#ever-fill-btn").click(function (event) {
  var ProductionDays = $('input[name="ProductionDays"]').val();
  var AvgLbsMilkIntoPlant = $('input[name="AvgLbsMilkIntoPlant"]').val().replace(/,/g, ""); // Remove comma from value if any
  var AvgSalePriceOfFinishedGoods = $('input[name="AvgSalePriceOfFinishedGoods"]').val().replace(/,/g, ""); // Remove comma from value if any
  var AvgMonthlyWasteWaterBill = $('input[name="AvgMonthlyWasteWaterBill"]').val().replace(/,/g, ""); // Remove comma from value if any
  var CurrentShrink = $('input[name="CurrentShrink"]').val();
  var ShrinkResult = parseFloat(CurrentShrink) / 100;

  var LowYieldRange = $('input[name="LowYieldRange"]').val();
  LowYieldRange = parseFloat(LowYieldRange) / 100;
  var HighYieldRange = $('input[name="HighYieldRange"]').val();
  HighYieldRange = parseFloat(HighYieldRange) / 100;
  var LowWasteWaterRange = $('input[name="LowWasteWaterRange"]').val();
  LowWasteWaterRange = parseFloat(LowWasteWaterRange) / 100;
  var HighWasteWaterRange = $('input[name="HighWasteWaterRange"]').val();
  HighWasteWaterRange = parseFloat(HighWasteWaterRange) / 100;
  var SolidsRetentionLow = $('input[name="SolidsRetentionLow"]').val();
  SolidsRetentionLow = parseFloat(SolidsRetentionLow) / 100;
  var SolidsRetentionHigh = $('input[name="SolidsRetentionHigh"]').val();
  SolidsRetentionHigh = parseFloat(SolidsRetentionHigh) / 100;
  var AvgCWTPriceForMilk = $('input[name="AvgCWTPriceForMilk"]').val();

    var lowEstimations =
      ProductionDays *
        AvgLbsMilkIntoPlant *
        AvgSalePriceOfFinishedGoods *
        LowYieldRange +
      ((AvgMonthlyWasteWaterBill * 12) / 365) *
        ProductionDays *
        LowWasteWaterRange +
      AvgLbsMilkIntoPlant *
        ProductionDays *
        AvgCWTPriceForMilk *
        ShrinkResult *
        SolidsRetentionLow;

    var lowFinalEstimations = parseFloat(lowEstimations).toFixed(2);
    if (lowFinalEstimations != null && !isNaN(lowFinalEstimations)) {
      var lowParts = lowFinalEstimations.toString().split(".");
      lowParts[0] = lowParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      var lowCommaEstimations = lowParts.join(".");
    }
	console.log(convertToInternationalCurrencySystem(lowFinalEstimations) + ' MB Low');
    $("#ever-cal-result-wrapper .ever-graph-low #lowRoi").text("$" + convertToInternationalCurrencySystem(lowFinalEstimations));
    // console.log(Estimations);
    // console.log(commaEstimations);
    var highEstimations =
      ProductionDays *
        AvgLbsMilkIntoPlant *
        AvgSalePriceOfFinishedGoods *
        HighYieldRange +
      ((AvgMonthlyWasteWaterBill * 12) / 365) *
        ProductionDays *
        HighWasteWaterRange +
      AvgLbsMilkIntoPlant *
        ProductionDays *
        AvgCWTPriceForMilk *
        ShrinkResult *
        SolidsRetentionHigh;

    var highFinalEstimations = parseFloat(highEstimations).toFixed(2);
    if (highFinalEstimations != null && !isNaN(highFinalEstimations)) {
      var highParts = highFinalEstimations.toString().split(".");
      highParts[0] = highParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      var highCommaEstimations = highParts.join(".");
    }
	console.log(convertToInternationalCurrencySystem(highFinalEstimations) + ' MB high');
    $("#ever-cal-result-wrapper .ever-graph-high #highRoi").text("$" + convertToInternationalCurrencySystem(highFinalEstimations));
	var avgEstimation = (lowFinalEstimations*1 + highFinalEstimations*1) /2;
var avgFinalEstimation = parseFloat(avgEstimation).toFixed(2);
console.log(avgFinalEstimation + ' MB avg');
    $("#ever-cal-result-wrapper .ever-graph-avg #roiAvg").text("$" + convertToInternationalCurrencySystem(avgFinalEstimation));
    $('.ever-cal-result-wrapper .ever-graph-avg .graph-dot').addClass('graph-dot-show');
    $('.ever-cal-result-wrapper .ever-graph-high .graph-dot').addClass('graph-dot-show');
    $('.ever-cal-result-wrapper .ever-graph-low .graph-dot').addClass('graph-dot-show');
});
/** Fx to Enable the Calucalte button only if all fields are filled for Cheese Yield Calc  */
$(".roi-cheese-input").on("input", function () {
  $("#cheese-submit-btn").attr("disabled", "disabled");
  var ProductionDays = $('input[name="ProductionDays"]').val();
  var AvgLbsMilkIntoPlant = $('input[name="AvgLbsMilkIntoPlant"]').val();
  var AvgFinishedGoodsPurchasePrice = $('input[name="AvgFinishedGoodsPurchasePrice"]').val();
  var AvgWeightFinishedGoods = $('input[name="AvgWeightFinishedGoods"]').val();
  var AvgCostFinishedGoods = $('input[name="AvgCostFinishedGoods"]').val();
  //setTimeout( function() {
  if (ProductionDays != "" && AvgLbsMilkIntoPlant != "" && AvgFinishedGoodsPurchasePrice != "" && AvgWeightFinishedGoods != "" && AvgCostFinishedGoods != "" && $('#error-message').length == 0 ) {
    // if (($( "#error-message" ).length &&  $('#error-message').css('display') == 'none' ) ) {
    //   $("#cheese-submit-btn").removeAttr("disabled");
    // }
     $("#cheese-submit-btn").removeAttr("disabled");
  }
  //}, 400 ); // Waits 1/2 second.
});
/** Fx to Calucalte the results for Cheese Yield Calc */
$("#cheese-submit-btn").click(function (event) {
  var ProductionDays = $('input[name="ProductionDays"]').val();
  var MilkIntake = $('input[name="AvgLbsMilkIntoPlant"]').val().replace(/,/g, ""); // Remove comma from value if any
  var AvgFinishedGoodsPurchasePrice = $('input[name="AvgFinishedGoodsPurchasePrice"]').val().replace(/,/g, ""); // Remove comma from value if any
  var AvgWeightFinishedGoods = $('input[name="AvgWeightFinishedGoods"]').val().replace(/,/g, ""); // Remove comma from value if any
  var AvgCostFinishedGoods = $('input[name="AvgCostFinishedGoods"]').val().replace(/,/g, ""); // Remove comma from value if any

  var LowTargetYield = $('input[name="LowTargetYield"]').val();
  LowTargetYieldImprovement = parseFloat(LowTargetYield) / 100;
  var HighTargetYield = $('input[name="HighTargetYield"]').val();
  HighTargetYieldImprovement = parseFloat(HighTargetYield) / 100;

    var lowEstimations = ProductionDays*MilkIntake*LowTargetYieldImprovement *(AvgFinishedGoodsPurchasePrice-AvgCostFinishedGoods)/AvgWeightFinishedGoods;

    var lowFinalEstimations = parseFloat(lowEstimations).toFixed(2);
    if (lowFinalEstimations != null && !isNaN(lowFinalEstimations)) {
      var lowParts = lowFinalEstimations.toString().split(".");
      lowParts[0] = lowParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      var lowCommaEstimations = lowParts.join(".");
    }
    console.log(lowFinalEstimations + ' low est');
    $('.ever-graph-cheese-wrapper .graph-dot').css('visibility', 'visible');
	  console.log(convertToInternationalCurrencySystem(lowFinalEstimations) + ' CY Low');
    $(".ever-graph-cheese-low #lowRoi").text("$" + convertToInternationalCurrencySystem(lowFinalEstimations));
    var highEstimations = ProductionDays*MilkIntake*HighTargetYieldImprovement * (AvgFinishedGoodsPurchasePrice-AvgCostFinishedGoods)/AvgWeightFinishedGoods;

    var highFinalEstimations = parseFloat(highEstimations).toFixed(2);
    if (highFinalEstimations != null && !isNaN(highFinalEstimations)) {
      var highParts = highFinalEstimations.toString().split(".");
      highParts[0] = highParts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      var highCommaEstimations = highParts.join(".");
    }
    console.log(highFinalEstimations + ' high est');
	console.log(convertToInternationalCurrencySystem(highFinalEstimations) + ' CY High');
    $(".ever-graph-cheese-high #highRoi").text("$" + convertToInternationalCurrencySystem(highFinalEstimations));
    $('.ever-cal-result-wrapper .ever-graph-high .graph-dot').addClass('graph-dot-show');
    $('.ever-cal-result-wrapper .ever-graph-low .graph-dot').addClass('graph-dot-show');
});