<?php

/**
 * Plugin Name: ROI calculator
 * Description: Plugin to calculate ROI and display form component on page
 * Version:     1.0.0
 * Author:      GrowthNatives
 * Author URI:  https://growthnatives.com/
 */

function create_plugin_database_table()
{
  global $table_prefix, $wpdb;
  $tblname = 'roi_info';
  $wp_roi_table = $table_prefix . $tblname;
  #Check to see if the table exists already, if not, then create it
  if($wpdb->get_var("show tables like '$wp_roi_table'") != $wp_roi_table) {
    $sql = "CREATE TABLE `" . $wp_roi_table . "` ( ";
    $sql .= "  `id`  int(11)   NOT NULL auto_increment, ";
    $sql .= "  `calc_name`  text   NOT NULL, ";
    $sql .= "  `json_calculation`  text   NOT NULL, ";
    $sql .= "  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, ";
    $sql .= "  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, ";
    $sql .= "  PRIMARY KEY `order_id` (`id`) ";
    $sql .= ") ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ; ";
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    dbDelta($sql);
  }
  $InitialRow = $wpdb->get_row("SELECT * FROM $wp_roi_table");
    if ($InitialRow == null) {
        $row1_json_array = '{
            "Calculations": [
              {
                "LowYieldRange": "0.100",
                "HighYieldRange": "0.400",
                "LowWasteWaterRange" : "3.0",
                "HighWasteWaterRange" : "5.0",
                "SolidsRetentionLow" : "0.25",
                "SolidsRetentionHigh" : "0.75",
                "AvgCWTPriceForMilk" : "20.53",
                "ContainerBgColor": "#ffffff",
                "HeadingColor": "#000000",
                "HeadingTextSize": "20",
                "HeadingTextWeight": "700",
                "LabelColor": "#2f7e6b",
                "LabelTextSize": "14",
                "LabelTextWeight": "700",
                "FieldBgColor": "#ffffff",
                "FieldColor": "#3e3e3f",
                "PlaceholderColor": "#c5c5c5",
                "FieldTextSize": "14",
                "FieldTextWeight": "400",
                "ButtonBgColor": "#2f76eb",
                "ButtonHoverColor": "#317263",
                "ButtonTextColor": "#ffffff",
                "ButtonTextHoverColor": "#ffffff",
                "ButtonTextSize": "14",
                "ButtonTextWeight": "700"
              }
            ]
          }';
          $row2_json_array = 
          '{
            "Calculations": [
                {
                  "LowTargetYield": "0.25",
                  "HighTargetYield": "0.75",
                  "ContainerBgColor": "#ffffff",
                  "HeadingColor": "#000000",
                  "HeadingTextSize": "20",
                  "HeadingTextWeight": "700",
                  "LabelColor": "#2f7e6b",
                  "LabelTextSize": "14",
                  "LabelTextWeight": "700",
                  "FieldBgColor": "#ffffff",
                  "FieldColor": "#3e3e3f",
                  "PlaceholderColor": "#c5c5c5",
                  "FieldTextSize": "14",
                  "FieldTextWeight": "400",
                  "ButtonBgColor": "#2f76eb",
                  "ButtonHoverColor": "#317263",
                  "ButtonTextColor": "#ffffff",
                  "ButtonTextHoverColor": "#ffffff",
                  "ButtonTextSize": "14",
                  "ButtonTextWeight": "700"
                }   
            ]
           }';
            
        $wpdb->insert( 
            $wp_roi_table, 
            array(  
            'calc_name' => 'Mass Balance',
            'json_calculation' => $row1_json_array
            )
        );
        $wpdb->insert( 
            $wp_roi_table, 
            array(  
            'calc_name' => 'Cheese Yield',
            'json_calculation' => $row2_json_array
            )
        );
    }
}

register_activation_hook(__FILE__, 'create_plugin_database_table');
/***Registers the ROI calculator Settings in dashboard menu.*/
add_action('admin_menu', 'roi_calculator_menu');
//Create ROI calculator WordPress admin menu 
if (!function_exists("roi_calculator_menu")) {
  function roi_calculator_menu()
  {
    $page_title = 'ROI Calculator';
    $menu_title = 'ROI Calculator';
    $capability = 'manage_options';
    $menu_slug  = 'roi-calculator';
    $function   = 'massBalanceAdminPage';
    $icon_url   = 'dashicons-analytics';
    $position   = 4;
    add_menu_page(
      $page_title,
      $menu_title,
      $capability,
      $menu_slug,
      $function,
      $icon_url,
      $position
    );
    add_submenu_page('roi-calculator', 'Mass Balance Info', 'Mass Balance Info', 'manage_options', 'roi-calculator' );
    add_submenu_page("roi-calculator", "Cheese Yield Info", "Cheese Yield Info", 4, "roi-cheese-yield", "cheeseYieldAdminPage");
  }
}
/* Enqueue custom Styles */
function load_parent_styles()
{
  wp_register_style('calc-custom-style', plugin_dir_url(__FILE__) . 'assets/css/custom.css');
}
add_action('wp_enqueue_scripts', 'load_parent_styles');

/* Enqueue custom Scripts */
function enqueque_scriptss()
{
    wp_register_script('calc-jquery', plugin_dir_url(__FILE__) . 'assets/js/jquery-3.7.0.min.js', [], false, false);
	wp_register_script('calc-custom-js', plugin_dir_url(__FILE__) . 'assets/js/custom.js', array(), 1, 1, 1);
  
}
add_action('wp_enqueue_scripts', 'enqueque_scriptss');
// Enqueue script on admin page
function enqueue_admin_script()
{
  wp_enqueue_style('dashboard-custom-style', plugin_dir_url(__FILE__) . 'assets/css/adminstyle.css');
  if(is_admin() && isset($_GET['page']) && ($_GET['page'] == 'roi-calculator' || $_GET['page'] == 'roi-cheese-yield') ) {
    wp_enqueue_script('roi-jquery', plugin_dir_url(__FILE__) . 'assets/js/jquery-3.7.0.min.js');
  }
  wp_enqueue_script('dashboard_custom_script', plugin_dir_url(__FILE__) . 'assets/js/adminscript.js');
}
add_action('admin_enqueue_scripts', 'enqueue_admin_script');

/** Fx for CRUD of Mass Balance Calc in Admin */
function massBalanceAdminPage() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'roi_info';
    if (isset($_POST['uptsubmit'])) {
      $id = $_POST['uptid'];
      $calcName = $_POST['calcName'];
      $lowYieldRange = $_POST['LowYieldRange'];
      $highYieldRange = $_POST['highYieldRange'];
      $lowWasteWaterRange = $_POST['LowWasteWaterRange'];
      $highWasteWaterRange = $_POST['HighWasteWaterRange'];
      $solidsRetentionLow = $_POST['SolidsRetentionLow'];
      $solidsRetentionHigh = $_POST['SolidsRetentionHigh'];
      $avgCwtPriceForMilk = $_POST['AvgCWTPriceForMilk'];
      $ContainerBgColor = $_POST['ContainerBgColor'];
      $headingColor = $_POST['HeadingColor'];
      $HeadingTextSize = $_POST['HeadingTextSize'];
      $HeadingTextWeight = $_POST['HeadingTextWeight'];
      $LabelColor = $_POST['LabelColor'];
      $LabelTextSize = $_POST['LabelTextSize'];
      $LabelTextWeight = $_POST['LabelTextWeight'];
      $FieldBgColor = $_POST['FieldBgColor'];
      $FieldColor = $_POST['FieldColor'];
      $PlaceholderColor = $_POST['PlaceholderColor'];
      $FieldTextSize = $_POST['FieldTextSize'];
      $FieldTextWeight = $_POST['FieldTextWeight'];
      $ButtonBgColor = $_POST['ButtonBgColor'];
      $ButtonHoverColor = $_POST['ButtonHoverColor'];
      $ButtonTextColor = $_POST['ButtonTextColor'];
      $ButtonTextHoverColor = $_POST['ButtonTextHoverColor'];
      $ButtonTextSize = $_POST['ButtonTextSize'];
      $ButtonTextWeight = $_POST['ButtonTextWeight'];
      $json_array = '{
        "Calculations": [
          {
            "LowYieldRange": "'.$lowYieldRange.'",
            "HighYieldRange": "'.$highYieldRange.'",
            "LowWasteWaterRange" : "'.$lowWasteWaterRange.'",
            "HighWasteWaterRange" : "'.$highWasteWaterRange.'",
            "SolidsRetentionLow" : "'.$solidsRetentionLow.'",
            "SolidsRetentionHigh" : "'.$solidsRetentionHigh.'",
            "AvgCWTPriceForMilk" : "'.$avgCwtPriceForMilk.'",
            "ContainerBgColor": "'.$ContainerBgColor.'",
            "HeadingColor": "'.$headingColor.'",
            "HeadingTextSize": "'.$HeadingTextSize.'",
            "HeadingTextWeight": "'.$HeadingTextWeight.'",
            "LabelColor": "'.$LabelColor.'",
            "LabelTextSize": "'.$LabelTextSize.'",
            "LabelTextWeight": "'.$LabelTextWeight.'",
            "FieldBgColor": "'.$FieldBgColor.'",
            "FieldColor": "'.$FieldColor.'",
            "PlaceholderColor": "'.$PlaceholderColor.'",
            "FieldTextSize": "'.$FieldTextSize.'",
            "FieldTextWeight": "'.$FieldTextWeight.'",
            "ButtonBgColor": "'.$ButtonBgColor.'",
            "ButtonHoverColor": "'.$ButtonHoverColor.'",
            "ButtonTextColor": "'.$ButtonTextColor.'",
            "ButtonTextHoverColor": "'.$ButtonTextHoverColor.'",
            "ButtonTextSize": "'.$ButtonTextSize.'",
            "ButtonTextWeight": "'.$ButtonTextWeight.'"
          }
        ]
      }';
      $wpdb->update(
        $table_name,
        array(
          'json_calculation' => $json_array
        ),
        array(
          'calc_name' =>  'Mass Balance'
        )
      );
      //$wpdb->query("UPDATE $table_name SET json_calculation='$json_array' WHERE calc_name='Mass Balance'");
      echo "<script>location.replace('admin.php?page=roi-calculator&saved=1');</script>";
    }
    ?>
 <div class="wrap">
     <h1>ROI Mass Balance Calculator Info</h1>
    <div><p><b>Note:-</b>Add shortcode <[roi_mass_balance_calculator]> to display the Mass Balance Calculator on the desired page.</p></div>
     
     <br>
     <br>
     <?php
     if (isset($_GET['saved'])) {
       echo '<div class="updated">
       <p>' . __('Success! Values have been saved.') . '</p>
     </div>';
     }
          $result = $wpdb->get_results("SELECT * FROM $table_name WHERE calc_name='Mass Balance'");
          
          foreach( ($result ? $result : array()) as $print) {
            $data1 = $print->json_calculation;
            $jsond = json_decode($data1, true);
            //echo json_last_error_msg(); // Print out the error if any
            foreach (($jsond['Calculations'] ? $jsond['Calculations'] : array()) as $Calcrow) {
                $DbLowYieldRange = $Calcrow['LowYieldRange'];
                $DbhighYieldRange = $Calcrow['HighYieldRange'];
                $DbLowWasteWaterRange = $Calcrow['LowWasteWaterRange'];
                $DbHighWasteWaterRange = $Calcrow['HighWasteWaterRange'];
                $DbSolidsRetentionLow = $Calcrow['SolidsRetentionLow'];
                $DbSolidsRetentionHigh = $Calcrow['SolidsRetentionHigh'];
                $DbAvgCWTPriceForMilk = $Calcrow['AvgCWTPriceForMilk'];
                $DbContainerBgColor = $Calcrow['ContainerBgColor'];
                $DbHeadingColor = $Calcrow['HeadingColor'];
                $DbHeadingTextSize = $Calcrow['HeadingTextSize'];
                $DbHeadingTextWeight = $Calcrow['HeadingTextWeight'];
                $DbLabelColor = $Calcrow['LabelColor'];
                $DbLabelTextSize = $Calcrow['LabelTextSize'];
                $DbLabelTextWeight = $Calcrow['LabelTextWeight'];
                $DbFieldBgColor = $Calcrow['FieldBgColor'];
                $DbInputColor = $Calcrow['FieldColor'];
                $DbPlaceholderColor = $Calcrow['PlaceholderColor'];
                $DbFieldTextSize = $Calcrow['FieldTextSize'];
                $DbFieldTextWeight = $Calcrow['FieldTextWeight'];
                $DbButtonBgColor = $Calcrow['ButtonBgColor'];
                $DbButtonHoverColor = $Calcrow['ButtonHoverColor'];
                $DbButtonTextColor = $Calcrow['ButtonTextColor'];
                $DbButtonTextHoverColor = $Calcrow['ButtonTextHoverColor'];
                $DbButtonTextSize = $Calcrow['ButtonTextSize'];
                $DbButtonTextWeight = $Calcrow['ButtonTextWeight'];
            }
          }
          echo "
          <div class='wp-roi-wrapper'>
          <form action='' method='post'>
            <input type='hidden' id='uptid' name='uptid' value='$print->id'><input class='wp-roi-field-input' type='hidden' id='calcName' name='calcName' value='$print->calc_name'>
            <h3>Internal Value</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Low Yield Range</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='LowYieldRange' name='LowYieldRange' class='balance-input wp-roi-field-input' value='$DbLowYieldRange'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>High Yield Range</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='highYieldRange' name='highYieldRange' class='balance-input wp-roi-field-input' value='$DbhighYieldRange'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Low Waste Water Range</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='LowWasteWaterRange' name='LowWasteWaterRange' class='balance-input wp-roi-field-input' value='$DbLowWasteWaterRange'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>High Waste Water Range</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='HighWasteWaterRange' name='HighWasteWaterRange' class='balance-input wp-roi-field-input' value='$DbHighWasteWaterRange'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Solids Retention Low</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='SolidsRetentionLow' name='SolidsRetentionLow' class='balance-input wp-roi-field-input' value='$DbSolidsRetentionLow'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Solids Retention High</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='SolidsRetentionHigh' name='SolidsRetentionHigh' class='balance-input wp-roi-field-input' value='$DbSolidsRetentionHigh'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Average CWT Price for Milk</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='AvgCWTPriceForMilk' name='AvgCWTPriceForMilk' class='balance-input wp-roi-field-input' value='$DbAvgCWTPriceForMilk'>
              </div>
            </div>
            <h3>Form Container</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Container Background</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='color' class='wp-roi-field-input' id='ContainerBgColor' name='ContainerBgColor' value='$DbContainerBgColor'>
              </div>
            </div>
            <h3>Form Title</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='HeadingColor' name='HeadingColor' value='$DbHeadingColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='HeadingTextSize'  class='balance-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbHeadingTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='HeadingTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbHeadingTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbHeadingTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbHeadingTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbHeadingTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbHeadingTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbHeadingTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Form Label</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='LabelColor' name='LabelColor' value='$DbLabelColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='LabelTextSize' class='balance-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbLabelTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='LabelTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbLabelTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbLabelTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbLabelTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbLabelTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbLabelTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbLabelTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Form Field</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='FieldBgColor' name='FieldBgColor' value='$DbFieldBgColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='FieldColor' name='FieldColor' value='$DbInputColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Placeholder Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='PlaceholderColor' name='PlaceholderColor' value='$DbPlaceholderColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='FieldTextSize' class='balance-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbFieldTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='FieldTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbFieldTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbFieldTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbFieldTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbFieldTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbFieldTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbFieldTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Button Styling Field</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonBgColor' name='ButtonBgColor' value='$DbButtonBgColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Hover Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonHoverColor' name='ButtonHoverColor' value='$DbButtonHoverColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonTextColor' name='ButtonTextColor' value='$DbButtonTextColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p> Text Hover Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonTextHoverColor' name='ButtonTextHoverColor' value='$DbButtonTextHoverColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='ButtonTextSize' class='balance-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbButtonTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='ButtonTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbButtonTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbButtonTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbButtonTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbButtonTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbButtonTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbButtonTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                
              </div>
              <div class='wp-roi-field-col'>
              <button id='uptsubmit' name='uptsubmit' class='balance-submit wp-roi-submit' type='submit'>UPDATE</button> <a href='admin.php?page=roi-calculator&saved=1'></a>
              </div>
            </div>
          </form>
          </div>
          ";
      ?>
 </div>
 <?php
  }
/** Fx for CRUD of Cheese Yield Calc in Admin */
function cheeseYieldAdminPage() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'roi_info';
    if (isset($_POST['uptsubmit'])) {
      $id = $_POST['uptid'];
      $calcName = $_POST['calcName'];
      $lowTargetYieldRange = $_POST['LowTargetYield'];
      $highTargetYieldRange = $_POST['highTargetYield'];
      $ContainerBgColor = $_POST['ContainerBgColor'];
      $headingColor = $_POST['HeadingColor'];
      $HeadingTextSize = $_POST['HeadingTextSize'];
      $HeadingTextWeight = $_POST['HeadingTextWeight'];
      $LabelColor = $_POST['LabelColor'];
      $LabelTextSize = $_POST['LabelTextSize'];
      $LabelTextWeight = $_POST['LabelTextWeight'];
      $FieldBgColor = $_POST['FieldBgColor'];
      $FieldColor = $_POST['FieldColor'];
      $PlaceholderColor = $_POST['PlaceholderColor'];
      $FieldTextSize = $_POST['FieldTextSize'];
      $FieldTextWeight = $_POST['FieldTextWeight'];
      $ButtonBgColor = $_POST['ButtonBgColor'];
      $ButtonHoverColor = $_POST['ButtonHoverColor'];
      $ButtonTextColor = $_POST['ButtonTextColor'];
      $ButtonTextHoverColor = $_POST['ButtonTextHoverColor'];
      $ButtonTextSize = $_POST['ButtonTextSize'];
      $ButtonTextWeight = $_POST['ButtonTextWeight'];
      $json_array = '{
        "Calculations": [
          {
            "LowTargetYield": "'.$lowTargetYieldRange.'",
            "HighTargetYield": "'.$highTargetYieldRange.'",
            "ContainerBgColor": "'.$ContainerBgColor.'",
            "HeadingColor": "'.$headingColor.'",
            "HeadingTextSize": "'.$HeadingTextSize.'",
            "HeadingTextWeight": "'.$HeadingTextWeight.'",
            "LabelColor": "'.$LabelColor.'",
            "LabelTextSize": "'.$LabelTextSize.'",
            "LabelTextWeight": "'.$LabelTextWeight.'",
            "FieldBgColor": "'.$FieldBgColor.'",
            "FieldColor": "'.$FieldColor.'",
            "PlaceholderColor": "'.$PlaceholderColor.'",
            "FieldTextSize": "'.$FieldTextSize.'",
            "FieldTextWeight": "'.$FieldTextWeight.'",
            "ButtonBgColor": "'.$ButtonBgColor.'",
            "ButtonHoverColor": "'.$ButtonHoverColor.'",
            "ButtonTextColor": "'.$ButtonTextColor.'",
            "ButtonTextHoverColor": "'.$ButtonTextHoverColor.'",
            "ButtonTextSize": "'.$ButtonTextSize.'",
            "ButtonTextWeight": "'.$ButtonTextWeight.'"
          }
        ]
      }';
      $wpdb->update(
        $table_name,
        array(
          'json_calculation' => $json_array
        ),
        array(
          'calc_name' =>  'Cheese Yield'
        )
      );
      echo "<script>location.replace('admin.php?page=roi-cheese-yield&saved=1');</script>";
    }
    ?>
 <div class="wrap">
     <h1>ROI Cheese Yield Calculator Info</h1>
    <div><p><b>Note:-</b>Add shortcode <[roi_cheese_yield_calculator]> to display the Cheese Yield Calculator on the desired page.</p></div>
     
     <br>
     <br>
     <?php
     if (isset($_GET['saved'])) {
       echo '<div class="updated">
       <p>' . __('Success! Values have been saved.') . '</p>
     </div>';
     }
          $result = $wpdb->get_results("SELECT * FROM $table_name WHERE calc_name='Cheese Yield'");
          foreach( ($result ? $result : array()) as $print) {
            $data1 = $print->json_calculation;
            $jsond = json_decode($data1, true);
            //echo json_last_error_msg(); // Print out the error if any
            foreach (($jsond['Calculations'] ? $jsond['Calculations'] : array()) as $Calcrow) {
                $DbLowTargetYield = $Calcrow['LowTargetYield'];
                $DbhighTargetYield = $Calcrow['HighTargetYield'];
                $DbContainerBgColor = $Calcrow['ContainerBgColor'];
                $DbHeadingColor = $Calcrow['HeadingColor'];
                $DbHeadingTextSize = $Calcrow['HeadingTextSize'];
                $DbHeadingTextWeight = $Calcrow['HeadingTextWeight'];
                $DbLabelColor = $Calcrow['LabelColor'];
                $DbLabelTextSize = $Calcrow['LabelTextSize'];
                $DbLabelTextWeight = $Calcrow['LabelTextWeight'];
                $DbFieldBgColor = $Calcrow['FieldBgColor'];
                $DbInputColor = $Calcrow['FieldColor'];
                $DbPlaceholderColor = $Calcrow['PlaceholderColor'];
                $DbFieldTextSize = $Calcrow['FieldTextSize'];
                $DbFieldTextWeight = $Calcrow['FieldTextWeight'];
                $DbButtonBgColor = $Calcrow['ButtonBgColor'];
                $DbButtonHoverColor = $Calcrow['ButtonHoverColor'];
                $DbButtonTextColor = $Calcrow['ButtonTextColor'];
                $DbButtonTextHoverColor = $Calcrow['ButtonTextHoverColor'];
                $DbButtonTextSize = $Calcrow['ButtonTextSize'];
                $DbButtonTextWeight = $Calcrow['ButtonTextWeight'];
            }
          }
          echo "
          <div class='wp-roi-wrapper'>
          <form action='' method='post'>
            <input type='hidden' id='uptid' name='uptid' value='$print->id'><input class='wp-roi-field-input' type='hidden' id='calcName' name='calcName' value='$print->calc_name'>
            <h3>Internal Value</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Low Target Yield</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='LowTargetYield' name='LowTargetYield' class='yield-input wp-roi-field-input' value='$DbLowTargetYield'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>High Target Yield</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='text' id='highTargetYield' name='highTargetYield' class='yield-input wp-roi-field-input' value='$DbhighTargetYield'>
              </div>
            </div>
            <h3>Form Container</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Container Background</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='color' class='wp-roi-field-input' id='ContainerBgColor' name='ContainerBgColor' value='$DbContainerBgColor'>
              </div>
            </div>
            <h3>Form Title</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='HeadingColor' name='HeadingColor' value='$DbHeadingColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='HeadingTextSize'  class='yield-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbHeadingTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='HeadingTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbHeadingTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbHeadingTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbHeadingTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbHeadingTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbHeadingTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbHeadingTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Form Label</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='LabelColor' name='LabelColor' value='$DbLabelColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='LabelTextSize' class='yield-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbLabelTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='LabelTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbLabelTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbLabelTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbLabelTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbLabelTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbLabelTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbLabelTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Form Field</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='FieldBgColor' name='FieldBgColor' value='$DbFieldBgColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='FieldColor' name='FieldColor' value='$DbInputColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Placeholder Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='PlaceholderColor' name='PlaceholderColor' value='$DbPlaceholderColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='FieldTextSize' class='yield-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbFieldTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='FieldTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbFieldTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbFieldTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbFieldTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbFieldTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbFieldTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbFieldTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <h3>Button Styling Field</h3>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonBgColor' name='ButtonBgColor' value='$DbButtonBgColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Background Hover Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonHoverColor' name='ButtonHoverColor' value='$DbButtonHoverColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonTextColor' name='ButtonTextColor' value='$DbButtonTextColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p> Text Hover Color</p>
              </div>
              <div class='wp-roi-field-col'>
              <input class='wp-roi-field-input' type='color' id='ButtonTextHoverColor' name='ButtonTextHoverColor' value='$DbButtonTextHoverColor'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Size (in px)</p>
              </div>
              <div class='wp-roi-field-col'>
                <input type='number' name='ButtonTextSize' class='yield-input wp-roi-field-input disallow-decimal-negative' min='2' max='80' value='$DbButtonTextSize'>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                <p>Text Weight</p>
              </div>
              <div class='wp-roi-field-col'>
                <select name='ButtonTextWeight' class='wp-roi-field-input'>
                  <option value='200' ".(($DbButtonTextWeight=='200')?'selected="selected"':'').">200</option>
                  <option value='300' ".(($DbButtonTextWeight=='300')?'selected="selected"':'').">300</option>
                  <option value='400' ".(($DbButtonTextWeight=='400')?'selected="selected"':'').">400</option>
                  <option value='500' ".(($DbButtonTextWeight=='500')?'selected="selected"':'').">500</option>
                  <option value='600' ".(($DbButtonTextWeight=='600')?'selected="selected"':'').">600</option>
                  <option value='700' ".(($DbButtonTextWeight=='700')?'selected="selected"':'').">700</option>
                </select>
              </div>
            </div>
            <div class='wp-roi-row'>
              <div class='wp-roi-label-col'>
                
              </div>
              <div class='wp-roi-field-col'>
              <button id='uptsubmit' name='uptsubmit' class='yield-submit wp-roi-submit' type='submit'>UPDATE</button> <a href='admin.php?page=roi-calculator&saved=1'></a>
              </div>
            </div>
          </form>
          </div>
          ";
      ?>
 </div>
 <?php
  }
//Create frontend content form of ROI calculator
/** Fx for ROI Mass Balance Calculator Functionality in frontend and shortcode register */
function massBalance_roi_calculator(){
	wp_enqueue_style('calc-custom-style');
	wp_enqueue_script('calc-jquery');
	wp_enqueue_script('calc-custom-js');
    global $table_prefix, $wpdb;
    $tblname = 'roi_info';
    $table_name = $table_prefix . $tblname;
    $results = $wpdb->get_results("SELECT * FROM $table_name WHERE calc_name='Mass Balance'");
  
     // Query to fetch data from database table and storing in $results
    if (!empty($results)) 
                      // Checking if $results have some values or not
    {
      foreach ($results as $row) {
        $calcData = $row->json_calculation;
        $jsonCalc = json_decode($calcData, true);
        foreach ( ($jsonCalc['Calculations'] ? $jsonCalc['Calculations'] : array()) as $Calcrow ) {
            $DbLowYieldRange = $Calcrow['LowYieldRange'];
            $DbhighYieldRange = $Calcrow['HighYieldRange'];
            $DbLowWasteWaterRange = $Calcrow['LowWasteWaterRange'];
            $DbHighWasteWaterRange = $Calcrow['HighWasteWaterRange'];
            $DbSolidsRetentionLow = $Calcrow['SolidsRetentionLow'];
            $DbSolidsRetentionHigh = $Calcrow['SolidsRetentionHigh'];
            $DbAvgCWTPriceForMilk = $Calcrow['AvgCWTPriceForMilk'];
            $DbContainerBgColor = $Calcrow['ContainerBgColor'];
            $DbHeadingColor = $Calcrow['HeadingColor'];
            $DbHeadingTextSize = $Calcrow['HeadingTextSize'];
            $DbHeadingTextWeight = $Calcrow['HeadingTextWeight'];
            $DbLabelColor = $Calcrow['LabelColor'];
            $DbLabelTextSize = $Calcrow['LabelTextSize'];
            $DbLabelTextWeight = $Calcrow['LabelTextWeight'];
            $DbFieldBgColor = $Calcrow['FieldBgColor'];
            $DbInputColor = $Calcrow['FieldColor'];
            $DbPlaceholderColor = $Calcrow['PlaceholderColor'];
            $DbFieldTextSize = $Calcrow['FieldTextSize'];
            $DbFieldTextWeight = $Calcrow['FieldTextWeight'];
            $DbButtonBgColor = $Calcrow['ButtonBgColor'];
            $DbButtonHoverColor = $Calcrow['ButtonHoverColor'];
            $DbButtonTextColor = $Calcrow['ButtonTextColor'];
            $DbButtonTextHoverColor = $Calcrow['ButtonTextHoverColor'];
            $DbButtonTextSize = $Calcrow['ButtonTextSize'];
            $DbButtonTextWeight = $Calcrow['ButtonTextWeight'];
        }
      }
    }
	$output = '';
	$output .= 
	'<div class=" ever-form-row">
    <style>
      .ever-col-form .ever-roi-input{
        color: '.$DbInputColor.';
      }
      .ever-col-form .ever-roi-input::-webkit-input-placeholder {
        color: '.$DbPlaceholderColor.';
      }
      
      .ever-col-form .ever-roi-input::-moz-placeholder {
        color: '.$DbPlaceholderColor.';
      }
      
      .ever-col-form .ever-roi-input:-ms-input-placeholder {
        color: '.$DbPlaceholderColor.';
      }
      
      .ever-col-form .ever-roi-input:-moz-placeholder {
        color: '.$DbPlaceholderColor.';
      }
      .ever-col-form .ever-fill-btn{
        background: '.$DbButtonBgColor.';
        color: '.$DbButtonTextColor.';
      }
      .ever-col-form .ever-fill-btn:hover,
      .ever-col-form .ever-fill-btn:focus{
        background: '.$DbButtonHoverColor.';
        color: '.$DbButtonTextHoverColor.';
      }
    </style>
    <div class="ever-col-form" style="background-color:'.$DbContainerBgColor.';">
      <h3 style="color:'.$DbHeadingColor.'; font-size:'.$DbHeadingTextSize.'px; font-weight:'.$DbHeadingTextWeight.';">Mass Balance Calculator</h3>
      <form id="roiForm">
        <input type="hidden" name="LowYieldRange" value="'.$DbLowYieldRange.'">
        <input type="hidden" name="HighYieldRange" value="'.$DbhighYieldRange.'">
        <input type="hidden" name="LowWasteWaterRange" value="'.$DbLowWasteWaterRange.'">
        <input type="hidden" name="HighWasteWaterRange" value="'.$DbHighWasteWaterRange.'">
        <input type="hidden" name="SolidsRetentionLow" value="'.$DbSolidsRetentionLow.'">
        <input type="hidden" name="SolidsRetentionHigh" value="'.$DbSolidsRetentionHigh.'">
        <input type="hidden" name="AvgCWTPriceForMilk" value="'.$DbAvgCWTPriceForMilk.'">		
        <div class="ever-form-full-col">
          <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Production Days(max 365)</label>
          <input id="ProductionDays" style="ffont-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-mass-input input-field prod-days disallow-decimal-negative" type="number" onkeydown="javascript: return event.keyCode == 69 ? false : true" name="ProductionDays" placeholder="eg. 365" min="1" max="365">
        </div>
        <div class="ever-form-full-col">
          <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Milk into Plant per Day (in lbs)</label>
            <input id="AvgLbsMilkIntoPlant" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-mass-input comma-inputs input-field disallow-decimal-negative disallow-zero" type="text" name="AvgLbsMilkIntoPlant" placeholder="eg. 50,000" data-min="1">
        </div>
        <div class="ever-form-full-col">
          <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Price for a Finished Goods (in $)</label>
          <input id="AvgSalePriceOfFinishedGoods" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-mass-input comma-inputs input-field limit-two-deci" type="text" name="AvgSalePriceOfFinishedGoods" placeholder="eg. 5,000">
        </div>							
        <div class="ever-form-full-col">
          <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Waste Water Monthly Bill (in $) </label>
          <input id="AvgMonthlyWasteWaterBill" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-mass-input comma-inputs input-field" type="text" name="AvgMonthlyWasteWaterBill" placeholder="eg. 50,000">
        </div>
        <div class="ever-form-full-col">
          <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Current Shrink per MA Reports (in %) </label>
          <input id="CurrentShrink" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';line-height: 16px;border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-mass-input input-field disallow-negative" type="number"  onkeydown="javascript: return event.keyCode == 69 ? false : true" name="CurrentShrink" placeholder="eg. 10" min="1">
        </div>
        <div class="ever-form-full-col">
          <button id="ever-fill-btn" style="font-size:'.$DbButtonTextSize.'px; font-weight: '.$DbButtonTextWeight.';" class="ever-fill-btn" type="button">Calculate</button>				
        </div>			
	    </form>
    </div>	
    <div id="ever-cal-result-wrapper" class="ever-cal-result-wrapper"  style="background-image:url(https://ever-ag.growthpod.me/wp-content/uploads/2023/12/milk-production-bg.png);">
        <h3 style="font-size:18px; font-weight:500; color:#3E3E3F;">Based on Ever.Ag’s experience, your organization could see a return on your investment within the following range. </h3>
        <div class="ever-graph-wrapper">
        <div class="ever-graph-high">
          <p style="">
          <span class="graph-amount" style="font-size:14px; font-weight:700; color:#3e3e3f;" id="highRoi"></span>
          <span class="garph-line" style="background-color:#2F7E6B;"></span>
          <span class="graph-dot" style="background-color:#2F7E6B;"></span>
          <span class="graph-label" style="font-size:10px; font-weight:500 color:#3e3e3f;">High ROI</span></p>
        </div>
        <div class="ever-graph-avg">
          <p class="mid-roi-value">
          <span class="graph-amount" style="font-size:14px; font-weight:700; color:#3e3e3f;" id="roiAvg"></span>
          <span class="garph-line" style="background-color:#3e3e3f;"></span>
          <span class="graph-dot" style="background-color:#3e3e3f;"></span>
          <span class="graph-label" style="font-size:10px; font-weight:500 color:#3e3e3f;">Average</span>
          </p>
        </div>
        <div class="ever-graph-low">
          <p>
          <span class="graph-amount" style="font-size:14px; font-weight:700; color:#3e3e3f;" id="lowRoi"></span>
          <span class="garph-line " style="background-color:#ff0000;"></span>
          <span class="graph-dot" style="background-color:#ff0000;"></span>
          <span class="graph-label" style="font-size:10px; font-weight:500 color:#3e3e3f;">Low ROI</span></p>
        </div>
        </div>     
    </div>
  </div>
	<!--end form calculator section-->';
	  return $output;
}
add_shortcode('roi_mass_balance_calculator', 'massBalance_roi_calculator');
/** Fx for ROI Cheese Yield Calculator Functionality in frontend and shortcode register */
function cheeseYield_roi_calculator(){
	wp_enqueue_style('calc-custom-style');
	wp_enqueue_script('calc-jquery');
	wp_enqueue_script('calc-custom-js');
    global $table_prefix, $wpdb;
    $tblname = 'roi_info';
    $table_name = $table_prefix . $tblname;
    $results = $wpdb->get_results("SELECT * FROM $table_name WHERE calc_name='Cheese Yield'");
     // Query to fetch data from database table and storing in $results
    if (!empty($results))   // Checking if $results have some values or not
    {
      foreach ($results as $row) {
        $calcData = $row->json_calculation;
        $jsonCalc = json_decode($calcData, true);
        foreach ( ($jsonCalc['Calculations'] ? $jsonCalc['Calculations'] : array()) as $Calcrow ) {
          $DbLowTargetYield = $Calcrow['LowTargetYield'];
          $DbhighTargetYield = $Calcrow['HighTargetYield'];
          $DbContainerBgColor = $Calcrow['ContainerBgColor'];
          $DbHeadingColor = $Calcrow['HeadingColor'];
          $DbHeadingTextSize = $Calcrow['HeadingTextSize'];
          $DbHeadingTextWeight = $Calcrow['HeadingTextWeight'];
          $DbLabelColor = $Calcrow['LabelColor'];
          $DbLabelTextSize = $Calcrow['LabelTextSize'];
          $DbLabelTextWeight = $Calcrow['LabelTextWeight'];
          $DbFieldBgColor = $Calcrow['FieldBgColor'];
          $DbInputColor = $Calcrow['FieldColor'];
          $DbPlaceholderColor = $Calcrow['PlaceholderColor'];
          $DbFieldTextSize = $Calcrow['FieldTextSize'];
          $DbFieldTextWeight = $Calcrow['FieldTextWeight'];
          $DbButtonBgColor = $Calcrow['ButtonBgColor'];
          $DbButtonHoverColor = $Calcrow['ButtonHoverColor'];
          $DbButtonTextColor = $Calcrow['ButtonTextColor'];
          $DbButtonTextHoverColor = $Calcrow['ButtonTextHoverColor'];
          $DbButtonTextSize = $Calcrow['ButtonTextSize'];
          $DbButtonTextWeight = $Calcrow['ButtonTextWeight'];
        }
      }
    }
	$output = '';
	$output .=   
	'<div class=" ever-form-row">
    <style>
        .ever-col-form .ever-roi-input{
          color: '.$DbInputColor.';
        }
        .ever-col-form .ever-roi-input::-webkit-input-placeholder {
            color: '.$DbPlaceholderColor.';
          }
          
          .ever-col-form .ever-roi-input::-moz-placeholder {
            color: '.$DbPlaceholderColor.';
          }
          
          .ever-col-form .ever-roi-input:-ms-input-placeholder {
            color: '.$DbPlaceholderColor.';
          }
          
          .ever-col-form .ever-roi-input:-moz-placeholder {
            color: '.$DbPlaceholderColor.';
          }
          .ever-col-form .ever-fill-btn{
            background: '.$DbButtonBgColor.';
            color: '.$DbButtonTextColor.';
          }
          .ever-col-form .ever-fill-btn:hover,
          .ever-col-form .ever-fill-btn:focus{
            background: '.$DbButtonHoverColor.';
            color: '.$DbButtonTextHoverColor.';
          }
      </style>
      <div class="ever-col-form" style="background-color:'.$DbContainerBgColor.';">
        <h3 style="color:'.$DbHeadingColor.'; font-size:'.$DbHeadingTextSize.'px; font-weight:'.$DbHeadingTextWeight.';">Cheese Yield Calculator</h3>
        <form id="roiForm">
          <input type="hidden" name="LowTargetYield" value="'.$DbLowTargetYield.'">
          <input type="hidden" name="HighTargetYield" value="'.$DbhighTargetYield.'">
          <div class="ever-form-full-col">
            <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Production Days (max 365)</label>
            <input id="ProductionDays" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-cheese-input input-field prod-days disallow-decimal-negative" type="number"  onkeydown="javascript: return event.keyCode == 69 ? false : true" name="ProductionDays" placeholder="eg. 365" min="1" max="365">
          </div>
          <div class="ever-form-full-col">
            <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Milk per Day into Plant (in lbs) </label>
              <input id="AvgLbsMilkIntoPlant" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-cheese-input comma-inputs input-field disallow-decimal-negative disallow-zero" type="text" name="AvgLbsMilkIntoPlant" placeholder="eg. 1,000,000" data-min="1">
          </div>
          <div class="ever-form-full-col">
            <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Sale Price for a Finished Goods (in $)</label>
            <input id="AvgFinishedGoodsPurchasePrice" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-cheese-input comma-inputs input-field limit-two-deci" type="text" name="AvgFinishedGoodsPurchasePrice" placeholder="eg. 50.00">
          </div>							
          <div class="ever-form-full-col">
            <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Weight for Finished Goods (in lbs) </label>
            <input id="AvgWeightFinishedGoods" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" class="ever-roi-input roi-cheese-input comma-inputs input-field disallow-decimal-negative disallow-zero" type="text" name="AvgWeightFinishedGoods" placeholder="eg. 40" data-min="1">
          </div>
          <div class="ever-form-full-col">
            <label style="font-size:'.$DbLabelTextSize.'px; font-weight:'.$DbLabelTextWeight.'; color:'.$DbLabelColor.';">Average Cost for a Finished Good (in $)</label>
            <input id="AvgCostFinishedGoods" style="font-size: '.$DbFieldTextSize.'px;font-weight: '.$DbFieldTextWeight.';border: 1px solid #ECECEC; background-color:'.$DbFieldBgColor.';" name="AvgCostFinishedGoods" class="ever-roi-input roi-cheese-input comma-inputs input-field" type="text" placeholder="eg. 25.00">
          </div>
          <div class="ever-form-full-col">
            <button id="cheese-submit-btn" style="font-size:'.$DbButtonTextSize.'px; font-weight: '.$DbButtonTextWeight.'; " class="ever-fill-btn" type="button">Calculate</button>				
          </div>
        </form>
		  </div> 
		<div id="cheese-result-wrapper" class="ever-cal-result-wrapper" style="background-image:url(https://ever-ag.growthpod.me/wp-content/uploads/2024/01/cheese-bg.jpg);">
      <h3 style="font-size:18px; font-weight:500; color:#3E3E3F;">Based on Ever.Ag’s experience, your organization could see a return on your investment within the following range. </h3>
			<div class="ever-graph-cheese-wrapper">    
        <div class="ever-graph-cheese-low">
            <p>
              <span class="graph-amount" id="lowRoi"></span>
              <span class="graph-dot" style="background-color:#ff0000;"></span>
              <span class="graph-label">Low ROI</span>
            </p>
        </div>
        <div class="ever-graph-cheese-high">
          <p>
            <span class="graph-amount" id="highRoi"></span>
            <span class="graph-dot" style="background-color:#2F7E6B;"></span>
            <span class="graph-label">High ROI</span>
          </p>
        </div>
      </div>
      <div class="ever-graph-form-wrapper">
          <h3 style="font-size:18px; font-weight:500; color:#3E3E3F;">Let’s Speak to Maximize Your Dairy Processing</h3>
          <div class="ever-graph-form-row">
            <input type="email" class="ever-graph-input" placeholder="Corporate Email Address">
            <input type="submit" class="ever-email-submit" value="Submit">
          </div>
      </div>
    </div>
  </div>
	<!--end form calculator section-->';
	  return $output;
}
add_shortcode('roi_cheese_yield_calculator', 'cheeseYield_roi_calculator');