<?php
/**
 * Twenty Twenty-Four functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Twenty Twenty-Four
 * @since Twenty Twenty-Four 1.0
 */

/**
 * Register block styles.
 */

if ( ! function_exists( 'twentytwentyfour_block_styles' ) ) :
	/**
	 * Register custom block styles
	 *
	 * @since Twenty Twenty-Four 1.0
	 * @return void
	 */
	function twentytwentyfour_block_styles() {

		register_block_style(
			'core/details',
			array(
				'name'         => 'arrow-icon-details',
				'label'        => __( 'Arrow icon', 'twentytwentyfour' ),
				/*
				 * Styles for the custom Arrow icon style of the Details block
				 */
				'inline_style' => '
				.is-style-arrow-icon-details {
					padding-top: var(--wp--preset--spacing--10);
					padding-bottom: var(--wp--preset--spacing--10);
				}

				.is-style-arrow-icon-details summary {
					list-style-type: "\2193\00a0\00a0\00a0";
				}

				.is-style-arrow-icon-details[open]>summary {
					list-style-type: "\2192\00a0\00a0\00a0";
				}',
			)
		);
		register_block_style(
			'core/post-terms',
			array(
				'name'         => 'pill',
				'label'        => __( 'Pill', 'twentytwentyfour' ),
				/*
				 * Styles variation for post terms
				 * https://github.com/WordPress/gutenberg/issues/24956
				 */
				'inline_style' => '
				.is-style-pill a,
				.is-style-pill span:not([class], [data-rich-text-placeholder]) {
					display: inline-block;
					background-color: var(--wp--preset--color--base-2);
					padding: 0.375rem 0.875rem;
					border-radius: var(--wp--preset--spacing--20);
				}

				.is-style-pill a:hover {
					background-color: var(--wp--preset--color--contrast-3);
				}',
			)
		);
		register_block_style(
			'core/list',
			array(
				'name'         => 'checkmark-list',
				'label'        => __( 'Checkmark', 'twentytwentyfour' ),
				/*
				 * Styles for the custom checkmark list block style
				 * https://github.com/WordPress/gutenberg/issues/51480
				 */
				'inline_style' => '
				ul.is-style-checkmark-list {
					list-style-type: "\2713";
				}

				ul.is-style-checkmark-list li {
					padding-inline-start: 1ch;
				}',
			)
		);
		register_block_style(
			'core/navigation-link',
			array(
				'name'         => 'arrow-link',
				'label'        => __( 'With arrow', 'twentytwentyfour' ),
				/*
				 * Styles for the custom arrow nav link block style
				 */
				'inline_style' => '
				.is-style-arrow-link .wp-block-navigation-item__label:after {
					content: "\2197";
					padding-inline-start: 0.25rem;
					vertical-align: middle;
					text-decoration: none;
					display: inline-block;
				}',
			)
		);
		register_block_style(
			'core/heading',
			array(
				'name'         => 'asterisk',
				'label'        => __( 'With asterisk', 'twentytwentyfour' ),
				'inline_style' => "
				.is-style-asterisk:before {
					content: '';
					width: 1.5rem;
					height: 3rem;
					background: var(--wp--preset--color--contrast-2, currentColor);
					clip-path: path('M11.93.684v8.039l5.633-5.633 1.216 1.23-5.66 5.66h8.04v1.737H13.2l5.701 5.701-1.23 1.23-5.742-5.742V21h-1.737v-8.094l-5.77 5.77-1.23-1.217 5.743-5.742H.842V9.98h8.162l-5.701-5.7 1.23-1.231 5.66 5.66V.684h1.737Z');
					display: block;
				}

				/* Hide the asterisk if the heading has no content, to avoid using empty headings to display the asterisk only, which is an A11Y issue */
				.is-style-asterisk:empty:before {
					content: none;
				}

				.is-style-asterisk:-moz-only-whitespace:before {
					content: none;
				}

				.is-style-asterisk.has-text-align-center:before {
					margin: 0 auto;
				}

				.is-style-asterisk.has-text-align-right:before {
					margin-left: auto;
				}

				.rtl .is-style-asterisk.has-text-align-left:before {
					margin-right: auto;
				}",
			)
		);
	}
endif;

add_action( 'init', 'twentytwentyfour_block_styles' );

/**
 * Enqueue block stylesheets.
 */

if ( ! function_exists( 'twentytwentyfour_block_stylesheets' ) ) :
	/**
	 * Enqueue custom block stylesheets
	 *
	 * @since Twenty Twenty-Four 1.0
	 * @return void
	 */
	function twentytwentyfour_block_stylesheets() {
		/**
		 * The wp_enqueue_block_style() function allows us to enqueue a stylesheet
		 * for a specific block. These will only get loaded when the block is rendered
		 * (both in the editor and on the front end), improving performance
		 * and reducing the amount of data requested by visitors.
		 *
		 * See https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/ for more info.
		 */
		wp_enqueue_block_style(
			'core/button',
			array(
				'handle' => 'twentytwentyfour-button-style-outline',
				'src'    => get_parent_theme_file_uri( 'assets/css/button-outline.css' ),
				'ver'    => wp_get_theme( get_template() )->get( 'Version' ),
				'path'   => get_parent_theme_file_path( 'assets/css/button-outline.css' ),
			)
		);
	}
endif;

add_action( 'init', 'twentytwentyfour_block_stylesheets' );

/**
 * Register pattern categories.
 */

if ( ! function_exists( 'twentytwentyfour_pattern_categories' ) ) :
	/**
	 * Register pattern categories
	 *
	 * @since Twenty Twenty-Four 1.0
	 * @return void
	 */
	function twentytwentyfour_pattern_categories() {

		register_block_pattern_category(
			'page',
			array(
				'label'       => _x( 'Pages', 'Block pattern category' ),
				'description' => __( 'A collection of full page layouts.' ),
			)
		);
	}
endif;

add_action( 'init', 'twentytwentyfour_pattern_categories' );
/** Fx to register custom scripts for ROI calculator shortcode */
// function calc_register_scripts() {
// 	//wp_register_script('calc-custom-js', get_stylesheet_directory_uri() . '/assets/js/example.js', array ('jquery', 'jquery-ui'), '1.0.0', true );
// 	wp_register_style('calc-custom-style', get_template_directory_uri() . '/assets/css/custom.css');
// 	wp_register_script('calc-jquery', get_template_directory_uri() .'/assets/js/jquery-3.7.0.min.js', [], false, false);
// 	wp_register_script('calc-custom-js', get_template_directory_uri() .'/assets/js/custom.js', array(), 1, 1, 1);
// }
// add_action( 'wp_enqueue_scripts', 'calc_register_scripts' );
/** Fx for ROI Calculator Functionality and shortcode register */

// function custom_roi_calculator($attr){
// 	wp_enqueue_style('calc-custom-style');
// 	wp_enqueue_script('calc-jquery');
// 	wp_enqueue_script('calc-custom-js');
// 	$args = shortcode_atts( array(
     
// 		'LowYieldRange' => '0.100',
// 		'HighYieldRange' => '0.400',
// 		'LowWasteWaterRange' => '3.0',
// 		'HighWasteWaterRange' => '5.0',
// 		'SolidsRetentionLow' => '0.25',
// 		'SolidsRetentionHigh' => '0.75',
// 		'AvgCWTPriceForMilk' => '20.53'

// 	), $attr, 'roi_calculator' );
// 	$output = '';
// 	$output .= 
// 	'<div class="ever-col-form">
// 	<h3>Adjust your results</h3>
// 	<form id="roiForm">
// 	<input type="hidden" name="LowYieldRange" value="'.$args['LowYieldRange'].'">
// 	<input type="hidden" name="HighYieldRange" value="'.$args['HighYieldRange'].'">
// 	<input type="hidden" name="LowWasteWaterRange" value="'.$args['LowWasteWaterRange'].'">
// 	<input type="hidden" name="HighWasteWaterRange" value="'.$args['HighWasteWaterRange'].'">
// 	<input type="hidden" name="SolidsRetentionLow" value="'.$args['SolidsRetentionLow'].'">
// 	<input type="hidden" name="SolidsRetentionHigh" value="'.$args['SolidsRetentionHigh'].'">
// 	<input type="hidden" name="AvgCWTPriceForMilk" value="'.$args['AvgCWTPriceForMilk'].'">
// 		<div class="ever-form-row">
// 			<div class="ever-form-full-col">
// 				<label>Production Days <span class="tooltip-wrapper"><img src="/wp-content/uploads/2023/12/clarity_info-line.svg"
// 				class="ever-roi-tooltip-icon"><span class="ever-roi-tooltip-popup">Lorem Ipsum is simply </span></label>
// 		<p>Lorem Ipsum is simply dummy text</p>
// 				<input id="ProductionDays" class="ever-roi-input input-field prod-days disallow-decimal-negative" type="number"  onkeydown="javascript: return event.keyCode == 69 ? false : true" name="ProductionDays" placeholder="eg. 365" min="1" >
// 			</div>
// 			<div class="ever-form-full-col">
// 				<label>Average Milk into Lbs Plant per Day <span class="tooltip-wrapper"><img src="/wp-content/uploads/2023/12/clarity_info-line.svg"
// 				class="ever-roi-tooltip-icon"><span class="ever-roi-tooltip-popup">Lorem Ipsum is simply </span></label>
// 				<p>Lorem Ipsum is simply dummy text</p>
// 					<input id="AvgLbsMilkIntoPlant" class="ever-roi-input comma-inputs input-field" type="text" name="AvgLbsMilkIntoPlant" placeholder="eg. 50,000">
// 			</div>
// 			<div class="ever-form-full-col">
// 				<label>Average Sale Price of Finished Goods (in $) <span class="tooltip-wrapper"><img src="/wp-content/uploads/2023/12/clarity_info-line.svg"
// 				class="ever-roi-tooltip-icon"><span class="ever-roi-tooltip-popup">Lorem Ipsum is simply </span></label>
// 				<p>Lorem Ipsum is simply dummy text</p>
// 				<input id="AvgSalePriceOfFinishedGoods" class="ever-roi-input comma-inputs input-field" type="text" name="AvgSalePriceOfFinishedGoods" placeholder="eg. 5,000">
// 			</div>							
// 			<div class="ever-form-full-col">
// 				<label>Average Waste Water Monthly Bill (in $) <span class="tooltip-wrapper"><img src="/wp-content/uploads/2023/12/clarity_info-line.svg"
// 				class="ever-roi-tooltip-icon"><span class="ever-roi-tooltip-popup">Lorem Ipsum is simply </span></label>
// 				<p>Lorem Ipsum is simply dummy text</p>
// 				<input id="AvgMonthlyWasteWaterBill" class="ever-roi-input comma-inputs input-field" type="text" name="AvgMonthlyWasteWaterBill" placeholder="eg. 50,000">
// 			</div>
// 			<div class="ever-form-full-col">
// 				<label>Current Shrink per MA Reports (in %) <span class="tooltip-wrapper"><img src="/wp-content/uploads/2023/12/clarity_info-line.svg"
// 				class="ever-roi-tooltip-icon"><span class="ever-roi-tooltip-popup">Lorem Ipsum is simply </span></label>
// 				<p>Lorem Ipsum is simply dummy text</p>
// 				<input id="CurrentShrink" class="ever-roi-input input-field disallow-negative" type="number"  onkeydown="javascript: return event.keyCode == 69 ? false : true" name="CurrentShrink" placeholder="eg. 10" min="1">
// 			</div>
// 			<div class="ever-form-full-col">
// 				<button class="ever-fill-btn" type="button">Calculate</button>				
// 			</div>
// 		</div>
// 		<div class="ever-cal-result-wrapper">
// 			<h4>Your Result</h4>
// 			<ul>
				
// 				<li>
// 					<h5 id="lowRoi">($1.6 M)</h5>
// 					<p>Low ROI</p>
// 				</li>
// 				<li id="avgValue" class="mid-roi-value">
// 					<p>3M</p>
// 				</li>
// 				<li>
// 					<h5 id="highRoi">($6 M)</h5>
// 					<p>High ROI</p>
// 				</li>
// 			</ul>
// 		</div>
// 	</form>
// </div>
// 	<!--end form calculator section-->';
// 	  return $output;
// }
// add_shortcode('roi_calculator', 'custom_roi_calculator'); 

// Allow SVG media upload
add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype($filename, $mimes);
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
}, 10, 4);

function cc_mime_types($mimes)
{
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');