<?php

function load_stylesheets()
{
    wp_enqueue_style('bootstrap', get_template_directory_uri() . "/assets/css/bootstrap.min.css");
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . "/assets/css/owl.carousel.min.css");
   
    wp_enqueue_style('theme', get_template_directory_uri() . "/assets/css/owl.theme.default.min.css");
    wp_enqueue_style('perry', get_template_directory_uri() . "/assets/css/perry-weather.css");
    wp_enqueue_style('custom-style', get_template_directory_uri() . "/assets/css/custom-style.css", array(), time());
    wp_enqueue_style('style', get_template_directory_uri() . "/assets/css/style.css", array(), time());
 
    wp_enqueue_style('custom-style-slider', get_template_directory_uri() . "/assets/css/custom-style-slider.css", array(), time());
    wp_enqueue_style('responsive', get_template_directory_uri() . "/assets/css/responsive.css", array(), time());
}   

add_action('wp_enqueue_scripts', 'load_stylesheets');

function addjs()
{
    // Enqueue jQuery first
    wp_enqueue_script('jquery', get_template_directory_uri() . "/assets/js/jquery.min.js", array(), '3.6.0', true);

    // Enqueue Owl Carousel JS after jQuery
    wp_enqueue_script('perry js', get_template_directory_uri() . "/assets/js/perry-weather.js", array('jquery'), '2.3.8', true);
    wp_enqueue_script('owl-carousel-js', get_template_directory_uri() . "/assets/js/owl.carousel.min.js", array('jquery'), '2.3.4', true);
    wp_enqueue_script('fav-js', get_template_directory_uri() . "/assets/js/fav.js", array('jquery'), '2.3.4', true);
  
    // Enqueue other scripts dependent on jQuery
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_script('custom-js', get_template_directory_uri() . "/assets/js/script.js", array('jquery'), time(), true);
}

add_action('wp_enqueue_scripts', 'addjs');
function register_menu()
{
  register_nav_menus(
    array(
      'primary-menu' => 'Primary Menu',
      'footer-menu' => 'Footer Menu'

    )
  );
}
add_action("init", "register_menu");


//add Theme setting link in wordpress end

if (function_exists('acf_add_options_page')) {
	acf_add_options_page(array(
	  'page_title'  => 'Theme General Settings',
	  'menu_title'  => 'Theme Settings',
	  'menu_slug'   => 'theme-general-settings',
	  'capability'  => 'edit_posts',
	  'redirect'    => false
	));
	acf_add_options_sub_page(array(
	  'page_title'  => 'Theme Header Settings',
	  'menu_title'  => 'Header',
	  'parent_slug' => 'theme-general-settings',
	));
	acf_add_options_sub_page(array(
	  'page_title'  => 'Theme Footer Settings',
	  'menu_title'  => 'Footer',
	  'parent_slug' => 'theme-general-settings',
	));
  }
  //add Theme setting link in wordpress end



// adding new features to wordpress theme
function fn_theme_supports()
{
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
  add_theme_support('html5', array('search-form'));
  add_theme_support('custom-logo');
}
add_action('after_setup_theme', 'fn_theme_supports');

//register naviagation menu_slug
function fn_nav_menu()
{
  register_nav_menus(array(
    'primary-menu' => __('Primary Menu', 'text_domain'),
    'footer-menu' => __('Footer Menu', 'text_domain')
  ));
}
add_action('init', 'fn_nav_menu');

//add class to anchor and list for header start
add_filter( 'nav_menu_link_attributes', function($atts) {
	$atts['class'] = "nav-link";
	return $atts;
}, 100, 1 );
add_filter( 'nav_menu_css_class', function($classes) {
    $classes[] = 'nav-item';
    return $classes;
}, 10, 1 );
//add class to anchor and list for header end


function cc_mime_types($mimes)
{
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');
function fix_svg()
{
  echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
}
add_action('admin_head', 'fix_svg');
// Allow SVG code end
