<?php

/**
 * Template Name: Home page
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
  <!-- banner starts -->
  <section class="banner-section-slider" style="background-image: url(<?php echo $field['banner_bg_image']['url'] ?>);">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-12">
                    <div class="slider-content">
                    <?php if (isset($field['banner_heading']) && !empty($field['banner_heading'])) : ?>
                        <h1><?php echo $field['banner_heading'] ?></h1>
                        <?php endif ?>
                        <?php if (isset($field['banner_desc']) && !empty($field['banner_desc'])) : ?>
                        <?php echo $field['banner_desc'] ?>
                        <?php endif ?>
                        <?php if (isset($field['banner_button']['url']) && !empty($field['banner_button']['url'])) : ?>
                        <a href="<?php echo $field['banner_button']['url'] ?>" class="custom-btn" ><?php echo $field['banner_button']['title'] ?></a>
                        <?php endif ?>
                        <div class="client-images-slider">
                            <div class="owl-carousel owl-theme" id="custom-client-images-slider">
                            <?php foreach ($field['slider_icons'] as  $slider_icon) : ?>
                                <?php if (isset($slider_icon['slider_icon']['url']) && !empty($slider_icon['slider_icon']['url'])) : ?>
                                <div class="item"><figure><img src="<?php echo $slider_icon['slider_icon']['url'] ?>" alt="<?php echo $slider_icon['slider_icon']['alt'] ?>"></figure></div>
                                <?php endif ?>
                                <?php endforeach ?>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="col-lg-6 col-md-6 col-12">
                <div class="eyelit-video">
                    <video  autoplay muted loop>
                    <?php if (isset($field['banner_video']['url']) && !empty($field['banner_video']['url'])) : ?>
                        <source src="<?php echo $field['banner_video']['url'] ?>" type="video/mp4">
                        <?php endif ?>
                    </video>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="creative-outer">
    <div class="container">
        <div class="row">
        <?php foreach ($field['left_right_content'] as  $left_right_content) : ?>
            <div class="outer">
                <div class="left-text">
                    <h2><?php echo $left_right_content['left_right_heading'] ?></h2>
                    <p><?php echo $left_right_content['left_right_subheading'] ?></p>
                    <div class="eyelit-points">
                    <?php echo $left_right_content['left_right_desc'] ?>
                    <?php if (isset($left_right_content['left_right_button']['url']) && !empty($left_right_content['left_right_button']['url'])) : ?>
                        <div class="cta-btn">
                            <a href="<?php echo $left_right_content['left_right_button']['url'] ?>" class="custom-btn" ><?php echo $left_right_content['left_right_button']['title'] ?></a>
                        </div>
                        <?php endif ?> 
                    </div>
                </div>
                <div class="dashboard-image">
                <?php if (isset($left_right_content['left_right_image']['url']) && !empty($left_right_content['left_right_image']['url'])) : ?>  
                    <img src="<?php echo $left_right_content['left_right_image']['url'] ?>" alt="<?php echo $left_right_content['left_right_image']['alt'] ?>">
                    <?php endif ?> 
                </div>
            </div>
            <?php endforeach ?> 
        </div>
    </div>
</section>
<section class="industry-support">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-md-6 col-12">
                <div class="specific-supprt" style="background-image: url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png);">
                    <div class="industry-content">
                        <div class="col-sm-7">
                            <h2>Precision Industry-Specific Support</h2>
                            <p>Lorem ipsum dolor sit amet jamet, consectetur adipis cing </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="small-box blue-shade" style="background-image:url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/aerospace.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Aerospace & Defense</h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="small-box brown-shade" style="background-image:url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/battery.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Battery <br>Technology</h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="small-box blue-shade" style="background-image:url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/electronics.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Electronics</h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="small-box brown-shade" style="background-image:url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/medical-device.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Medical<br> Device</h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="small-box blue-shade" style="background-image:url(http://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/semi-conductor.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Semi-<br>Conductor</h4>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-md-6 col-12">
                <div class="small-box brown-shade" style="background-image:urlhttp://localhost/git/eyelit/wp-content/uploads/2024/02/bg-support.png) ;">
                    <div class="box-icon">
                        <img src="assets/images/solar-energy.png" alt="aerospace">
                    </div>
                    <div class="box-content">
                        <h4>Solar Energy</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="ready-optimization">
    <div class="container">
        <div class="optimization-content">
          <div class="optimization-content-heading">
              <h2>Ready to optimize your manufacturing process?</h2>
              <p> Book a walkthrough to see how Eyelit can streamline your operations and enhance efficiency with innovative solutions.</p>
          </div>
              <div class="book-btn">
                  <a href="#" class="custom-btn">Get in Touch</a>
              </div>
        </div>
    </div>
</div>
  <!-- HTML !-->
  <section class="what-we-do">
    <div class="animation-accordion">
      <div class="authoring-conversations">
          <div class="container">
              <div class="c-feature-ticker c-feature-ticker--dark js-fade-in js-feature-ticker "
                  id="block_6232555f25c86">
                  <div class="o-container">
                      <div class="c-feature-ticker__wrap">
                          <div class="c-feature-ticker__text-wrap">
                            <h2>What we do?</h2>
                              <div class="c-feature-ticker__list js-feature-ticker-list">
                                  <div class="c-feature-ticker__item js-fade-in-item c-feature-ticker__item-0 js-feature-ticker-item u-fade-out u-fade-in c-feature-ticker__item--active"
                                      data-item-image-url="http://localhost/git/eyelit/wp-content/uploads/2024/02/Image-auto.png">
                                      <h3 class="js-feature-ticker-item-trigger">
                                        Heading 1</h3>
                                      <p class="c-feature-ticker__item-headline js-feature-ticker-item-trigger">
                                        Eyelit® v7.0 software offers a comprehensive and collaborative manufacturing solution to enhance multiple facets of the production process – from optimizing manufacturing execution and streamlining supply chain coordination to maximizing asset utilization and ensuring top-notch quality management.</p>
                                      <a class="custom-link-animation" href="#"
                                          target="_self">Know More</a>
                                      <div class="c-feature-ticker__item-content js-feature-ticker-item-content">

                                          <img decoding="async"
                                              class="c-feature-ticker__image c-feature-ticker__image--inline o-image"
                                              src="http://localhost/git/eyelit/wp-content/uploads/2024/02/Image-auto.png"
                                              alt="revenue-analytics (1)" width="969" height="547" loading="lazy" style="transform: translateX(0px); opacity: 1;">

                                      </div>
                                  </div>
                                  <div class="c-feature-ticker__item js-fade-in-item c-feature-ticker__item-0 js-feature-ticker-item u-fade-out u-fade-in"
                                      data-item-image-url="http://localhost/git/eyelit/wp-content/uploads/2024/02/slide-image.png">
                                      <h3 class="js-feature-ticker-item-trigger">
                                        Eyelit® v7.0’s Solution Suite - Tailored to Support and Advance Industry 4.0 Initiatives</h3>
                                      <p class="c-feature-ticker__item-headline js-feature-ticker-item-trigger">
                                        All the applications in our solution suite are designed and developed natively by Eyelit on a single technology architecture.In contrast, many other Manufacturing Execution System (MES) options are a mix of products made by different software companies, using different technologies.</p>
                                      <a class="custom-link-animation"
                                          href="#" target="_self"></a>
                                      <div class="c-feature-ticker__item-content js-feature-ticker-item-content"
                                          style="height: 0px;">

                                          <img decoding="async"
                                              class="c-feature-ticker__image c-feature-ticker__image--inline o-image"
                                              src="http://localhost/git/eyelit/wp-content/uploads/2024/02/slide-image.png"
                                              alt="ROI-Reporting-Made-Easy-1" width="969" height="547"
                                              loading="lazy">

                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div class="c-feature-ticker__image-wrap js-fade-in-item u-fade-out u-fade-in"
                              style="transition-delay: 0.3s;">

                              <img decoding="async"
                                  class="c-feature-ticker__image c-feature-ticker__image--left js-feature-ticker-image o-image o-image--hang-left"
                                  src="http://localhost/git/eyelit/wp-content/uploads/2024/02/Image-auto.png"
                                  alt="Actionable Revenue Analytics" width="969" height="547" loading="lazy"
                                  style="transform: translateX(0); opacity: 1;">

                          </div>
                      </div>
                      <script class="js-feature-ticker-duration" type="application/json">
                          6000
                      </script>
                  </div>
              </div>
          </div>
      </div>
    </div>
  </section>





  <Section class="happy-customers">
     <div class="container">
        <div class="happy-customers-content">
            <div class="happy-customers-heading">
                <h2>Happy Customers</h2>
                <p>Don't just take our word for it - see what actual users of our service have to say about their experience.</p>
            </div>
            <div class="customer-slider owl-carousel">
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="customer-review">
                        <p>“I've been using this web hosting service for over a year and I'm really impressed with the uptime and support. The website has never gone down and the customer service is always quick to help with any issues I have. Highly recommend!”</p>
                    </div>
                    <div class="rating-stars">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </div>
                    <div class="customer-info">
                        <div class="imgblk">
                            <img src="http://localhost/git/eyelit/wp-content/uploads/2024/02/customer-img.png" alt="" srcset="">
                        </div>
                        <div class="customer-detail">
                            <h4>Jane Smith</h4>
                            <p>Freelance Designer</p>
                        </div>
                    </div>
                </div>
          </div>
        </div>
     </div>
  </Section>
  <?php get_template_part('/common/cta', 'section', $themeData); ?>

	<?php get_footer(); ?>