<?php

/**
 * Template Name: Pricing
 *
 * @package wordpress
 * @since April 2021
 */
get_header();
$field = get_fields();
$themeData = get_fields('options');
?>
<?php get_template_part('/common/banner', 'section', $field); ?>
<section class="one-shop">
    <div class="container">
        <div class="one-shop-content">
            <?php if (isset($field['pricing_heading']) && !empty($field['pricing_heading'])) : ?>
                <h1><?php echo $field['pricing_heading'] ?></h1>
                <?php echo $field['pricing_subheading'] ?>
            <?php endif; ?>

        </div>
    </div>
</section>
<?php foreach ($field['services'] as  $services) : ?>
    <section class="<?php if (isset($services['background_color']) && !empty($services['background_color'])) :
                        echo 'offwhite-color';
                    else :
                        echo '';
                    endif; ?> custom-pricing">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-heading text-center">
                        <?php if (isset($services['services_heading']) && !empty($services['services_heading'])) : ?>
                            <h2 class="custom-sb-heading"><?php echo $services['services_heading'] ?></h2>
                        <?php endif; ?>
                        <?php echo $services['services_subheading'] ?>
                    </div>
                </div>
                <div class="pricing-outer row">
                    <?php foreach ($services['pricing_packs'] as  $packs) : ?>
                        <div class="col-md-4">
                            <div class="pricing-box">
                                <?php if (isset($packs['pack_heading']) && !empty($packs['pack_heading'])) : ?>
                                    <h4 class="version"><?php echo $packs['pack_heading'] ?></h4>
                                <?php endif; ?>
                                <p class="start-top">Starting at</p>
                                <?php if (isset($packs['pack_pricing']) && !empty($packs['pack_pricing'])) : ?>
                                    <h2 class="main-price"><?php echo $packs['pack_pricing'] ?></h2>
                                <?php endif; ?>
                                <?php if (isset($packs['pack_subheading']) && !empty($packs['pack_subheading'])) : ?>
                                    <p><?php echo $packs['pack_subheading'] ?></p>
                                <?php endif; ?>
                                <div class="price-points">
                                    <?php echo $packs['pack_description']   ?>
                                    <?php if (isset($packs['pack_link']['url']) && !empty($packs['pack_link']['url'])) : ?>
                                        <a href="<?php echo $packs['pack_link']['url'] ?>" target="<?php echo $packs['pack_link']['target'] ?>" class="orange-btn"><?php echo $packs['pack_link']['title'] ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                       
                        </div>
                        <?php endforeach ?>
                </div>
            </div>
    </section>
<?php endforeach; ?>

<?php get_template_part('/common/client-logos', 'section', $themeData); ?>

<?php get_template_part('/common/who-we-serve', 'section', $themeData); ?>
<?php get_template_part('/common/testimonial', 'section', $themeData); ?>
<?php get_template_part('/common/why-us', 'section', [
    'field' => $field,
    'theme_data' => $themeData,
]); ?>

<?php get_template_part('/common/have-question', 'section', $themeData); ?>
<?php get_template_part('/common/latest-blog', 'section', $themeData); ?>


<?php get_template_part('/common/form', 'section', $themeData); ?>
<?php get_footer(); ?>