<?php $footerOptions = get_fields( 'options' ); ?>
<footer class="fr-spacing-top">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="fr-footer-first-col">
                    <?php if (isset($footerOptions['footer_logo']) && !empty($footerOptions['footer_logo'])) : ?>
                        <a href="<?php echo site_url();?>" class="footer-logo">
                            <img src="<?php echo $footerOptions['footer_logo']['url'];?>" alt="<?php echo $footerOptions['footer_logo']['alt'];?>">
                        </a>
                    <?php endif; ?>
                        <?php if (isset($footerOptions['footer_description']) && !empty($footerOptions['footer_description'])) : ?>
                        <p><?php echo $footerOptions['footer_description'];?></p>
                        <?php endif; ?>
                        <?php if (isset($footerOptions['footer_social_heading']) && !empty($footerOptions['footer_social_heading'])) : ?>
                        <h4><?php echo $footerOptions['footer_social_heading'];?></h4>
                        <?php endif; ?>
                        <div class="fr-social-links">
                        <?php $socialRep = $footerOptions['social'];?>
                        <?php foreach(($socialRep ? $socialRep : array()) as $socialInfo ) : ?>
                            <a href="<?php echo !empty( $socialInfo['social_url'] ) ? $socialInfo['social_url'] : '#0' ?>" target="_blank">
                                <img src="<?php echo $socialInfo['social_icon']['url'];?>" alt="<?php echo $socialInfo['social_icon']['alt'];?>">
                            </a>
                        <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="fr-footer-second-col">
                        <?php if (isset($footerOptions['column_1_heading']) && !empty($footerOptions['column_1_heading'])) : ?>
                        <h4><?php echo $footerOptions['column_1_heading'];?></h4>
                        <?php endif; ?>
                        <ul class="fr-footer-link">
                        <?php $colInfo1 = $footerOptions['column_1_list'];?>
                        <?php foreach(($colInfo1 ? $colInfo1 : array()) as $colItem1 ) : ?>
                            <li>
                                <a href="<?php echo !empty( $colItem1['item_link']['url'] ) ? $colItem1['item_link']['url'] : '#0' ?>" target="<?php echo !empty( $colItem1['item_link']['target'] ) ? $colItem1['item_link']['target'] : '_self' ?>">
                                    <?php echo $colItem1['item_name'] ?? null;?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="fr-footer-second-col">
                        <?php if (isset($footerOptions['contact_us_heading']) && !empty($footerOptions['contact_us_heading'])) : ?>
                        <h4><?php echo $footerOptions['contact_us_heading'];?></h4>
                        <?php endif; ?>
                        <ul class="fr-footer-link">
                        <?php if (isset($footerOptions['phone_no']) && !empty($footerOptions['phone_no'])) : ?>
                            <li><a href="tel:<?php echo preg_replace('/^0|[^a-zA-Z0-9+]+/', '', $footerOptions['phone_no']); ?>"><?php echo $footerOptions['phone_no']; ?></a></li>
                        <?php endif; ?>
                        <?php if (isset($footerOptions['contact_email']) && !empty($footerOptions['contact_email'])) : ?>
                            <li><a href="mailto:<?php echo $footerOptions['contact_email']; ?>"><?php echo $footerOptions['contact_email']; ?></a></li>
                        <?php endif; ?>
                        <?php if (isset($footerOptions['address']) && !empty($footerOptions['address'])) : ?>
                            <li><?php echo $footerOptions['address']; ?></li>
                        <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <?php if (isset($footerOptions['copyright']) && !empty($footerOptions['copyright'])) : ?>
                <div class="text-center fr-copyright">
                    <!-- <p><?php //echo date("Y").' '.$footerOptions['copyright'];?></p> -->
                    <p><?php echo $footerOptions['copyright'];?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </footer>
<?php wp_footer(); ?>
</body>
</html>