<?php

/**
 *Template Name: Home Page
 */
get_header(); 
$HomeData = get_fields(); 
$ThemeOptions = get_fields('options'); ?>
<!--- Banner section--->
<?php $bannerData = $HomeData['hero_banner'] ?? null;
if (isset($bannerData) && is_array($bannerData)) : ?>
<section class="fr-hero-banner fr-Home-banner" <?php echo isset($bannerData['background_image']) &&  !empty( $bannerData['background_image'] ) ? "style='background-image: url(" . $bannerData['background_image']['url'] . ")'" : "" ?>>
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-md-6">
                <div class="fr-home-banner-content">
                    <?php if (isset($bannerData['heading']) && !empty($bannerData['heading'])) : ?>
                    <h1><?php echo $bannerData['heading']; ?></h1>
                    <?php endif; ?>
                    <?php if (isset($bannerData['description']) && !empty($bannerData['description'])) : ?>
                        <?php echo $bannerData['description']; ?>
                    <?php endif; ?>
                    <?php $btnLabel = $bannerData['button_label'] ?? null;
                    if (isset($btnLabel) && !empty($btnLabel)) : ?>
                        <a href="<?php echo !empty($bannerData['button_link']['url']) ? $bannerData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($bannerData['button_link']['target']) ? $bannerData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $btnLabel; ?>" class="fr-btn"><span><?php echo $btnLabel; ?></span></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="fr-banner-slider slider text-end">
                <?php foreach( ($bannerData['slider_repeater'] ? $bannerData['slider_repeater'] : array()) as $slideOption ) : ?>
                    <?php if (isset($slideOption['slide_image']) && !empty($slideOption['slide_image'])) : ?>
                    <div class="fr-slider-item">
                        <img src="<?php echo $slideOption['slide_image']['url']; ?>" alt="<?php echo $slideOption['slide_image']['alt']; ?>">
                    </div>
                    <?php endif; ?>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--- End Banner section--->
<?php endif; ?>
<?php $formSectionData = $HomeData['form_with_data'] ?? null;
if (isset($formSectionData) && is_array($formSectionData)) : ?>
<!--- Join five river--->
    <?php include(get_template_directory() . '/includes/form-with-data.php'); ?>
<!--- End Join five river--->
<?php endif; ?>
<?php $gridSliderData = $HomeData['grid_card_slider'] ?? null;
if (isset($gridSliderData) && is_array($gridSliderData)) : ?>
    <!---Mutual section--->
    <?php include(get_template_directory() . '/includes/grid-cards-slider.php'); ?>
    <!---End Mutual section--->
<?php endif; ?>
<?php $videosData = $HomeData['videos_section'] ?? null;
if (isset($videosData) && is_array($videosData)) : ?>
<!--- Videos section--->
<section class="fr-video-section fr-section-extra-spacing">
    <div class="container">
        <div class="row">
        <?php if (isset($videosData['heading']) && !empty($videosData['heading'])) : ?>
            <h2 class="text-center"><?php echo $videosData['heading']; ?></h2>
        <?php endif; ?>
        <?php foreach( ($videosData['videos_repeater'] ? $videosData['videos_repeater'] : array()) as $VideoItem ) : ?>
            <div class="col-md-4">
                <div class="fr-video-div">
                <?php if (isset($VideoItem['video_url']) && !empty($VideoItem['video_url'])) : ?>
                    <iframe src="<?php echo $VideoItem['video_url']; ?>"
                        title="YouTube video player" frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        allowfullscreen></iframe>
                <?php endif; ?>
                <?php if (isset($VideoItem['video_text']) && !empty($VideoItem['video_text'])) : ?>
                    <?php echo $VideoItem['video_text']; ?>
                <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
        <?php $videoBtnLabel = $videosData['button_label'] ?? null;
        if (isset($videoBtnLabel) && !empty($videoBtnLabel)) : ?>
            <div class="fr-video-button text-center">
                <a href="<?php echo !empty($videosData['button_link']['url']) ? $videosData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($videosData['button_link']['target']) ? $videosData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $videoBtnLabel; ?>" class="fr-btn"><span><?php echo $videoBtnLabel; ?></span></a>
            </div>
        <?php endif; ?>
        </div>
    </div>
</section>
<!--- End Videos section--->
<?php endif; ?>
<?php $aboutData = $HomeData['about_image_with_text'] ?? null;
if (isset($aboutData) && is_array($aboutData)) : ?>
<!-- About five river-->
<Section class="fr-join-river fr-section-extra-spacing fr-about-section">
    <div class="container">
        <?php if (isset($aboutData['heading']) && !empty($aboutData['heading'])) : ?>
        <h2 class="text-center"><?php echo $aboutData['heading']; ?></h2>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-7">
            <?php if (isset($aboutData['description']) && !empty($aboutData['description'])) : ?>
                <div class="fr-join-river-content">
                    <?php echo $aboutData['description']; ?>
                <?php $aboutBtnLabel = $aboutData['button_label'] ?? null;
                if (isset($aboutBtnLabel) && !empty($aboutBtnLabel)) : ?>
                    <a href="<?php echo !empty($aboutData['button_link']['url']) ? $aboutData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($aboutData['button_link']['target']) ? $aboutData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $aboutBtnLabel; ?>" class="fr-btn"><span><?php echo $aboutBtnLabel; ?></span></a>
                <?php endif; ?>
                </div>
            <?php endif; ?>
            </div>
            <div class="col-md-5">
            <?php if (isset($aboutData['image']) && !empty($aboutData['image'])) : ?>
                <div class="fr-join-river-img text-start">
                    <img src="<?php echo $aboutData['image']['url']; ?>" alt="<?php echo $aboutData['image']['alt']; ?>">
                </div>
            <?php endif; ?>
            </div>
        </div>
    </div>
</Section>
<!-- End About five river-->
<?php endif; ?>
<?php $galleryData = $HomeData['our_gallery'] ?? null;
if (isset($galleryData) && is_array($galleryData)) : ?>
<!-- Our Gallery-->
<section class="fr-our-gallery fr-section-extra-spacing">
    <div class="container">
        <?php if (isset($galleryData['heading']) && !empty($galleryData['heading'])) : ?>
        <h2 class="text-center"><?php echo $galleryData['heading']; ?></h2>
        <?php endif; ?>
        <div class="row d-flex align-items-center">
            <div class="col-md-6">
                <div class="fr-join-river-content">
                <?php if (isset($galleryData['description']) && !empty($galleryData['description'])) : ?>
                    <?php echo $galleryData['description']; ?>
                <?php endif; ?>
                <?php $galleryBtnLabel = $galleryData['button_label'] ?? null;
                if (isset($galleryBtnLabel) && !empty($galleryBtnLabel)) : ?>
                    <a href="<?php echo !empty($galleryData['button_link']['url']) ? $galleryData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($galleryData['button_link']['target']) ? $galleryData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $galleryBtnLabel; ?>" class="fr-btn"><span><?php echo $galleryBtnLabel; ?></span></a>
                <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="fr-our-gallery-img">
                <?php if (isset($galleryData['gallery_image_one']) && !empty($galleryData['gallery_image_one'])) : ?>
                    <img class="fr-gallery-first" src="<?php echo $galleryData['gallery_image_one']['url']; ?>" alt="<?php echo $galleryData['gallery_image_one']['alt']; ?>">
                <?php endif; ?>
                <?php if (isset($galleryData['gallery_image_two']) && !empty($galleryData['gallery_image_two'])) : ?>
                    <img class="fr-gallery-second" src="<?php echo $galleryData['gallery_image_two']['url']; ?>" alt="<?php echo $galleryData['gallery_image_two']['alt']; ?>">
                <?php endif; ?>
                <?php if (isset($galleryData['gallery_image_three']) && !empty($galleryData['gallery_image_three'])) : ?>
                    <img class="fr-gallery-third" src="<?php echo $galleryData['gallery_image_three']['url']; ?>" alt="<?php echo $galleryData['gallery_image_three']['alt']; ?>">
                <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End our gallery-->
<?php endif; ?>
<?php $newsletterData = $HomeData['newsletter'] ?? null;
if (isset($newsletterData) && is_array($newsletterData)) : ?>
<!-- Newsletter-->
<section class="fr-newsletter">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-md-7">
            <?php if (isset($newsletterData['image']) && !empty($newsletterData['image'])) : ?>
                <div class="fr-newsletter-img">
                    <img src="<?php echo $newsletterData['image']['url']; ?>" alt="<?php echo $newsletterData['image']['alt']; ?>">
                </div>
            <?php endif; ?>
            </div>
            <div class="col-md-5">
                <div class="fr-newsletter-content">
                    <?php if (isset($newsletterData['heading']) && !empty($newsletterData['heading'])) : ?>
                    <h3><?php echo $newsletterData['heading']; ?></h3>
                    <?php endif; ?>
                    <?php if (isset($newsletterData['sub_heading']) && !empty($newsletterData['sub_heading'])) : ?>
                    <?php echo $newsletterData['sub_heading']; ?>
                    <?php endif; ?>
                    <?php  if (!empty($newsletterData['form_shortcode'])): ?>
                        <?php $newsletterShortcode = isset($newsletterData['form_shortcode']) ? do_shortcode($newsletterData['form_shortcode']) : ""; ?>
                        <?php echo $newsletterShortcode; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Newsletter-->
<?php endif; ?>
<?php
get_footer();
?>