<?php

function enqueue_parent_styles()
{
	wp_register_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
	wp_enqueue_style('bootstrap');
	wp_register_style('slick-slider', get_template_directory_uri() . '/assets/css/slick.css');
	wp_enqueue_style('slick-slider');
	wp_register_style('slick-lightbox', get_template_directory_uri() . '/assets/css/slick-lightbox.css');
	wp_enqueue_style('slick-lightbox');
	wp_register_style('style', get_template_directory_uri() . '/assets/css/style.css');
	wp_enqueue_style('style');
}
add_action('wp_enqueue_scripts', 'enqueue_parent_styles');

function load_js()
{
	wp_register_script('jquery', get_template_directory_uri() . '/assets/src/js/jquery-3.7.0.min.js', array(), 1, 1, 1);
	wp_enqueue_script('jquery');
	wp_enqueue_script('popper');
	wp_register_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), 1, 1, 1);
	wp_enqueue_script('bootstrap');
	wp_register_script('slick-slider', get_template_directory_uri() . '/assets/js/slick.js', array(), 1, 1, 1);
	wp_enqueue_script('slick-slider');
	wp_register_script('slick-lightbox', get_template_directory_uri() . '/assets/js/slick-lightbox.min.js', array(), 1, 1, 1);
	wp_enqueue_script('slick-lightbox');
	wp_register_script('custom', get_template_directory_uri() . '/assets/js/custom.js', array(), 1, 1, 1);
	wp_enqueue_script('custom');
}

add_action('wp_enqueue_scripts', 'load_js');
// To register Case studies CPT


add_theme_support('post-thumbnails');
// For displaying site logo option in customizer
function config_custom_logo()
{
	add_theme_support('custom-logo');
}
add_action('after_setup_theme', 'config_custom_logo');
//for options page
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init()
{
	// Check function exists.
	if (function_exists('acf_add_options_sub_page')) {
		// Add parent.
		$parent = acf_add_options_page(array(
			'page_title' => __('Theme General Settings'),
			'menu_title' => __('Theme Settings'),
			'menu_slug'  => __('theme-settings'),
			'redirect'   => false,
		));
	}
}

//for custom menues
function wpb_custom_new_menu()
{
	register_nav_menus(
		array(
			'fiverivers-menu' => __('Header Menu')
		)
	);
}
add_action('init', 'wpb_custom_new_menu');

/** Fx to add json file in media */
function add_upload_mimes($types)
{
	$types['json'] = 'text/plain';
	return $types;
}
add_filter('upload_mimes', 'add_upload_mimes');


// Allow SVG media upload
add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype($filename, $mimes);
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
}, 10, 4);

function cc_mime_types($mimes)
{
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

/** Fx to call desired menu  */
function prefix_get_menu_items($menu_name)
{
	if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
		$menu = wp_get_nav_menu_object($locations[$menu_name]);
		return wp_get_nav_menu_items($menu->term_id);
	}
}

// adding new features to wordpress theme
function fn_theme_supports() {
	add_theme_support( 'title-tag' );
}

add_action( 'after_setup_theme', 'fn_theme_supports' );

?>