<?php

/**
 * The template for displaying single posts and pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 */
get_header();
$articleField = get_fields();
$page_url = get_permalink(get_the_ID());
$blogOptions = get_fields('options');
?>

<main id="site-content" role="main">

	<?php
	if (have_posts()) {

		while (have_posts()) {
			the_post();
			$postID     = get_the_id();
			$postTitle  = get_the_title($postID);
			$thumbnail  = get_the_post_thumbnail();
			$categories = get_the_category($postID);
			$date       = get_the_date('M j, Y', $postID);
			$author     = get_the_author($postID);
			$cat_array  = array();
			foreach ($categories as $category) {
				$cat_array[] = $category->slug;
			}
		}
	}
	?>
	<!-- Blog detail starts -->
 <!-- Fetaure image-->
 <section class="fr-blog-detail fr-spacing-top">
        <div class="container">
            <h1 class="text-center"><?php echo $postTitle; ?></h1>
            <?php if (!empty($thumbnail)) :
                echo $thumbnail; ?>
            <?php endif; ?>
            <ul>
			<li class="Publish-date"><?php echo $blogOptions['published_on_label'] ?? null; ?><?php echo $date; ?></li>
            <li class="author-name"><?php echo $blogOptions['author_label'] ?? null; ?><?php echo $author; ?> </li>
            </ul>
        </div>
    </section>
<!-- blog description-->
<section class="fr-blog-description">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
					<?php echo get_the_content(); ?>
                </div>
            </div>
        </div>
    </section>
	<?php
			wp_reset_postdata();
			?>
    <!-- End blog description-->
	
<!-- blog related post-->
<section class="fr-related-post">
        <div class="container">
            <div class="row fr-section-extra-spacing fr-related-post-row">
				<?php if (isset($blogOptions['related_posts_heading']) && !empty($blogOptions['related_posts_heading'])) : ?>
                <h2 class="text-center"><?php echo $blogOptions['related_posts_heading']; ?></h2>
                <?php endif; ?>
				<!-- loop -->
				<?php
			$args = array(
				'post_type'      => get_post_type(),
				'post_status'    => 'publish',
				'posts_per_page' => 3,
				'orderby'        => 'date',
                'category_name' => 'blogs',
				'post__not_in' => array(get_the_ID()),
			);
			
			$the_query = new WP_Query($args);
			if ($the_query->have_posts()) :
				while ($the_query->have_posts()) :
					$the_query->the_post();
					$postId     = get_the_id();
					$relPostTitle  = get_the_title($postId);
					$relThumbnail  = get_the_post_thumbnail_url($postId, 'medium_large');
					$relCategories = get_the_category($postId);
					$relExcerpt    = get_the_excerpt($postId);
					$relDate       = get_the_date('M j, Y', $postId);
					$relAuthor     = get_the_author($postId); ?>
                <div class="col-md-4">
                    <div class="fr-blog-card">
					<?php if (!empty($relThumbnail)) : ?>
							<img alt="<?php echo get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true); ?>" class="fr-blog-img" src="<?php echo $relThumbnail; ?>">
							<?php endif; ?>
                        <ul>
						<li class="Publish-date"><?php echo $blogOptions['published_on_label'] ?? null; ?><?php echo $relDate; ?></li>
                            <li class="author-name"><?php echo $blogOptions['author_label'] ?? null; ?><?php echo $relAuthor; ?> </li>
                        </ul>
                        <h5><?= esc_html(get_the_title()); ?></h5>
                    </div>
                </div>
                <?php
				endwhile;
			endif;
			?>
            </div>
        </div>
    </section>
    <!-- blog related post-->
	
	
</main>
<?php ?>
<?php get_footer(); ?>