<?php

/**
 *Template Name: About Page
 */
get_header(); 
$aboutData = get_fields(); 
$aboutOptions = get_fields('options'); ?>
<?php $HeroBannerData = $aboutData['main_hero_banner'] ?? null;
if (isset($HeroBannerData) && is_array($HeroBannerData)) : ?>
<!--- Banner section--->
    <?php include(get_template_directory() . '/includes/hero-banner.php'); ?>
<!--- Banner section--->
<?php endif; ?>
<?php $altImgTxtData = $aboutData['alternate_image_with_text'] ?? null;
if (isset($altImgTxtData) && is_array($altImgTxtData)) : ?>
<!--- Join five river--->
    <?php include(get_template_directory() . '/includes/alternate-image-text.php'); ?>
<!--- End Join five river--->
<?php endif; ?>
<?php $partitionData = $aboutData['partition_stories'] ?? null;
if (isset($partitionData) && is_array($partitionData)) : ?>
<!--partition story-->
<section class="fr-partition-story fr-spacing-top  text-center">
    <div class="container">
        <?php if (isset($partitionData['heading']) && !empty($partitionData['heading'])) : ?>
        <h2><?php echo $partitionData['heading']; ?></h2>
        <?php endif; ?>
        <?php if (isset($partitionData['sub_heading']) && !empty($partitionData['sub_heading'])) : ?>
        <h3><?php echo $partitionData['sub_heading']; ?></h3>
        <?php endif; ?>
        <?php if (isset($partitionData['description']) && !empty($partitionData['description'])) : ?>
        <?php echo $partitionData['description']; ?>
        <?php endif; ?>
        <?php $partitionBtnLabel = $partitionData['button_label'] ?? null;
        if (isset($partitionBtnLabel) && !empty($partitionBtnLabel)) : ?>
        <div class="fr-partition-btn text-center">
            <a href="<?php echo !empty($partitionData['button_link']['url']) ? $partitionData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($partitionData['button_link']['target']) ? $partitionData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $partitionBtnLabel; ?>" class="fr-btn"><span><?php echo $partitionBtnLabel; ?></span></a>
        </div>
        <?php endif; ?>
    </div>
</section>
<!-- end partition story-->
<?php endif; ?>
<?php $missionData = $aboutData['mission_information'] ?? null;
if (isset($missionData) && is_array($missionData)) : ?>
<!-- Mission -->
<section class="fr-partition-story fr-section-extra-spacing text-center">
    <div class="container">
        <div class="row fr-spacing-top fr-join-river-content">
            <div class="fr-partition-mission ">
                <?php if (isset($missionData['heading']) && !empty($missionData['heading'])) : ?>
                <h3><?php echo $missionData['heading']; ?></h3>
                <?php endif; ?>
                <?php if (isset($missionData['description']) && !empty($missionData['description'])) : ?>
                <?php echo $missionData['description']; ?>
                <?php endif; ?>
                <?php if (isset($missionData['team_heading']) && !empty($missionData['team_heading'])) : ?>
                <h3 class="fr-partition-mission-heading"><?php echo $missionData['team_heading']; ?></h3>
                <?php endif; ?>
            </div>
            <?php foreach( ($missionData['team_repeater'] ? $missionData['team_repeater'] : array()) as $teamOption ) : ?>
            <div class="col-md-4">
                <div class="fr-card-item">
                    <?php if (isset($teamOption['name']) && !empty($teamOption['name'])) : ?>
                    <h3><?php echo $teamOption['name']; ?></h3>
                    <?php endif; ?>
                    <?php if (isset($teamOption['about']) && !empty($teamOption['about'])) : ?>
                    <?php echo $teamOption['about']; ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
            
            <div class="col-md-12 fr-spacing-top">
                <?php if (isset($missionData['activities_heading']) && !empty($missionData['activities_heading'])) : ?>
                <h3 class="fr-partition-mission-heading"><?php echo $missionData['activities_heading']; ?></h3>
                <?php endif; ?>
                <ul class="fr-partition-flex-box">
                    <?php foreach( ($missionData['activities_repeater'] ? $missionData['activities_repeater'] : array()) as $activityOption ) : ?>
                        <?php if (isset($activityOption['activty_name']) && !empty($activityOption['activty_name'])) : ?>
                        <li><?php echo $activityOption['activty_name']; ?></li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<!-- end mission-->
<?php endif; ?>
<?php $basicSectionData = $aboutData['basic_image_with_text'] ?? null;
if (isset($basicSectionData) && is_array($basicSectionData)) : ?>
<!--- Join five river--->
<section class="fr-join-river fr-aboutus-join-river">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="fr-join-river-content">
                    <?php if (isset($basicSectionData['heading']) && !empty($basicSectionData['heading'])) : ?>
                    <h3><?php echo $basicSectionData['heading']; ?></h3>
                    <?php endif; ?>
                    <?php if (isset($basicSectionData['description']) && !empty($basicSectionData['description'])) : ?>
                    <?php echo $basicSectionData['description']; ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-5">
            <?php if (isset($basicSectionData['image']) && !empty($basicSectionData['image'])) : ?>
                <div class="fr-join-river-img">
                    <img src="<?php echo $basicSectionData['image']['url']; ?>" alt="<?php echo $basicSectionData['image']['alt']; ?>">
                </div>
            <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!--- End Join five river--->
<?php endif; ?>
<?php $speechData = $aboutOptions['leaders_speech_slider'] ?? null;
$speechHeading = $aboutOptions['leaders_speech_slider'] ?? null;
if (isset($speechData) && is_array($speechData)) : ?>
    <!-- Independence speech slider-->
    <?php include(get_template_directory() . '/includes/speech-slider.php'); ?>
    <!-- Independence speech slider-->
<?php endif; ?>
<?php
get_footer();
?>