<?php

/**
 *Template Name: Gallery Page
 */
get_header(); 
$galleryData = get_fields(); ?>
<?php $HeroBannerData = $galleryData['main_hero_banner'] ?? null;
if (isset($HeroBannerData) && is_array($HeroBannerData)) : ?>
<!--- Banner section--->
    <?php include(get_template_directory() . '/includes/hero-banner.php'); ?>
<!--- Banner section--->
<?php endif; ?>
<?php $ourImagesData = $galleryData['our_images_section'] ?? null;
if (isset($ourImagesData) && is_array($ourImagesData)) : ?>
<!---->
<section class="fr-spacing-top fr-reward-card">
    <div class="container">
        <?php if (isset($ourImagesData['heading']) && !empty($ourImagesData['heading'])) : ?>
        <h2 class="text-center"><?php echo $ourImagesData['heading']; ?></h2>
        <?php endif; ?>
        <div class="gallery-image-slider">
        <?php foreach( ($ourImagesData['image_repeater'] ? $ourImagesData['image_repeater'] : array()) as $imageItem ) : ?>
            <?php if (isset($imageItem['gallery_image']) && !empty($imageItem['gallery_image'])) : ?>
            <div class="carousel-link">
                <img src="<?php echo $imageItem['gallery_image']['url']; ?>" alt="<?php echo $imageItem['gallery_image']['alt']; ?>" class="carousel-image">
            </div>
            <?php endif; ?>
        <?php endforeach; ?>
        </div>
    </div>
</section>
<!---->
<?php endif; ?>
<?php $ourGalleryData = $galleryData['our_videos_section'] ?? null;
if (isset($ourGalleryData) && is_array($ourGalleryData)) : ?>
<!---->
<section class="fr-section-extra-spacing fr-reward-card">
    <div class="container">
        <?php if (isset($ourGalleryData['heading']) && !empty($ourGalleryData['heading'])) : ?>
        <h2 class="text-center"><?php echo $ourGalleryData['heading']; ?></h2>
        <?php endif; ?>
        <div class=" gallery-video-slider">
        <?php foreach( ($ourGalleryData['videos_repater'] ? $ourGalleryData['videos_repater'] : array()) as $galleryItem ) : ?>
            <div class="carousel-link">
                <?php if (isset($galleryItem['video_link']) && !empty($galleryItem['video_link'])) : ?>
                <iframe class="carousel-image" src="<?php echo $galleryItem['video_link']['url']; ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
        
        </div>
        <?php $btnLabel = $ourGalleryData['button_label'] ?? null;
        if (isset($btnLabel) && !empty($btnLabel)) : ?>
             <div class="gallery-video-button">
                <a href="<?php echo !empty($ourGalleryData['button_link']['url']) ? $ourGalleryData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($ourGalleryData['button_link']['target']) ? $ourGalleryData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $btnLabel; ?>" class="fr-btn"><?php echo $btnLabel; ?></a>
            </div>
        <?php endif; ?>
    </div>
</section>
<!---->
<?php endif; ?>
<?php $subscribeData = $galleryData['subscribe_section'] ?? null;
if (isset($subscribeData) && is_array($subscribeData)) : ?>
<!-- Newsletter-->
<section class="fr-newsletter">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-md-6">
            <?php if (isset($subscribeData['image']) && !empty($subscribeData['image'])) : ?>
                <div class="fr-newsletter-img">
                    <img src="<?php echo $subscribeData['image']['url']; ?>" alt="<?php echo $newsletterData['image']['alt']; ?>">
                </div>
            <?php endif; ?>
            </div>
            <div class="col-md-6">
                <div class="fr-newsletter-content">
                    <?php if (isset($subscribeData['heading']) && !empty($subscribeData['heading'])) : ?>
                    <h3><?php echo $subscribeData['heading']; ?></h3>
                    <?php endif; ?>
                    <?php if (isset($subscribeData['description']) && !empty($subscribeData['description'])) : ?>
                    <?php echo $subscribeData['description']; ?>
                    <?php endif; ?>
                    <?php $btnLabel = $subscribeData['button_label'] ?? null;
                    if (isset($btnLabel) && !empty($btnLabel)) : ?>
                    <a href="<?php echo !empty($subscribeData['button_link']['url']) ? $subscribeData['button_link']['url'] : '#0' ?>" target="<?php echo !empty($subscribeData['button_link']['target']) ? $subscribeData['button_link']['target'] : '_self' ?>" aria-label="<?php echo $btnLabel; ?>" class="fr-btn"><span><?php echo $btnLabel; ?></span></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Newsletter-->
<?php endif; ?>
<?php
get_footer();
?>