<?php
/*
Plugin Name: Velocity Functions
Description: Custom functions for Five Star Security Training
Author: Serveropsghq
Author URI: https://velocityhost.com.au
Version: 3
Requires at least: 5
Tested up to: 5.5
Requires PHP: 7.0+
Domain Path: languages
Text Domain: Velocity Digital

INDEX
1: OPTIMISE BEAVER BUILDER
2: CALL CUSTOM JS
3: WORDPRESS MODS
4: WHITE LABEL LOGIN
5: WHITE LABEL ADMIN
6: CPT
7: PLUGIN MODS
*/


// DO NOT LOAD DIRECTLY
	if ( ! defined( 'ABSPATH' ) ) {
		die( '-1' );
	}



/* 1: OPTIMISE BB
||||||||||||||||||||||||||||||| */
	add_action( 'wp_enqueue_scripts', function() {
	
			wp_dequeue_style( 'jquery-magnificpopup' );
			wp_dequeue_script( 'jquery-magnificpopup' );  //Magnific popup: for lightbox effect
			
			wp_dequeue_script( 'bootstrap' ); //Bootstrap script: unless you advanced Bootstrap components, you don’t need its script. 
		/*	wp_dequeue_script( 'imagesloaded' ); //to check whether all images are loaded. Used in 'show more' archive load, BB sticky menu & STRIPE Checkout */
	   		wp_dequeue_script( 'jquery-fitvids' ); // if your website doesn’t have videos, you don’t need this script.
	   	/*	wp_dequeue_script( 'jquery-throttle' ); //to prevent running a JavaScript function continuously. It’s used for scrolling effect and BB sticky menu */
	   		wp_dequeue_script( 'jquery-waypoints' ); //to reveal elements when you scroll. Not needed if your website doesn’t have that effect 
		}, 9999 ); 


// REMOVE BB SCHEMA
	add_filter( 'fl_post_grid_disable_schema', '__return_true' );


// IDENTIFY USED BB MODULES
	add_filter( 'is_module_disable_enabled', '__return_true' );
	
	
// REMOVE BB MODULE ENQUED GOOGLE FONTS
add_filter( 'fl_builder_google_fonts_pre_enqueue', function( $fonts ) {
    return array();
} );

// REMOVE BB THEME ENQUED GOOGLE FONTS
add_action( 'wp_enqueue_scripts', function() {
    global $wp_styles;
    if ( isset( $wp_styles->queue ) ) {
        foreach ( $wp_styles->queue as $key => $handle ) {
            if ( false !== strpos( $handle, 'fl-builder-google-fonts-' ) ) {
                unset( $wp_styles->queue[ $key ] );
            }
        }
    }
}, 101 );



/* 2: CALL CUSTOM JS
|||||||||||||||||||||||||||||||
	function load_my_scripts() {
	    wp_register_script('myscript', get_stylesheet_directory_uri() . '/js/mobilehead.js', array('jquery'), '1.0', false ); //'true' loads into the
	    wp_enqueue_script('myscript');
	}
	
	add_action('init', 'load_my_scripts'); */



/* 3: WP MODS
||||||||||||||||||||||||||||||| */


// DISABLE WP 5.5+ AUTO XML SITEMAP	
	add_filter('wp_sitemaps_enabled', '__return_false');


// DISABLE WP 5.5+ LAZY LOADING
	add_filter('wp_lazy_loading_enabled', '__return_false');


// REMOVE JETPACK BANNERS
	add_filter( 'jetpack_just_in_time_msgs', '__return_false' );


// TURN OFF WP IMAGE COMPRESSION
	add_filter('jpeg_quality', function($arg){return 100;});


// TURN OFF 'Your Site is Experiencing a Technical Issue" NOTICE
	add_filter( 'wp_fatal_error_handler_enabled', '__return_false' );


// TURN OFF MARKETING HUB MENU ITEM
	add_filter( 'woocommerce_marketing_menu_items', '__return_empty_array' );


// TURN OFF MARKETING HUB MENU ITEMS 
	/* gist.github.c o m/isaumya/89f48dcd84cb58af1e668bb76ba2c029 */
	add_filter( 'woocommerce_admin_features', function( $features ) {
			return array_values(
				array_filter( $features, function($feature) {
					return ! in_array( $feature, [ 'marketing', 'activity-panels', 'analytics', 'analytics-dashboard', 'analytics-dashboard/customizable', 'onboarding', 'shipping-label-banner', 'store-alerts', 'wcpay', 'homescreen'  ] );
				} ) 
			);
	} );
	
	
// TURN OFF WP GENERATED IMAGES RESIZING
	function shapeSpace_disable_image_sizes($sizes) {
	
		unset($sizes['thumbnail']);    // disable thumbnail size
		unset($sizes['medium']);       // disable medium size
		unset($sizes['large']);        // disable large size
		unset($sizes['medium_large']); // disable medium-large size
		unset($sizes['1536x1536']);    // disable 2x medium-large size
		unset($sizes['2048x2048']);    // disable 2x large size
	
		return $sizes;
	
	}
	add_action('intermediate_image_sizes_advanced', 'shapeSpace_disable_image_sizes');

	// disable scaled image size
	add_filter('big_image_size_threshold', '__return_false');

	// disable other image sizes
	function shapeSpace_disable_other_image_sizes() {
	
		remove_image_size('post-thumbnail'); // disable images added via set_post_thumbnail_size() 
		remove_image_size('another-size');   // disable any other added image sizes
	
	}
	add_action('init', 'shapeSpace_disable_other_image_sizes');


//IMG UNAUTOP - REMOVE <p> TAG FROM IMAGESs 
	function breezer_addDivToImage( $content ) {

   // A regular expression of what to look for.
	   $pattern = '/(<img([^>]*)>)/i';
   // What to replace it with. $1 refers to the content in the first 'capture group', in parentheses above
	   $replacement = '<div class="Image-bloc">$1</div>';

   // run preg_replace() on the $content
	   $content = preg_replace( $pattern, $replacement, $content );

   // return the processed content
	   return $content;
	}
	add_filter( 'the_content', 'breezer_addDivToImage' );


// REMOVE WIDTH AND HEIGHT FROM IMAGE TAGS
	function remove_image_size_attributes( $html ) {
		return preg_replace( '/(width|height)="\d*"/', '', $html );
	}


// REMOVE IMAGE SIZE ATTRIBUTES FROM THUMBNAILS
	add_filter( 'post_thumbnail_html', 'remove_image_size_attributes' );

 
// REMOVE IMAGE SIZE ATTRIBUTES FROM IMAGES ADDED TO A POST
	add_filter( 'image_send_to_editor', 'remove_image_size_attributes' );


// ADD STYLE TO TinyMCE EDITRO
	function wpb_mce_buttons_2($buttons) {
	    array_unshift($buttons, 'styleselect');
	    return $buttons;
		}
		add_filter('mce_buttons_2', 'wpb_mce_buttons_2');

		function my_mce_before_init_insert_formats( $init_array ) {  
		    $style_formats = array(  
			/* Each array child is a format with it's own settings
			* Notice that each array has title, block, classes, and wrapper arguments
			* Title is the label which will be visible in Formats menu
			* Block defines whether it is a span, div, selector, or inline style
			* Classes allows you to define CSS classes
			* Wrapper whether or not to add a new block-level element around any selected elements */
			array(  
           	 'title' => 'Drop Cap',  
		   	 'inline' => 'span',  
		   	 'classes' => 'drop',
		   	 'wrapper' => true,  
		   	 ),  
		   	 );  
		   	 $init_array['style_formats'] = json_encode( $style_formats );  
     
		   	 return $init_array;     
		} 
	add_filter( 'tiny_mce_before_init', 'my_mce_before_init_insert_formats' );


//ADD EXCERPTS TO PAGES
	add_post_type_support( 'page', 'excerpt' );





//INSERT POST ID COLUMN INTO POST ADMIN 
	function posts_columns_id($defaults){
	    $defaults['wps_post_id'] = __('ID');
	    return $defaults;
		}
	
	    add_filter('manage_posts_columns', 'posts_columns_id', 5);
	    add_action('manage_posts_custom_column', 'posts_custom_id_columns', 5, 2);
	    
	function posts_custom_id_columns($column_name, $id){
	    if($column_name === 'wps_post_id'){
		    
		// RETREVAL POST ID
	            echo $id;
		    }
		}
	add_filter('manage_pages_columns', 'posts_columns_id', 5);
	add_action('manage_pages_custom_column', 'posts_custom_id_columns', 5, 2);

	
// DASHBOARD MEDIA LIB COLUMN URL DISPLAY
	add_filter( 'manage_media_columns', 'sk_media_columns_url' );
	// Filter the Media list table columns to add a URL column. @param array $posts_columns Existing array of columns displayed in the Media list table.
	// @return array Amended array of columns to be displayed in the Media list table.
	 	function sk_media_columns_url( $posts_columns ) {
			$posts_columns['media_url'] = 'URL';
			return $posts_columns;
		}
		add_action( 'manage_media_custom_column', 'sk_media_custom_column_url' );
	// Display URL custom column in the Media list table. @param string $column_name Name of the custom column.
	 	function sk_media_custom_column_url( $column_name ) {
			if ( 'media_url' !== $column_name ) {
				return;
				}
	
				echo '<input type="text" width="100%" onclick="jQuery(this).select();" value="' . wp_get_attachment_url() . '" />';
		}
		add_action( 'admin_print_styles-upload.php', 'sk_url_column_css' );
	// Add custom CSS on Media Library page in WP admin.
			function sk_url_column_css() {
			echo '<style>
					@media only screen and (min-width: 1400px) {
						.fixed .column-media_url {
							width: 15%;
							}
							}
							</style>';
		}


// MEDIA LIB COLUMN FILE SIZE DISPLAY 
	add_filter( 'manage_media_columns', 'sk_media_columns_filesize' );
	// Filter the Media list table columns to add a File Size column. @param array $posts_columns Existing array of columns displayed in the Media list table.
	// @return array Amended array of columns to be displayed in the Media list table.
		function sk_media_columns_filesize( $posts_columns ) {
		$posts_columns['filesize'] = __( 'File Size', 'my-theme-text-domain' );

		return $posts_columns;
		}
	add_action( 'manage_media_custom_column', 'sk_media_custom_column_filesize', 10, 2 );
	// Display File Size custom column in the Media list table. @param string $column_name Name of the custom column. @param int $post_id Current Attachment ID.
		function sk_media_custom_column_filesize( $column_name, $post_id ) {
		if ( 'filesize' !== $column_name ) {
			return;
			}

			$bytes = filesize( get_attached_file( $post_id ) );

			echo size_format( $bytes, 2 );
		}	
		add_action( 'admin_print_styles-upload.php', 'sk_filesize_column_filesize' );
	// Adjust File Size column on Media Library page in WP admin.
		function sk_filesize_column_filesize() {
		echo
		'<style>
			.fixed .column-filesize {
				width: 10%;
				}
				</style>';
	}




/* 4: ONLY WHITE LABEL: CUSTOM LOGIN PAGE
||||||||||||||||||||||||||||||| */

// OVERRIDE DEFAULT CSS > INSERT CUSTOM
	function my_login_stylesheet() 
	{
	    wp_enqueue_style( 'login-head', 'https://fivestartraining.edu.au/wp-content/themes/assets/css/style-login.css', false );
		}
	add_action( 'login_enqueue_scripts', 'my_login_stylesheet' );


// POINT LOGO TO HOMEPAGE NOT WP
	function my_login_logo_url() {
	    return get_bloginfo( 'url' );
		}
		add_filter( 'login_headerurl', 'my_login_logo_url' );
	
	function my_login_logo_url_title() {
	    return 'The Silent';
		}
	add_filter( 'login_headertitle', 'my_login_logo_url_title' );


// CUSTOM LINK AT BOTTOM OF LOGIN
	function my_loginfooter() { ?>
	    <p style="text-align: center; margin-top: 1em;">
	    	<a style="color: #ffffff; text-decoration: none;" href="https://fivestartraining.edu.au/">If you have any questions, visit our site</a>
	    </p>
		<?php }
	add_action('login_footer','my_loginfooter');



/* 5: ONLY WHITE LABEL CUSTOM ADMINISTRATION
||||||||||||||||||||||||||||||| */

// UPDATE CSS IN ADMIN - LOCAL CALL
	function admin_style() {
	  wp_enqueue_style('admin-styles', 'https://fivestartraining.edu.au/wp-content/themes/assets/css/admin.css');
		}
	add_action('admin_enqueue_scripts', 'admin_style');


// CALL MANAGED CLIENT ADMIN CSS - MAXIO CALL
	function fully_managed_style() {
	  wp_enqueue_style('fully-managed-styles', 'https://fivestartraining.edu.au/wp-content/themes/assets/css/fully-managed.css');
		}
	add_action('admin_enqueue_scripts', 'fully_managed_style');


// DASHBOARD WHITE LABEL BRANDING
	function admin_logo() {
	     echo '<img src="" style="padding-top:20px;"/>';
	 }
	add_action( 'admin_notices', 'admin_logo' );


// DASHBOARD WELCOME MESSAGE
	function my_custom_dashboard_name(){
	        if ( $GLOBALS['title'] != 'Dashboard' ){
	            return;
	        }
	
	        $GLOBALS['title'] =  __( 'Welcome to Five Star Security!' );
		}
	add_action( 'admin_head', 'my_custom_dashboard_name' );


// DASHBOARD FOOTER CUSTOM ADMIN
	function modify_footer_admin () {
	  	echo 'Provided by: ';
	  	echo '<a href="https://www.velocityhost.com.au/digital/"> Velocity Digital </a> | ';
		}
	add_filter('admin_footer_text', 'modify_footer_admin');


// RENAME USER ROLES
	function change_role_name() {
	    global $wp_roles;
	 
	    if ( ! isset( $wp_roles ) )
	        $wp_roles = new WP_Roles();
	 
	    //You can list all currently available roles like this...
	    //$roles = $wp_roles->get_names();
	    //print_r($roles);
	 
	    //You can replace "administrator" with any other role "editor", "author", "contributor" or "subscriber"...
	    $wp_roles->roles['administrator']['name'] = 'Key Master';
	    $wp_roles->role_names['administrator'] = 'Key Master';
	    $wp_roles->roles['editor']['name'] = 'Owner';
	    $wp_roles->role_names['editor'] = 'Owner'; 
		}
	add_action('init', 'change_role_name');


// REMOVE USER ROLES	 
	function remove_built_in_roles() {
	    global $wp_roles;
	 
	    $roles_to_remove = array('subscriber', 'contributor', 'author');
	 
	    foreach ($roles_to_remove as $role) {
	        if (isset($wp_roles->roles[$role])) {
	            $wp_roles->remove_role($role);
	        }
	    }
	}
	add_action('admin_menu', 'remove_built_in_roles');

		
/* 6: CPT 
||||||||||||||||||||||||||||||| */
	// Our custom post type function
	function create_posttype_1() {
	 
	    register_post_type( 'Courses',
	    // CPT Options
	        array(
	            'labels' => array(
	                'name' => __( 'Courses' ),
	                'singular_name' => __( 'Courses' )
					),
	            'public' => true,
	            'has_archive' => true,
	            'rewrite' => array('slug' => 'courses'),
		        )
		    );
		}
	// Hooking up our function to theme setup
	add_action( 'init', 'create_posttype_1' );
 
	function custom_post_type_1() {
 
 	// Set UI labels for Custom Post Type
    $labels = array(
        'name'                	=> _x( 'Courses', 'Post Type General Name', 'CPT THEME NAME' ),
        'singular_name'       	=> _x( 'Courses', 'Post Type Singular Name', 'CPT THEME NAME' ),
        'attributes'       		=> _x( 'Courses', 'Page Attributes', 'CPT THEME NAME' ),
        'menu_name'           	=> __( 'Courses', 'CPT THEME NAME' ),
        'parent_item_colon'   	=> __( 'Parent Courses', 'CPT THEME NAME' ),
        'all_items'           	=> __( 'All Courses', 'CPT THEME NAME' ),
        'view_item'           	=> __( 'View Courses', 'CPT THEME NAME' ),
        'add_new_item'        	=> __( 'Add New Courses', 'CPT THEME NAME' ),
        'add_new'            	=> __( 'Add New Courses', 'CPT THEME NAME' ),
        'edit_item'           	=> __( 'Edit Courses', 'CPT THEME NAME' ),
        'update_item'         	=> __( 'Update Courses', 'CPT THEME NAME' ),
        'search_items'        	=> __( 'Search Courses', 'CPT THEME NAME' ),
        'not_found'           	=> __( 'Not Found', 'CPT THEME NAME' ),
        'not_found_in_trash'  	=> __( 'Not found in Trash', 'CPT THEME NAME' ),
		);       
	// Set other options for Custom Post Type     
    $args = array(
        'label'               	=> __( 'Courses', 'fst_2021r0' ),
        'description'         	=> __( 'Courses', 'fst_2021r0' ),
        
        'labels'              	=> $labels,
        
        'supports'            	=> array( 'comments', 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'revisions', 'custom-fields', 'page-attributes','parent', 'post-formats'),
        
        'taxonomies'          	=> array( 'Courses' ),
         
        'hierarchical'        	=> true,
        'public'              	=> true,
        'show_ui'             	=> true,
        'show_in_menu'        	=> true,
        'show_in_nav_menus'   	=> true,
        'show_in_admin_bar'   	=> true,
        'menu_position'       	=> 1,
        'can_export'          	=> true,
        'has_archive'         	=> true,
        'pages'         			=> true,
        'exclude_from_search' 	=> false,
        'publicly_queryable'  	=> true,
        'capability_type'     	=> 'post',
		'taxonomies' 			=> array('category', 'post_tag'),
		'show_in_rest' => true,

		);  
    // Registering your Custom Post Type
   	 register_post_type( 'Courses', $args );
		}
	add_action( 'init', 'custom_post_type_1', 0 );
	
	
/* 7: PLUGIN TWEAKS AFTER HERE
||||||||||||||||||||||||||||||| */


  
/* Stop Adding Functions Below this Line */
?>